/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.j2ee.deployserver;

import com.caucho.config.Config;
import com.caucho.config.ConfigException;
import com.caucho.hessian.io.HessianInput;
import com.caucho.hessian.io.HessianOutput;
import com.caucho.j2ee.deployclient.DeploymentStatusImpl;
import com.caucho.j2ee.deployclient.ProgressObjectImpl;
import com.caucho.j2ee.deployclient.TargetImpl;
import com.caucho.j2ee.deployclient.TargetModuleIDImpl;
import com.caucho.j2ee.deployserver.DeploymentPlan;
import com.caucho.jmx.Jmx;
import com.caucho.log.Log;
import com.caucho.server.host.mbean.HostMBean;
import com.caucho.util.CharBuffer;
import com.caucho.util.IntMap;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.WriteStream;
import com.caucho.xml.XmlPrinter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.status.ProgressObject;
import javax.management.ObjectName;
import javax.servlet.GenericServlet;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.w3c.dom.Node;

public class DeployServlet
extends GenericServlet {
    private static final L10N L = new L10N(DeployServlet._resin_compat_class_2());
    private static final Logger log = Log.open(DeployServlet._resin_compat_class_2());
    private static final int GET_TARGETS = 1;
    private static final int DISTRIBUTE = 2;
    private static final int GET_AVAILABLE_MODULES = 3;
    private static final int UNDEPLOY = 4;
    private static final IntMap _methodMap = new IntMap();
    private TargetImpl _target;
    private TargetImpl[] _targets;
    private Path _deployPath;
    private HostMBean _hostMBean;
    private static Class _resin_compat_class_0;
    private static Class _resin_compat_class_1;
    private static Class _resin_compat_class_2;

    public void setDeployPath(Path path) {
        this._deployPath = path;
    }

    public void init() throws ServletException {
        try {
            this._target = new TargetImpl("Resin-target", "default target");
            this._targets = new TargetImpl[]{this._target};
            if (this._deployPath == null) {
                throw new ServletException(L.l("<deploy-path> is required."));
            }
            this._deployPath.mkdirs();
            ObjectName hostName = new ObjectName("resin:type=CurrentHost");
            this._hostMBean = (HostMBean)Jmx.find(hostName);
        }
        catch (ServletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(ServletRequest req, ServletResponse res) throws IOException, ServletException {
        ServletInputStream is = req.getInputStream();
        ServletOutputStream os = res.getOutputStream();
        HessianInput in = new HessianInput((InputStream)is);
        HessianOutput out = new HessianOutput((OutputStream)os);
        in.readCall();
        String method = in.readMethod();
        try {
            switch (_methodMap.get(method)) {
                case 1: {
                    in.completeCall();
                    out.startReply();
                    out.writeObject(this._targets);
                    out.completeReply();
                    break;
                }
                case 3: {
                    String type = in.readString();
                    in.completeCall();
                    out.startReply();
                    out.writeObject(this.getAvailableModules(type));
                    out.completeReply();
                    break;
                }
                case 2: {
                    TargetImpl[] targets = (TargetImpl[])in.readObject(DeployServlet._resin_compat_class_1());
                    DeploymentPlan plan = new DeploymentPlan();
                    InputStream planIs = in.readInputStream();
                    try {
                        new Config().configure((Object)plan, planIs);
                    }
                    finally {
                        planIs.close();
                    }
                    InputStream archiveIs = in.readInputStream();
                    ProgressObject po = this.distribute(targets, plan, archiveIs);
                    in.completeCall();
                    out.startReply();
                    System.out.println(new CharBuffer().append("STATUS: ").append(po.getDeploymentStatus().isFailed()).toString());
                    out.writeObject(po);
                    out.completeReply();
                    break;
                }
                case 4: {
                    TargetModuleID[] targetIDs = (TargetModuleID[])in.readObject(DeployServlet._resin_compat_class_0());
                    ProgressObject po = this.undeploy(targetIDs);
                    in.completeCall();
                    out.startReply();
                    out.writeObject(po);
                    out.completeReply();
                    break;
                }
                default: {
                    out.startReply();
                    out.writeFault("UnknownMethod", new CharBuffer().append("UnknownMethod: ").append(method).toString(), null);
                    out.completeReply();
                    break;
                }
            }
        }
        catch (Exception e) {
            out.startReply();
            out.writeFault(e.toString(), e.toString(), e);
            out.completeReply();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProgressObject distribute(TargetImpl[] targets, DeploymentPlan plan, InputStream archiveIs) throws IOException {
        if (archiveIs == null) {
            return null;
        }
        Path path = this._deployPath.lookup(plan.getArchiveName());
        WriteStream os = path.openWrite();
        try {
            os.writeStream(archiveIs);
        }
        finally {
            os.close();
        }
        this._hostMBean.expandEarDeploy(plan.getName());
        Path metaPath = this._deployPath.lookup(plan.getMetaPathName());
        System.out.println(new CharBuffer().append("META:").append(metaPath).toString());
        ArrayList<DeploymentPlan.ExtFile> _extFileList = plan.getExtFileList();
        System.out.println(new CharBuffer().append("EXT: ").append(_extFileList).toString());
        for (int i = 0; i < _extFileList.size(); ++i) {
            DeploymentPlan.ExtFile extFile = _extFileList.get(i);
            Path filePath = metaPath.lookup(extFile.getName());
            Node node = extFile.getData();
            filePath.getParent().mkdirs();
            System.out.println(new CharBuffer().append("FILE:").append(filePath).toString());
            XmlPrinter.print(filePath, node);
        }
        log.info(new CharBuffer().append("deploying: ").append(plan.getName()).toString());
        Throwable configException = null;
        try {
            this._hostMBean.startEarDeploy(plan.getName());
            this._hostMBean.updateWebAppDeploy(new CharBuffer().append("/").append(plan.getName()).toString());
        }
        catch (Throwable e) {
            configException = e;
            log.log(Level.FINE, e.toString(), e);
            System.out.println(new CharBuffer().append("--- Exception: ").append(e).toString());
        }
        TargetModuleIDImpl id = new TargetModuleIDImpl(targets[0], plan.getArchiveName());
        ProgressObjectImpl progress = new ProgressObjectImpl(new TargetModuleID[]{id});
        DeploymentStatusImpl status = new DeploymentStatusImpl();
        progress.setDeploymentStatus(status);
        System.out.println(new CharBuffer().append("CONFIG-EXCEPTION: ").append(configException).toString());
        if (configException != null) {
            status.setFailed(true);
            if (configException instanceof ConfigException) {
                status.setMessage(configException.getMessage());
            } else {
                status.setMessage(configException.toString());
            }
        }
        return progress;
    }

    private TargetModuleID[] getAvailableModules(String type) throws IOException {
        TargetImpl target = this._targets[0];
        System.out.println(new CharBuffer().append("MODES: ").append(type).toString());
        ArrayList<TargetModuleIDImpl> idList = new ArrayList<TargetModuleIDImpl>();
        String[] list = this._deployPath.list();
        for (int i = 0; i < list.length; ++i) {
            TargetModuleIDImpl id;
            String name = list[i];
            Path path = this._deployPath.lookup(name);
            if (type.equals("war") && name.endsWith(".war")) {
                id = new TargetModuleIDImpl(target, name);
                if (idList.contains(id)) continue;
                idList.add(id);
                continue;
            }
            if (type.equals("war") && path.isDirectory() && !name.startsWith("_")) {
                id = new TargetModuleIDImpl(target, name = new CharBuffer().append(name).append(".war").toString());
                if (idList.contains(id)) continue;
                idList.add(id);
                continue;
            }
            if (type.equals("rar") && name.endsWith(".rar")) {
                id = new TargetModuleIDImpl(target, name);
                if (idList.contains(id)) continue;
                idList.add(id);
                continue;
            }
            if (!type.equals("rar") || !path.isDirectory() || !name.startsWith("_rar_") || idList.contains(id = new TargetModuleIDImpl(target, name = new CharBuffer().append(name.substring(5)).append(".rar").toString()))) continue;
            idList.add(id);
        }
        TargetModuleID[] idArray = new TargetModuleID[idList.size()];
        idList.toArray(idArray);
        return idArray;
    }

    private ProgressObject undeploy(TargetModuleID[] ids) throws IOException {
        if (ids == null || ids.length == 0) {
            return null;
        }
        this.stop(ids);
        for (int i = 0; i < ids.length; ++i) {
            String name = ids[i].getModuleID();
            this._deployPath.lookup(name).remove();
            if (name.endsWith(".war")) {
                name = name.substring(0, name.length() - 4);
                this._deployPath.lookup(name).removeAll();
            } else if (name.endsWith(".ear")) {
                name = new CharBuffer().append("_ear_").append(name.substring(0, name.length() - 4)).toString();
                this._deployPath.lookup(name).removeAll();
            } else if (name.endsWith(".rar")) {
                name = new CharBuffer().append("_rar_").append(name.substring(0, name.length() - 4)).toString();
                this._deployPath.lookup(name).removeAll();
            }
            Throwable configException = null;
            try {
                this._hostMBean.updateWebAppDeploy(name);
                continue;
            }
            catch (Throwable e) {
                log.log(Level.FINE, e.toString(), e);
                configException = e;
            }
        }
        return new ProgressObjectImpl(ids);
    }

    private void stop(TargetModuleID[] targets) throws IOException {
    }

    static {
        _methodMap.put("getTargets", 1);
        _methodMap.put("distribute", 2);
        _methodMap.put("getAvailableModules", 3);
        _methodMap.put("undeploy", 4);
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("[Lcom.caucho.j2ee.deployclient.TargetModuleIDImpl;");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_1() {
        try {
            Class<?> clazz = _resin_compat_class_1;
            if (clazz == null) {
                clazz = _resin_compat_class_1 = Class.forName("[Lcom.caucho.j2ee.deployclient.TargetImpl;");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_2() {
        try {
            Class<?> clazz = _resin_compat_class_2;
            if (clazz == null) {
                clazz = _resin_compat_class_2 = Class.forName("com.caucho.j2ee.deployserver.DeployServlet");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

