/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.iiop;

import com.caucho.iiop.AbstractBaseTypeCode;
import com.caucho.iiop.IiopReader;
import com.caucho.iiop.ValueBoxTypeCode;
import com.caucho.log.Log;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.io.IOException;
import java.util.logging.Logger;
import org.omg.CORBA.Any;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.TypeCodePackage.Bounds;

public class TypeCodeImpl
extends TypeCode {
    protected static final L10N L = new L10N(TypeCodeImpl._resin_compat_class_0());
    protected static final Logger log = Log.open(TypeCodeImpl._resin_compat_class_0());
    public static final int TK_NULL = 0;
    public static final int TK_VOID = 1;
    public static final int TK_SHORT = 2;
    public static final int TK_LONG = 3;
    public static final int TK_USHORT = 4;
    public static final int TK_ULONG = 5;
    public static final int TK_FLOAT = 6;
    public static final int TK_DOUBLE = 7;
    public static final int TK_BOOLEAN = 8;
    public static final int TK_CHAR = 9;
    public static final int TK_OCTET = 10;
    public static final int TK_ANY = 11;
    public static final int TK_TYPE_CODE = 12;
    public static final int TK_PRINCIPAL = 13;
    public static final int TK_OBJREF = 14;
    public static final int TK_UNION = 16;
    public static final int TK_ENUM = 17;
    public static final int TK_STRING = 18;
    public static final int TK_SEQUENCE = 19;
    public static final int TK_ARRAY = 20;
    public static final int TK_ALIAS = 21;
    public static final int TK_EXCEPT = 22;
    public static final int TK_LONGLONG = 23;
    public static final int TK_ULONGLONG = 24;
    public static final int TK_LONGDOUBLE = 25;
    public static final int TK_WCHAR = 26;
    public static final int TK_WSTRING = 27;
    public static final int TK_FIXED = 28;
    public static final int TK_VALUE = 29;
    public static final int TK_VALUE_BOX = 30;
    public static final int TK_NATIVE = 31;
    public static final int TK_ABSTRACT_INTERFACE = 32;
    private TCKind _kind;
    private static Class _resin_compat_class_0;

    TypeCodeImpl(TCKind kind) {
        if (kind == null) {
            throw new NullPointerException();
        }
        this._kind = kind;
    }

    public boolean equal(TypeCode tc) {
        return tc == this;
    }

    public boolean equivalent(TypeCode tc) {
        return tc == this;
    }

    public TypeCode get_compact_typecode() {
        return this;
    }

    public TCKind kind() {
        return this._kind;
    }

    public String id() throws BadKind {
        throw new UnsupportedOperationException();
    }

    public String name() throws BadKind {
        throw new UnsupportedOperationException();
    }

    public int member_count() throws BadKind {
        throw new UnsupportedOperationException();
    }

    public String member_name(int index) throws BadKind, Bounds {
        throw new UnsupportedOperationException();
    }

    public TypeCode member_type(int index) throws BadKind, Bounds {
        throw new UnsupportedOperationException();
    }

    public Any member_label(int index) throws BadKind, Bounds {
        throw new UnsupportedOperationException();
    }

    public TypeCode discriminator_type() throws BadKind {
        throw new UnsupportedOperationException();
    }

    public int default_index() throws BadKind {
        throw new UnsupportedOperationException();
    }

    public int length() throws BadKind {
        throw new UnsupportedOperationException();
    }

    public TypeCode content_type() throws BadKind {
        throw new UnsupportedOperationException();
    }

    public short fixed_digits() throws BadKind {
        throw new UnsupportedOperationException();
    }

    public short fixed_scale() throws BadKind {
        throw new UnsupportedOperationException();
    }

    public short member_visibility(int index) throws BadKind, Bounds {
        throw new UnsupportedOperationException();
    }

    public short type_modifier() throws BadKind {
        throw new UnsupportedOperationException();
    }

    public TypeCode concrete_base_type() throws BadKind {
        throw new UnsupportedOperationException();
    }

    public static TypeCodeImpl read(IiopReader reader) throws IOException {
        int tcKind = reader.readInt();
        switch (tcKind) {
            case 30: {
                int len = reader.read_sequence_length();
                byte endian = reader.read_octet();
                String repId = reader.readString();
                String name = reader.readString();
                TypeCode typeCode = reader.read_TypeCode();
                return new ValueBoxTypeCode(TCKind.from_int((int)tcKind), typeCode);
            }
            case 32: {
                int len = reader.read_sequence_length();
                int offset = reader.getOffset();
                int tail = offset + len;
                byte endian = reader.read_octet();
                String repId = reader.readString();
                String name = reader.readString();
                return new AbstractBaseTypeCode(TCKind.from_int((int)tcKind));
            }
            case 18: {
                int maxLen = reader.read_ulong();
                log.info(new CharBuffer().append("string len: ").append(maxLen).toString());
                return new TypeCodeImpl(TCKind.from_int((int)tcKind));
            }
            case -1: {
                throw new UnsupportedOperationException("INDIRECTION");
            }
        }
        throw new UnsupportedOperationException();
    }

    public Object readValue(IiopReader reader) throws IOException {
        switch (this._kind.value()) {
            case 18: {
                return reader.read_string();
            }
            case 27: {
                return reader.read_wstring();
            }
            case 32: {
                return reader.read_abstract_interface();
            }
        }
        throw new UnsupportedOperationException(this._kind.toString());
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.iiop.TypeCodeImpl");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

