/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.iiop;

import com.caucho.ejb.AbstractEJBObject;
import com.caucho.ejb.AbstractServer;
import com.caucho.iiop.DummyObjectImpl;
import com.caucho.iiop.IOR;
import com.caucho.iiop.IiopReader;
import com.caucho.iiop.IiopWriter;
import com.caucho.log.Log;
import com.caucho.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.logging.Logger;
import javax.rmi.CORBA.Util;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.OutputStream;

public class MarshallObject {
    private static final Logger log = Log.open(MarshallObject._resin_compat_class_16());
    public static final int VOID = -1;
    public static final int BOOLEAN = 0;
    public static final int BYTE = 1;
    public static final int SHORT = 2;
    public static final int CHAR = 3;
    public static final int INT = 4;
    public static final int LONG = 5;
    public static final int FLOAT = 6;
    public static final int DOUBLE = 7;
    public static final int STRING = 8;
    public static final int BOOLEAN_ARRAY = 9;
    public static final int BYTE_ARRAY = 10;
    public static final int SHORT_ARRAY = 11;
    public static final int CHAR_ARRAY = 12;
    public static final int INT_ARRAY = 13;
    public static final int LONG_ARRAY = 14;
    public static final int FLOAT_ARRAY = 15;
    public static final int DOUBLE_ARRAY = 16;
    public static final int STRING_ARRAY = 17;
    public static final int OBJECT = 20;
    public static final int CORBA_OBJECT = 21;
    public static final int REMOTE = 22;
    public static final int EJB_HOME = 23;
    public static final int EJB_OBJECT = 24;
    public static final int OBJECT_ARRAY = 25;
    public static final int OBJECT_HELPER = 26;
    private int _code;
    private Class objClass;
    private MarshallObject subObj;
    private Method readHelper;
    private Method writeHelper;
    private static Class _resin_compat_class_0;
    private static Class _resin_compat_class_1;
    private static Class _resin_compat_class_2;
    private static Class _resin_compat_class_3;
    private static Class _resin_compat_class_4;
    private static Class _resin_compat_class_5;
    private static Class _resin_compat_class_6;
    private static Class _resin_compat_class_7;
    private static Class _resin_compat_class_8;
    private static Class _resin_compat_class_9;
    private static Class _resin_compat_class_10;
    private static Class _resin_compat_class_11;
    private static Class _resin_compat_class_12;
    private static Class _resin_compat_class_13;
    private static Class _resin_compat_class_14;
    private static Class _resin_compat_class_15;
    private static Class _resin_compat_class_16;

    private MarshallObject(int code) {
        this._code = code;
    }

    private MarshallObject(int code, Class cl) {
        this._code = code;
        this.objClass = cl;
    }

    private MarshallObject(int code, Class cl, Method readHelper, Method writeHelper) {
        this._code = code;
        this.objClass = cl;
        this.readHelper = readHelper;
        this.writeHelper = writeHelper;
    }

    static MarshallObject create(Class cl, boolean isJava) {
        if (Void.TYPE.equals(cl)) {
            return new MarshallObject(-1);
        }
        if (Boolean.TYPE.equals(cl) || MarshallObject._resin_compat_class_0().equals(cl)) {
            return new MarshallObject(0);
        }
        if (Byte.TYPE.equals(cl) || MarshallObject._resin_compat_class_1().equals(cl)) {
            return new MarshallObject(1);
        }
        if (Short.TYPE.equals(cl) || MarshallObject._resin_compat_class_2().equals(cl)) {
            return new MarshallObject(2);
        }
        if (Character.TYPE.equals(cl) || MarshallObject._resin_compat_class_3().equals(cl)) {
            return new MarshallObject(3);
        }
        if (Integer.TYPE.equals(cl) || MarshallObject._resin_compat_class_4().equals(cl)) {
            return new MarshallObject(4);
        }
        if (Long.TYPE.equals(cl) || MarshallObject._resin_compat_class_5().equals(cl)) {
            return new MarshallObject(5);
        }
        if (Float.TYPE.equals(cl) || MarshallObject._resin_compat_class_6().equals(cl)) {
            return new MarshallObject(6);
        }
        if (Double.TYPE.equals(cl) || MarshallObject._resin_compat_class_7().equals(cl)) {
            return new MarshallObject(7);
        }
        if (MarshallObject._resin_compat_class_8().equals(cl)) {
            return new MarshallObject(8);
        }
        if (MarshallObject._resin_compat_class_9().equals(cl) && !isJava) {
            return new MarshallObject(17);
        }
        if (MarshallObject._resin_compat_class_10().isAssignableFrom(cl)) {
            return new MarshallObject(23, cl);
        }
        if (MarshallObject._resin_compat_class_11().isAssignableFrom(cl)) {
            return new MarshallObject(24, cl);
        }
        if (MarshallObject._resin_compat_class_12().isAssignableFrom(cl)) {
            return new MarshallObject(22, cl);
        }
        if (MarshallObject._resin_compat_class_13().isAssignableFrom(cl)) {
            return new MarshallObject(21, cl);
        }
        if (cl.isArray() && !isJava) {
            Class<?> compType = cl.getComponentType();
            MarshallObject subObj = MarshallObject.create(compType, isJava);
            MarshallObject obj = new MarshallObject(25, compType);
            obj.subObj = subObj;
            return obj;
        }
        Class helperClass = null;
        Method readHelper = null;
        Method writeHelper = null;
        try {
            helperClass = CauchoSystem.loadClass(new CharBuffer().append(cl.getName()).append("Helper").toString());
            readHelper = helperClass.getMethod("read", MarshallObject._resin_compat_class_14());
            writeHelper = helperClass.getMethod("write", MarshallObject._resin_compat_class_15(), cl);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (readHelper != null) {
            return new MarshallObject(26, cl, readHelper, writeHelper);
        }
        return new MarshallObject(20, cl);
    }

    public java.lang.Object unmarshall(IiopReader reader) throws Exception {
        switch (this._code) {
            case 0: {
                return new Boolean(reader.read_boolean());
            }
            case 1: {
                return new Byte(reader.read_octet());
            }
            case 2: {
                return new Short(reader.read_short());
            }
            case 3: {
                return new Character(reader.read_wchar());
            }
            case 4: {
                return new Integer(reader.read_long());
            }
            case 5: {
                return new Long(reader.read_longlong());
            }
            case 6: {
                return new Float(reader.read_float());
            }
            case 7: {
                return new Double(reader.read_double());
            }
            case 8: {
                return (String)((java.lang.Object)reader.read_value(MarshallObject._resin_compat_class_8()));
            }
            case 9: {
                boolean[] array = new boolean[reader.read_sequence_length()];
                reader.read_boolean_array(array, 0, array.length);
                return array;
            }
            case 10: {
                byte[] array = new byte[reader.read_sequence_length()];
                reader.read_octet_array(array, 0, array.length);
                return array;
            }
            case 12: {
                char[] array = new char[reader.read_sequence_length()];
                reader.read_wchar_array(array, 0, array.length);
                return array;
            }
            case 11: {
                short[] array = new short[reader.read_sequence_length()];
                reader.read_short_array(array, 0, array.length);
                return array;
            }
            case 13: {
                int[] array = new int[reader.read_sequence_length()];
                reader.read_long_array(array, 0, array.length);
                return array;
            }
            case 14: {
                long[] array = new long[reader.read_sequence_length()];
                reader.read_longlong_array(array, 0, array.length);
                return array;
            }
            case 15: {
                float[] array = new float[reader.read_sequence_length()];
                reader.read_float_array(array, 0, array.length);
                return array;
            }
            case 16: {
                double[] array = new double[reader.read_sequence_length()];
                reader.read_double_array(array, 0, array.length);
                return array;
            }
            case 22: {
                return reader.readObject(this.objClass);
            }
            case 21: {
                return reader.read_Object();
            }
            case 25: {
                int len = reader.read_sequence_length();
                java.lang.Object[] obj = (java.lang.Object[])Array.newInstance(this.objClass, len);
                for (int i = 0; i < len; ++i) {
                    obj[i] = this.subObj.unmarshall(reader);
                }
                return obj;
            }
            case 26: {
                return this.readHelper.invoke(null, new java.lang.Object[]{reader});
            }
        }
        try {
            log.info(new CharBuffer().append("Class: ").append(this.objClass).toString());
            return reader.read_value(this.objClass);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void marshall(java.lang.Object obj, IiopWriter writer) throws Exception {
        switch (this._code) {
            case 0: {
                writer.write_boolean((Boolean)obj);
                break;
            }
            case 1: {
                writer.write_octet((Byte)obj);
                break;
            }
            case 2: {
                writer.write_short((Short)obj);
                break;
            }
            case 4: {
                writer.write_long((Integer)obj);
                break;
            }
            case 5: {
                writer.write_longlong((Long)obj);
                break;
            }
            case 6: {
                writer.write_float(((Float)obj).floatValue());
                break;
            }
            case 7: {
                writer.write_double((Double)obj);
                break;
            }
            case 3: {
                writer.write_wchar(((Character)obj).charValue());
                break;
            }
            case 8: {
                writer.write_value((Serializable)((java.lang.Object)((String)obj)), MarshallObject._resin_compat_class_8());
                break;
            }
            case 22: 
            case 24: {
                if (obj instanceof AbstractEJBObject) {
                    AbstractEJBObject absObj = (AbstractEJBObject)obj;
                    AbstractServer server = absObj.__caucho_getServer();
                    String local = absObj.__caucho_getId();
                    String url = new CharBuffer().append(server.getEJBName()).append("?").append(local).toString();
                    String typeName = new CharBuffer().append("RMI:").append(this.objClass.getName()).append(":0").toString();
                    IOR ior = new IOR(typeName, writer.getHost(), writer.getPort(), url);
                    writer.write_Object((Object)new DummyObjectImpl(ior));
                    break;
                }
                writer.write_value((Serializable)obj);
                break;
            }
            case 23: {
                Util.writeRemoteObject((OutputStream)writer, (java.lang.Object)obj);
                break;
            }
            case 21: {
                writer.write_Object((Object)obj);
                break;
            }
            case 26: {
                this.writeHelper.invoke(null, new java.lang.Object[]{writer, obj});
                break;
            }
            default: {
                writer.write_value((Serializable)obj);
            }
        }
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("java.lang.Boolean");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_1() {
        try {
            Class<?> clazz = _resin_compat_class_1;
            if (clazz == null) {
                clazz = _resin_compat_class_1 = Class.forName("java.lang.Byte");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_2() {
        try {
            Class<?> clazz = _resin_compat_class_2;
            if (clazz == null) {
                clazz = _resin_compat_class_2 = Class.forName("java.lang.Short");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_3() {
        try {
            Class<?> clazz = _resin_compat_class_3;
            if (clazz == null) {
                clazz = _resin_compat_class_3 = Class.forName("java.lang.Character");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_4() {
        try {
            Class<?> clazz = _resin_compat_class_4;
            if (clazz == null) {
                clazz = _resin_compat_class_4 = Class.forName("java.lang.Integer");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_5() {
        try {
            Class<?> clazz = _resin_compat_class_5;
            if (clazz == null) {
                clazz = _resin_compat_class_5 = Class.forName("java.lang.Long");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_6() {
        try {
            Class<?> clazz = _resin_compat_class_6;
            if (clazz == null) {
                clazz = _resin_compat_class_6 = Class.forName("java.lang.Float");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_7() {
        try {
            Class<?> clazz = _resin_compat_class_7;
            if (clazz == null) {
                clazz = _resin_compat_class_7 = Class.forName("java.lang.Double");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_8() {
        try {
            Class<?> clazz = _resin_compat_class_8;
            if (clazz == null) {
                clazz = _resin_compat_class_8 = Class.forName("java.lang.String");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_9() {
        try {
            Class<?> clazz = _resin_compat_class_9;
            if (clazz == null) {
                clazz = _resin_compat_class_9 = Class.forName("[Ljava.lang.String;");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_10() {
        try {
            Class<?> clazz = _resin_compat_class_10;
            if (clazz == null) {
                clazz = _resin_compat_class_10 = Class.forName("javax.ejb.EJBHome");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_11() {
        try {
            Class<?> clazz = _resin_compat_class_11;
            if (clazz == null) {
                clazz = _resin_compat_class_11 = Class.forName("javax.ejb.EJBObject");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_12() {
        try {
            Class<?> clazz = _resin_compat_class_12;
            if (clazz == null) {
                clazz = _resin_compat_class_12 = Class.forName("java.rmi.Remote");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_13() {
        try {
            Class<?> clazz = _resin_compat_class_13;
            if (clazz == null) {
                clazz = _resin_compat_class_13 = Class.forName("org.omg.CORBA.Object");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_14() {
        try {
            Class<?> clazz = _resin_compat_class_14;
            if (clazz == null) {
                clazz = _resin_compat_class_14 = Class.forName("org.omg.CORBA.portable.InputStream");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_15() {
        try {
            Class<?> clazz = _resin_compat_class_15;
            if (clazz == null) {
                clazz = _resin_compat_class_15 = Class.forName("org.omg.CORBA.portable.OutputStream");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_16() {
        try {
            Class<?> clazz = _resin_compat_class_16;
            if (clazz == null) {
                clazz = _resin_compat_class_16 = Class.forName("com.caucho.iiop.MarshallObject");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

