/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.iiop;

import com.caucho.iiop.DummyObjectImpl;
import com.caucho.iiop.IOR;
import com.caucho.iiop.IiopReader;
import com.caucho.iiop.MessageWriter;
import com.caucho.util.Alarm;
import com.caucho.util.CharBuffer;
import com.caucho.util.IdentityIntMap;
import java.io.IOException;
import java.io.Serializable;
import javax.rmi.CORBA.Util;
import javax.rmi.CORBA.ValueHandler;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Principal;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;
import org.omg.SendingContext.RunTime;

public abstract class IiopWriter
extends OutputStream {
    protected static final int VALUE_TAG = 0x7FFFFF00;
    protected static final int VALUE_HAS_CODESET = 1;
    protected static final int VALUE_NO_TYPE = 0;
    protected static final int VALUE_ONE_REP_ID = 2;
    protected static final int VALUE_MANY_REP_IDS = 6;
    protected MessageWriter _out;
    protected int _type;
    protected IiopReader _reader;
    protected String _host;
    protected int _port;
    private IdentityIntMap _refMap = new IdentityIntMap();
    private ValueHandler valueHandler = Util.createValueHandler();
    private RunTime runTime = this.valueHandler.getRunTimeCodeBase();

    public void init(MessageWriter out) {
        this._out = out;
        this._refMap.clear();
    }

    public void init(MessageWriter out, IiopReader reader) {
        this.init(out);
        this._reader = reader;
    }

    public void setHost(String host) {
        this._host = host;
    }

    public String getHost() {
        return this._host;
    }

    public void setPort(int port) {
        this._port = port;
    }

    public int getPort() {
        return this._port;
    }

    public void startRequest(IOR ior, String operation) throws IOException {
        byte[] bytes = ior.getOid();
        this.startRequest(bytes, 0, bytes.length, operation);
    }

    public void startRequest(byte[] oid, int off, int len, String operation) throws IOException {
        this.startRequest(oid, off, len, operation, (int)Alarm.getCurrentTime());
    }

    public abstract void startRequest(byte[] var1, int var2, int var3, String var4, int var5) throws IOException;

    public void writeRequestServiceControlList() throws IOException {
        this.write_long(1);
        this.writeCodeSetService();
    }

    public void writeCodeSetService() throws IOException {
        this.write_long(1);
        this.write_long(12);
        this.write_long(0);
        this.write_long(65537);
        this.write_long(65792);
    }

    public abstract void startReplyOk(int var1) throws IOException;

    public abstract void startReplySystemException(int var1, String var2, int var3, int var4) throws IOException;

    public void startReplyUserException(int requestId, String exceptionId) throws IOException {
        this.startReplyUserException(requestId);
        this.writeString(exceptionId);
    }

    public abstract void startReplyUserException(int var1) throws IOException;

    public void writeIOR(IOR ior) {
        byte[] bytes = ior.getByteArray();
        this._out.align(4);
        this._out.write(bytes, 0, bytes.length);
    }

    public void writeNullIOR() {
        this.write_long(1);
        this.write_long(0);
        this.write_long(0);
    }

    public void writeNull() {
        this.write_long(0);
    }

    public ORB orb() {
        ORB orb = ORB.init();
        return orb;
    }

    public InputStream create_input_stream() {
        System.out.println("INPUT-STREAM:");
        throw new UnsupportedOperationException("no input stream");
    }

    public void write_boolean_array(boolean[] value, int offset, int length) {
        this.write_long(length);
        for (int i = 0; i < length; ++i) {
            this._out.write(value[i + offset] ? 1 : 0);
        }
    }

    public void write_char_array(char[] value, int offset, int length) {
        this.write_long(length);
        for (int i = 0; i < length; ++i) {
            this._out.write(value[i + offset]);
        }
    }

    public void write_wchar_array(char[] value, int offset, int length) {
        this.write_long(length);
        for (int i = 0; i < length; ++i) {
            this._out.writeShort(value[i + offset]);
        }
    }

    public void write_octet_array(byte[] value, int offset, int length) {
        this.write_long(length);
        for (int i = 0; i < length; ++i) {
            this._out.write(value[i + offset]);
        }
    }

    public void write_short_array(short[] value, int offset, int length) {
        this.write_long(length);
        for (int i = 0; i < length; ++i) {
            this._out.writeShort(value[i + offset]);
        }
    }

    public void write_ushort_array(short[] value, int offset, int length) {
        this.write_long(length);
        for (int i = 0; i < length; ++i) {
            this._out.writeShort(value[i + offset]);
        }
    }

    public void write_long_array(int[] value, int offset, int length) {
        this.write_long(length);
        for (int i = 0; i < length; ++i) {
            this._out.writeInt(value[i + offset]);
        }
    }

    public void write_ulong_array(int[] value, int offset, int length) {
        this.write_long(length);
        for (int i = 0; i < length; ++i) {
            this._out.writeInt(value[i + offset]);
        }
    }

    public void write_longlong_array(long[] value, int offset, int length) {
        this.write_long(length);
        for (int i = 0; i < length; ++i) {
            this._out.writeLong(value[i + offset]);
        }
    }

    public void write_ulonglong_array(long[] value, int offset, int length) {
        this.write_long(length);
        for (int i = 0; i < length; ++i) {
            this._out.writeLong(value[i + offset]);
        }
    }

    public void write_float_array(float[] value, int offset, int length) {
        this.write_long(length);
        for (int i = 0; i < length; ++i) {
            float v = value[i];
            int bits = Float.floatToIntBits(v);
            this._out.writeInt(bits);
        }
    }

    public void write_double_array(double[] value, int offset, int length) {
        this.write_long(length);
        for (int i = 0; i < length; ++i) {
            double v = value[i];
            long bits = Double.doubleToLongBits(v);
            this._out.writeLong(bits);
        }
    }

    public void write_string(String a) {
        if (a == null) {
            this.write_long(0);
            return;
        }
        int length = a.length();
        this.write_long(length + 1);
        for (int i = 0; i < length; ++i) {
            this._out.write(a.charAt(i));
        }
        this._out.write(0);
    }

    public void write_wstring(String a) {
        if (a == null) {
            this.write_long(0);
            return;
        }
        int length = a.length();
        this.write_long(length + 1);
        for (int i = 0; i < length; ++i) {
            this._out.writeShort(a.charAt(i));
        }
        this._out.writeShort(0);
    }

    public void write_Object(Object obj) {
        if (obj == null) {
            this.write_long(1);
            this.write(0);
            this.write_long(0);
        } else {
            this.writeIOR(((DummyObjectImpl)obj).getIOR());
        }
    }

    public void write_TypeCode(TypeCode obj) {
        System.out.println("TYPE-CODE:");
        throw new UnsupportedOperationException();
    }

    public void write_abstract_interface(java.lang.Object obj) {
        this.write_boolean(false);
        this.write_value((Serializable)obj);
    }

    public void write_any(Any any) {
        System.out.println("TYPE-ANY:");
        throw new UnsupportedOperationException();
    }

    public void write_Principal(Principal principal) {
        System.out.println("PRINCIPAL:");
        throw new UnsupportedOperationException();
    }

    public void write_value(Serializable obj, Class javaType) {
        this.write_value(obj);
    }

    public void write_value(Serializable obj) {
        if (obj == null) {
            this.write_long(0);
            return;
        }
        if (obj instanceof String) {
            this.write_long(2147483394);
            this.write_string("IDL:omg.org/CORBA/WStringValue:1.0");
            this.write_wstring((String)((java.lang.Object)obj));
        } else {
            int oldValue = this._refMap.get(obj);
            if (oldValue == Integer.MIN_VALUE) {
                this._out.align(4);
                this._refMap.put(obj, this._out.getOffset());
                System.out.println(new CharBuffer().append("WRITE-OFFSET: ").append(this._out.getOffset()).toString());
                this.write_long(2147483394);
                this.write_string(this.valueHandler.getRMIRepositoryID(obj.getClass()));
                this.valueHandler.writeValue((org.omg.CORBA.portable.OutputStream)this, obj);
            } else {
                this._out.align(4);
                this.write_long(-1);
                int delta = oldValue - this._out.getOffset();
                System.out.println(new CharBuffer().append("DELTA: ").append(delta).append(" ").append(oldValue).append(" ").append(this._out.getOffset()).toString());
                this.write_long(delta);
            }
        }
    }

    public void write(int b) {
        this.write_long(b);
    }

    public void write_boolean(boolean v) {
        this._out.write(v ? 1 : 0);
    }

    public void write_octet(byte v) {
        this._out.write(v);
    }

    public void write_short(short v) {
        this._out.align(2);
        this._out.writeShort(v);
    }

    public void write_ushort(short v) {
        this._out.align(2);
        this._out.writeShort(v);
    }

    public void write_char(char v) {
        this._out.write(v);
    }

    public void write_wchar(char v) {
        this._out.align(2);
        this._out.writeShort(v);
    }

    public void write_long(int v) {
        this._out.align(4);
        this._out.writeInt(v);
    }

    public void write_ulong(int v) {
        this._out.align(4);
        this._out.writeInt(v);
    }

    public void write_longlong(long v) {
        this._out.align(8);
        this._out.writeLong(v);
    }

    public void write_ulonglong(long v) {
        this._out.align(8);
        this._out.writeLong(v);
    }

    public void write_float(float v) {
        int bits = Float.floatToIntBits(v);
        this._out.align(4);
        this._out.writeInt(bits);
    }

    public void write_double(double v) {
        long bits = Double.doubleToLongBits(v);
        this._out.align(8);
        this._out.writeLong(bits);
    }

    public void writeString(String v) {
        if (v == null) {
            this.write_long(0);
            return;
        }
        int len = v.length();
        this.write_long(len + 1);
        for (int i = 0; i < len; ++i) {
            this._out.write(v.charAt(i));
        }
        this._out.write(0);
    }

    public void writeBytes(byte[] b, int off, int len) {
        this.write_long(len);
        this._out.write(b, off, len);
    }

    public void write(byte[] b, int off, int len) {
        this._out.write(b, off, len);
    }

    public IiopReader _call() throws IOException {
        this._out.close();
        this._reader.readRequest();
        return this._reader;
    }
}

