/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.iiop;

import com.caucho.config.ConfigException;
import com.caucho.ejb.AbstractStubLoader;
import com.caucho.iiop.IiopStubCompiler;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.log.Log;
import com.caucho.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import com.caucho.vfs.Path;
import java.net.URL;
import java.security.CodeSource;
import java.security.cert.Certificate;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IiopStubLoader
extends AbstractStubLoader {
    private static final Logger log = Log.open(IiopStubLoader._resin_compat_class_0());
    private HashSet<String> _stubClassNames = new HashSet();
    private CodeSource _codeSource;
    private static Class _resin_compat_class_0;

    public IiopStubLoader() {
    }

    public IiopStubLoader(Path path) {
        this.setPath(path);
    }

    public void setLoader(DynamicClassLoader loader) {
        super.setLoader(loader);
        loader.addURL(this.getPath());
    }

    public void init() throws ConfigException {
        try {
            this._codeSource = new CodeSource(new URL(this.getPath().getURL()), (Certificate[])null);
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public void addStubClass(String className) {
        System.out.println(new CharBuffer().append("PATH: ").append(this.getPath()).toString());
        int p = className.lastIndexOf(46);
        if (p > 0) {
            String tail = className.substring(p + 1);
            tail = new CharBuffer().append("_").append(tail).append("_Stub").toString();
            className = new CharBuffer().append(className.substring(0, p)).append('.').append(tail).toString();
        } else {
            className = new CharBuffer().append("_").append(className).append("_Stub").toString();
        }
        className = new CharBuffer().append("org.omg.stub.").append(className).toString();
        className = new CharBuffer().append(className.replace('.', '/')).append(".class").toString();
        System.out.println(new CharBuffer().append("CL: ").append(className).toString());
        this._stubClassNames.add(className);
    }

    public Path getPath(String name) {
        if (!this._stubClassNames.contains(name)) {
            return null;
        }
        Path stubClassPath = this.getPath().lookup(name);
        System.out.println(new CharBuffer().append("PATH: ").append(stubClassPath.getNativePath()).toString());
        if (stubClassPath.canRead()) {
            return stubClassPath;
        }
        String fullClassName = name.substring(0, name.length() - ".class".length());
        fullClassName = fullClassName.replace('/', '.');
        String className = fullClassName.substring("org.omg.stub.".length());
        int p = (className = className.replace('/', '.')).lastIndexOf(46);
        if (p > 0) {
            String tail = className.substring(p + 1);
            tail = tail.substring(1, tail.length() - "_Stub".length());
            className = new CharBuffer().append(className.substring(0, p)).append('.').append(tail).toString();
        }
        Thread thread = Thread.currentThread();
        ClassLoader loader = thread.getContextClassLoader();
        try {
            System.out.println(new CharBuffer().append("ZOOM: ").append(className).toString());
            Class<?> cl = Class.forName(className, false, loader);
            System.out.println(new CharBuffer().append("CL: ").append(cl).toString());
            IiopStubCompiler compiler = new IiopStubCompiler(cl);
            compiler.setFullClassName(fullClassName);
            compiler.setClassDir(this.getPath());
            compiler.generate();
            compiler.compileJava();
            System.out.println("OOK-OOK-OOK");
            if (stubClassPath.canRead()) {
                return stubClassPath;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.log(Level.WARNING, e.toString(), e);
        }
        return null;
    }

    protected CodeSource getCodeSource(Path path) {
        return this._codeSource;
    }

    protected String getClassPath(String head) {
        CharBuffer cb = new CharBuffer();
        if (!head.equals("")) {
            cb.append(head);
            cb.append(CauchoSystem.getPathSeparatorChar());
        }
        if (this.getPath().isDirectory()) {
            cb.append(this.getPath().getNativePath());
        }
        return cb.toString();
    }

    public String toString() {
        return new CharBuffer().append("IiopStubLoader[").append(this.getPath()).append("]").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.iiop.IiopStubLoader");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

