/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.iiop;

import com.caucho.iiop.AnyImpl;
import com.caucho.iiop.DummyObjectImpl;
import com.caucho.iiop.IOR;
import com.caucho.iiop.TypeCodeImpl;
import com.caucho.log.Log;
import com.caucho.util.ByteBuffer;
import com.caucho.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import com.caucho.util.IntArray;
import com.caucho.util.L10N;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.TempBuffer;
import java.io.EOFException;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.rmi.CORBA.Util;
import javax.rmi.CORBA.ValueHandler;
import org.omg.CORBA.Any;
import org.omg.CORBA.Object;
import org.omg.CORBA.Principal;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.portable.IndirectionException;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.SendingContext.RunTime;

public class IiopReader
extends InputStream {
    protected static final L10N L = new L10N(IiopReader._resin_compat_class_2());
    protected static final Logger log = Log.open(IiopReader._resin_compat_class_2());
    public static final int MSG_REQUEST = 0;
    public static final int MSG_REPLY = 1;
    public static final int MSG_CANCEL_REQUEST = 2;
    public static final int MSG_LOCATE_REQUEST = 3;
    public static final int MSG_LOCATE_REPLY = 4;
    public static final int MSG_CLOSE_CONNECTION = 5;
    public static final int MSG_ERROR = 6;
    public static final int MSG_FRAGMENT = 7;
    public static final int SERVICE_TRANSACTION = 0;
    public static final int SERVICE_CODE_SET = 1;
    public static final int SERVICE_CHAIN_BYPASS_CHECK = 2;
    public static final int SERVICE_CHAIN_BYPASS_INFO = 3;
    public static final int SERVICE_LOGICAL_THREAD_ID = 4;
    public static final int SERVICE_BI_DIR_IIOP = 5;
    public static final int SERVICE_SENDING_CONTEXT_RUN_TIME = 6;
    public static final int SERVICE_INVOCATION_POLICIES = 7;
    public static final int SERVICE_FORWARDED_IDENTITY = 8;
    public static final int SERVICE_UNKNOWN_EXCEPTION_INFO = 9;
    public static final int STATUS_NO_EXCEPTION = 0;
    public static final int STATUS_USER_EXCEPTION = 1;
    public static final int STATUS_SYSTEM_EXCEPTION = 2;
    public static final int STATUS_LOCATION_FORWARD = 3;
    private ReadStream _rs;
    private byte[] _header = new byte[8];
    private byte[] buf = new byte[16];
    private IntArray _refOffsets = new IntArray();
    private ArrayList<String> _refIds = new ArrayList();
    private ArrayList<Class> _refClasses = new ArrayList();
    private ArrayList<Serializable> _refValues = new ArrayList();
    private HashMap<Integer, String> _savedStrings = new HashMap();
    private int _major;
    private int _minor;
    private boolean _isBigEndian;
    private boolean _hasMoreFragments;
    private int _flags;
    private TempBuffer _tempBuffer;
    private byte[] _buffer;
    private int _offset;
    private int _length;
    private int _type;
    private int _fragmentOffset;
    private int _chunkEnd = -1;
    private int _chunkDepth = 0;
    private int requestId;
    private boolean responseExpected;
    private ByteBuffer objectKey = new ByteBuffer();
    private CharBuffer _operation = new CharBuffer();
    private ByteBuffer principal = new ByteBuffer();
    private CharBuffer _cb = new CharBuffer();
    private ValueHandler _valueHandler = Util.createValueHandler();
    private RunTime runTime = this._valueHandler.getRunTimeCodeBase();
    private static Class _resin_compat_class_0;
    private static Class _resin_compat_class_1;
    private static Class _resin_compat_class_2;

    public IiopReader() {
    }

    public IiopReader(ReadStream rs) {
        this.init(rs);
    }

    public void init(ReadStream rs) {
        this._rs = rs;
        this._major = 0;
        this._minor = 0;
        this._type = 0;
        this.requestId = 0;
        this.objectKey.clear();
        this._operation.clear();
        this._offset = 0;
        this._length = 0;
        this._fragmentOffset = 0;
        this._refOffsets.clear();
        this._refIds.clear();
        this._refClasses.clear();
        this._refValues.clear();
    }

    public int getMajorVersion() {
        return this._major;
    }

    public int getMinorVersion() {
        return this._minor;
    }

    public int getRequestType() {
        return this._type;
    }

    public int getRequestId() {
        return this.requestId;
    }

    public boolean isBigEndian() {
        return this._isBigEndian;
    }

    public int getOffset() {
        return this._offset;
    }

    public boolean isResponseExpected() {
        return this.responseExpected;
    }

    public ByteBuffer getObjectKey() {
        return this.objectKey;
    }

    public CharBuffer getOperation() {
        return this._operation;
    }

    public void readRequest() throws IOException {
        block19: {
            block21: {
                block20: {
                    block18: {
                        if (this._tempBuffer == null) {
                            this._tempBuffer = TempBuffer.allocate();
                            this._buffer = this._tempBuffer.getBuffer();
                        }
                        int len = this._rs.readAll(this._header, 0, this._header.length);
                        if (this._header[0] != 71 || this._header[1] != 73 || this._header[2] != 79 || this._header[3] != 80) {
                            throw new IOException(L.l("unknown request {0}, {1}, {2}, {3}", new CharBuffer().append("").append(this.toCh(this._header[0])).toString(), new CharBuffer().append("").append(this.toCh(this._header[1])).toString(), new CharBuffer().append("").append(this.toCh(this._header[2])).toString(), new CharBuffer().append("").append(this.toCh(this._header[3])).toString()));
                        }
                        this._major = this._header[4];
                        this._minor = this._header[5];
                        if (this._major != 1) {
                            throw new IOException("unknown major");
                        }
                        this._flags = this._header[6];
                        this._isBigEndian = (this._flags & 1) == 0;
                        this._hasMoreFragments = (this._flags & 2) == 2;
                        this._type = this._header[7];
                        this._rs.readAll(this._buffer, 0, 4);
                        this._length = this.readInt(this._buffer, 0) + 4;
                        this._offset = 4;
                        this._rs.readAll(this._buffer, 4, this._length - 4);
                        if (this._minor != 0) break block18;
                        switch (this._type) {
                            case 0: {
                                this.readRequest10();
                                break block19;
                            }
                            case 1: {
                                this.readReply10();
                                break block19;
                            }
                            case 6: {
                                throw new RuntimeException("MSG_ERROR: unknown protocol error");
                            }
                            default: {
                                throw new RuntimeException();
                            }
                        }
                    }
                    if (this._minor != 1) break block20;
                    switch (this._type) {
                        case 0: {
                            this.readRequest10();
                            break block19;
                        }
                        case 1: {
                            this.readReply10();
                            break block19;
                        }
                        case 6: {
                            throw new RuntimeException("MSG_ERROR: unknown protocol error");
                        }
                        default: {
                            throw new RuntimeException();
                        }
                    }
                }
                if (this._minor != 2) break block21;
                switch (this._type) {
                    case 0: {
                        this.readRequest12();
                        break block19;
                    }
                    case 1: {
                        this.readReply10();
                        break block19;
                    }
                    case 6: {
                        throw new RuntimeException("MSG_ERROR: unknown protocol error");
                    }
                    default: {
                        throw new RuntimeException(new CharBuffer().append("unknown type: ").append(this._type).toString());
                    }
                }
            }
            throw new IOException("unknown minor");
        }
    }

    private void readRequest10() throws IOException {
        this.readServiceContextList();
        this.requestId = this.readInt();
        this.responseExpected = this.read_octet() != 0;
        this.readOctetSequence(this.objectKey);
        this.readString(this._operation);
        this.readOctetSequence(this.principal);
    }

    private void readReply10() throws IOException {
        this.readServiceContextList();
        int requestId = this.readInt();
        int status = this.readInt();
        switch (status) {
            case 0: {
                return;
            }
            case 2: {
                String exceptionId = this.readString();
                int minorStatus = this.readInt();
                int completionStatus = this.readInt();
                throw new IOException(new CharBuffer().append("exception: ").append(exceptionId).toString());
            }
            case 1: {
                java.lang.Object value = this.read_fault();
                throw new IOException(new CharBuffer().append("user exception: ").append(value).toString());
            }
        }
        throw new IOException(new CharBuffer().append("unknown status: ").append(status).toString());
    }

    private void readRequest12() throws IOException {
        this.requestId = this.readInt();
        byte flags = this.read_octet();
        this.responseExpected = flags != 0;
        int disposition = this.read_long();
        this.readOctetSequence(this.objectKey);
        this.readString(this._operation);
        this.readServiceContextList();
        int frag = this._offset % 8;
        if (frag > 0 && frag < 8) {
            int delta = 8 - frag;
            if (this._length < this._offset + delta) {
                delta = this._length - this._offset;
            }
            if (delta > 0) {
                this._offset += delta;
            }
        }
    }

    private void readServiceContextList() throws IOException {
        int length = this.readInt();
        for (int i = 0; i < length; ++i) {
            int serviceId = this.readInt();
            int dataLength = this.readInt();
            if (serviceId == 1) {
                byte endian = this.read_octet();
                int charSet = this.readInt();
                int wcharSet = this.readInt();
                continue;
            }
            this.skip(dataLength);
        }
    }

    private void debugTail() throws IOException {
        int len = this._length;
        for (int i = 0; i < len; i += 8) {
            int j;
            int sublen = this._rs.read(this.buf, 0, 16);
            for (j = 0; j < 16; ++j) {
                if (j < sublen) {
                    this.printHex(this.buf[j]);
                } else {
                    System.out.print("  ");
                }
                if (j == 7) {
                    System.out.print(" - ");
                    continue;
                }
                System.out.print(" ");
            }
            for (j = 0; j < 16; ++j) {
                int ch = this.buf[j] & 0xFF;
                if (j >= sublen) {
                    System.out.print("?");
                    continue;
                }
                if (ch >= 32 && ch < 128) {
                    System.out.print((char)ch);
                    continue;
                }
                System.out.print("?");
            }
            System.out.println();
        }
        System.out.println();
    }

    public IOR readIOR() throws IOException {
        IOR ior = new IOR();
        return ior.read(this);
    }

    public java.lang.Object readObject(Class cl) throws IOException {
        IOR ior = this.readIOR();
        return null;
    }

    public String readWideString() throws IOException {
        CharBuffer cb = CharBuffer.allocate();
        for (int len = this.readInt(); len > 0; --len) {
            cb.append((char)this.read_short());
        }
        return cb.close();
    }

    public Serializable read_value() {
        return this.read_value(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Serializable read_value(Class type) {
        try {
            int newChunk2;
            String string;
            block28: {
                int delta3;
                int oldChunkEnd = this._chunkEnd;
                this._chunkEnd = -1;
                this.align4();
                int startOffset = this._offset - this._fragmentOffset;
                int code = this.read_long();
                String repId = "";
                boolean isChunked = false;
                java.lang.Object value = null;
                if (code == 0) {
                    return null;
                }
                if (code == -1) {
                    this._chunkEnd = oldChunkEnd;
                    int start = this._offset - this._fragmentOffset;
                    int delta2 = this.read_long();
                    int target = start + delta2;
                    int i = 0;
                    while (true) {
                        if (i >= this._refOffsets.size()) {
                            throw new IndirectionException(target);
                        }
                        int refOffset = this._refOffsets.get(i);
                        if (refOffset == target) {
                            return this._refValues.get(i);
                        }
                        ++i;
                    }
                }
                if ((code & 0x7FFFFF00) != 0x7FFFFF00) {
                    repId = this.readString(code);
                } else {
                    isChunked = (code & 8) == 8;
                    boolean hasCodeBase = (code & 1) == 1;
                    int repository = code & 6;
                    if (hasCodeBase) {
                        this.readCodeBase();
                    }
                    if (repository != 2) {
                        throw new RuntimeException(new CharBuffer().append("Can't cope with repository=").append(repository).toString());
                    }
                    repId = this.read_string();
                }
                try {
                    if (isChunked) {
                        int chunkLength = this.readInt();
                        this._chunkEnd = chunkLength + this._offset;
                        ++this._chunkDepth;
                    }
                    if (repId.equals("IDL:omg.org/CORBA/WStringValue:1.0")) {
                        value = this.read_wstring();
                    } else {
                        if (!repId.startsWith("RMI:") && !repId.startsWith("IDL:")) {
                            log.warning(new CharBuffer().append("unknown rep: ").append(repId).append(" ").append(Integer.toHexString(code)).toString());
                            throw new UnsupportedOperationException("problem parsing");
                        }
                        int p = repId.indexOf(58, 4);
                        if (p < 0) {
                            throw new RuntimeException(new CharBuffer().append("unknown RMI: ").append(repId).toString());
                        }
                        String className = repId.substring(4, p);
                        if (className.equals("javax.rmi.CORBA.ClassDesc")) {
                            value = this.readClass();
                        } else {
                            Class cl = null;
                            try {
                                cl = CauchoSystem.loadClass(className);
                            }
                            catch (ClassNotFoundException e) {
                                e.printStackTrace();
                                throw new RuntimeException(e);
                            }
                            int refIndex = this._refOffsets.size();
                            value = this._valueHandler.readValue((org.omg.CORBA.portable.InputStream)this, startOffset, cl, repId, this.runTime);
                        }
                    }
                    this._refOffsets.add(startOffset);
                    this._refValues.add((Serializable)value);
                    string = value;
                    java.lang.Object var14_21 = null;
                    if (this._chunkDepth <= 0) return string;
                    --this._chunkDepth;
                    delta3 = this._chunkEnd - this.getOffset();
                    this._chunkEnd = -1;
                    if (delta3 <= 0) break block28;
                }
                catch (Throwable throwable) {
                    java.lang.Object var14_22 = null;
                    if (this._chunkDepth > 0) {
                        int newChunk2;
                        --this._chunkDepth;
                        int delta3 = this._chunkEnd - this.getOffset();
                        this._chunkEnd = -1;
                        if (delta3 > 0) {
                            this.skip(delta3);
                        }
                        if ((newChunk2 = this.readInt()) >= 0) {
                            throw new IllegalStateException("expected end of chunk.");
                        }
                        this._chunkDepth = -(newChunk2 + 1);
                        if (this._chunkDepth > 0) {
                            newChunk2 = this.readInt();
                            this._chunkEnd = this._offset + newChunk2;
                        }
                    }
                    throw throwable;
                }
                this.skip(delta3);
            }
            if ((newChunk2 = this.readInt()) >= 0) {
                throw new IllegalStateException("expected end of chunk.");
            }
            this._chunkDepth = -(newChunk2 + 1);
            if (this._chunkDepth > 0) {
                newChunk2 = this.readInt();
                this._chunkEnd = this._offset + newChunk2;
            }
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Class readClass() throws IOException {
        String codebase = (String)((java.lang.Object)this.read_value(IiopReader._resin_compat_class_0()));
        String repId = (String)((java.lang.Object)this.read_value(IiopReader._resin_compat_class_0()));
        if (codebase.startsWith("RMI:")) {
            String temp = repId;
            repId = codebase;
            codebase = temp;
        }
        return this.loadClass(repId);
    }

    private Class loadClass(String repId) throws RuntimeException {
        if (!repId.startsWith("RMI:")) {
            throw new RuntimeException(new CharBuffer().append("unknown RMI: ").append(repId).toString());
        }
        int p = repId.indexOf(58, 4);
        if (p < 0) {
            throw new RuntimeException(new CharBuffer().append("unknown RMI: ").append(repId).toString());
        }
        String className = repId.substring(4, p);
        java.lang.Object cl = null;
        try {
            Thread thread = Thread.currentThread();
            return Class.forName(className, false, thread.getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private String readCodeBase() {
        String codeBase = this.read_string();
        return codeBase;
    }

    public java.lang.Object read_fault() {
        int startOffset = this._offset;
        int originalOffset = this._rs.getOffset();
        String repId = this.read_string();
        if (repId.equals("IDL:omg.org/CORBA/WStringValue:1.0")) {
            return this.read_wstring();
        }
        Class cl = null;
        if (repId.startsWith("RMI:")) {
            int p = repId.indexOf(58, 4);
            if (p < 0) {
                throw new RuntimeException(new CharBuffer().append("unknown RMI: ").append(repId).toString());
            }
            String className = repId.substring(4, p);
            try {
                cl = CauchoSystem.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            return this._valueHandler.readValue((org.omg.CORBA.portable.InputStream)this, this._offset, cl, repId, this.runTime);
        }
        String className = null;
        if (repId.startsWith("IDL:")) {
            String tail = repId.substring(4);
            int p = tail.indexOf(58);
            if (p > 0) {
                tail = tail.substring(0, p);
            }
            if (tail.startsWith("omg.org/")) {
                tail = new CharBuffer().append("org.omg.").append(tail.substring("omg.org/".length())).toString();
            }
            className = tail.replace('/', '.');
        } else {
            className = repId;
        }
        String handler = new CharBuffer().append(className).append("Handler").toString();
        Class handlerClass = null;
        try {
            cl = CauchoSystem.loadClass(className);
            handlerClass = CauchoSystem.loadClass(handler);
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (cl == null) {
            int p = className.lastIndexOf(46);
            className = new CharBuffer().append(className.substring(0, p)).append("Package").append(className.substring(p)).toString();
            handler = new CharBuffer().append(className).append("Helper").toString();
            try {
                cl = CauchoSystem.loadClass(className);
                handlerClass = CauchoSystem.loadClass(handler);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        if (cl != null && handlerClass != null) {
            Method readHelper = null;
            try {
                readHelper = handlerClass.getMethod("read", IiopReader._resin_compat_class_1());
            }
            catch (Exception e) {
                // empty catch block
            }
            if (readHelper != null) {
                try {
                    this._offset = startOffset;
                    this._rs.setOffset(originalOffset);
                    return readHelper.invoke(null, new java.lang.Object[]{this});
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                catch (Exception e) {
                    throw new RuntimeException(String.valueOf(e));
                }
            }
        }
        return new IOException(new CharBuffer().append("unknown fault: ").append(repId).toString());
    }

    public boolean read_boolean() {
        try {
            return this.read() != 0;
        }
        catch (IOException e) {
            throw new RuntimeException(String.valueOf(e));
        }
    }

    public char read_char() {
        try {
            return (char)this.read();
        }
        catch (IOException e) {
            throw new RuntimeException(String.valueOf(e));
        }
    }

    public char read_wchar() {
        return (char)this.read_short();
    }

    public short read_ushort() {
        return this.read_short();
    }

    public int read_long() {
        try {
            int v = this.readInt();
            return v;
        }
        catch (IOException e) {
            throw new RuntimeException(String.valueOf(e));
        }
    }

    public int read_ulong() {
        return this.read_long();
    }

    public long read_longlong() {
        try {
            return this.readLong();
        }
        catch (IOException e) {
            throw new RuntimeException(String.valueOf(e));
        }
    }

    public long read_ulonglong() {
        return this.read_longlong();
    }

    public byte read_octet() {
        try {
            return (byte)this.read();
        }
        catch (IOException e) {
            throw new RuntimeException(String.valueOf(e));
        }
    }

    public float read_float() {
        int v = this.read_long();
        return Float.intBitsToFloat(v);
    }

    public double read_double() {
        long v = this.read_longlong();
        return Double.longBitsToDouble(v);
    }

    public void read_boolean_array(boolean[] v, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            v[i + offset] = this.read_boolean();
        }
    }

    public void read_char_array(char[] v, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            v[i + offset] = this.read_char();
        }
    }

    public String read_string() {
        CharBuffer cb = this._cb;
        cb.clear();
        int len = this.read_long();
        if (len < 0) {
            int delta = this.read_long();
            int offset = this._offset + delta - 4;
            len = this.readInt(this._buffer, offset);
            offset += 4;
            for (int i = 0; i < len - 1; ++i) {
                cb.append((char)this._buffer[offset + i]);
            }
            return cb.toString();
        }
        for (int i = 0; i < len - 1; ++i) {
            cb.append(this.read_char());
        }
        byte v = this.read_octet();
        return cb.toString();
    }

    public String readString(int len) {
        CharBuffer cb = this._cb;
        cb.clear();
        for (int i = 0; i < len - 1; ++i) {
            cb.append(this.read_char());
        }
        this.read_octet();
        return cb.toString();
    }

    public void read_wchar_array(char[] v, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            v[i + offset] = this.read_wchar();
        }
    }

    public String read_wstring() {
        return this.read_wstring(this.read_long());
    }

    public String read_wstring(int len) {
        CharBuffer cb = this._cb;
        cb.clear();
        if (this._minor == 2) {
            while (len > 1) {
                char ch = this.read_wchar();
                cb.append(ch);
                len -= 2;
            }
            if (len > 0) {
                this.read_octet();
            }
        } else {
            for (int i = 0; i < len - 1; ++i) {
                char ch = this.read_wchar();
                cb.append(ch);
            }
            this.read_wchar();
        }
        return cb.toString();
    }

    public void read_octet_array(byte[] v, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            v[i + offset] = this.read_octet();
        }
    }

    public void read_short_array(short[] v, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            v[i + offset] = this.read_short();
        }
    }

    public void read_ushort_array(short[] v, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            v[i + offset] = this.read_ushort();
        }
    }

    public void read_long_array(int[] v, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            v[i + offset] = this.read_long();
        }
    }

    public void read_ulong_array(int[] v, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            v[i + offset] = this.read_ulong();
        }
    }

    public void read_longlong_array(long[] v, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            v[i + offset] = this.read_longlong();
        }
    }

    public void read_ulonglong_array(long[] v, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            v[i + offset] = this.read_ulonglong();
        }
    }

    public void read_float_array(float[] v, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            v[i + offset] = this.read_float();
        }
    }

    public void read_double_array(double[] v, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            v[i + offset] = this.read_double();
        }
    }

    public java.lang.Object read_abstract_interface() {
        boolean discriminator = this.read_boolean();
        if (discriminator) {
            return this.read_Object();
        }
        return this.read_value();
    }

    public Object read_Object() {
        try {
            return new DummyObjectImpl(this.readIOR());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public TypeCode read_TypeCode() {
        try {
            return TypeCodeImpl.read(this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Any read_any() {
        try {
            TypeCode typeCode = this.read_TypeCode();
            AnyImpl any = new AnyImpl();
            any.read_value((org.omg.CORBA.portable.InputStream)this, typeCode);
            return any;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Principal read_Principal() {
        throw new UnsupportedOperationException();
    }

    public int read_sequence_length() {
        int length = this.read_long();
        if (length < 0 || length > 65536) {
            throw new RuntimeException(new CharBuffer().append("sequence too long:").append(length).toString());
        }
        return length;
    }

    public void readOctetSequence(ByteBuffer bb) throws IOException {
        int len = this.readInt();
        if (len > 65536) {
            throw new IOException(new CharBuffer().append("too large chunk ").append(len).toString());
        }
        bb.ensureCapacity(len);
        this.readBytes(bb.getBuffer(), 0, len);
        bb.setLength(len);
    }

    public byte[] readBytes() throws IOException {
        int len = this.readInt();
        if (len > 65536) {
            throw new IOException(new CharBuffer().append("too large chunk ").append(len).toString());
        }
        byte[] buf = new byte[len];
        System.arraycopy(this._buffer, this._offset, buf, 0, len);
        this._offset += len;
        return buf;
    }

    public void readBytes(byte[] buf, int off, int len) throws IOException {
        System.arraycopy(this._buffer, this._offset, buf, off, len);
        this._offset += len;
    }

    public String readString() throws IOException {
        int len = this.readInt();
        if (len > 65536) {
            throw new IOException(new CharBuffer().append("too large chunk ").append(len).toString());
        }
        CharBuffer cb = this._cb;
        cb.clear();
        for (int i = 0; i < len - 1; ++i) {
            byte ch = this.read_octet();
            cb.append((char)ch);
        }
        byte ch = this.read_octet();
        return cb.toString();
    }

    public void readString(CharBuffer cb) throws IOException {
        int len = this.readInt();
        if (len > 65536) {
            throw new IOException(new CharBuffer().append("too large chunk ").append(len).toString());
        }
        cb.clear();
        for (int i = 0; i < len - 1; ++i) {
            int ch = this.read();
            cb.append((char)ch);
        }
        int ch = this.read();
    }

    public short read_short() {
        try {
            byte ch2;
            if ((this._offset & 1) == 1) {
                ++this._offset;
            }
            if (this._length <= this._offset && this._hasMoreFragments || this._offset == this._chunkEnd) {
                this.handleFragment();
            }
            byte ch1 = this._buffer[this._offset++];
            if ((ch2 = this._buffer[this._offset++]) < 0) {
                throw new EOFException();
            }
            return (short)(((ch1 & 0xFF) << 8) + (ch2 & 0xFF));
        }
        catch (IOException e) {
            throw new RuntimeException(String.valueOf(e));
        }
    }

    public int readInt() throws IOException {
        this.align4();
        if (this._length <= this._offset && this._hasMoreFragments || this._offset == this._chunkEnd) {
            this.handleFragment();
        }
        byte ch1 = this._buffer[this._offset++];
        byte ch2 = this._buffer[this._offset++];
        byte ch3 = this._buffer[this._offset++];
        byte ch4 = this._buffer[this._offset++];
        return ((ch1 & 0xFF) << 24) + ((ch2 & 0xFF) << 16) + ((ch3 & 0xFF) << 8) + (ch4 & 0xFF);
    }

    public int readInt(byte[] buffer, int offset) {
        byte ch1 = buffer[offset++];
        byte ch2 = buffer[offset++];
        byte ch3 = buffer[offset++];
        byte ch4 = buffer[offset++];
        return ((ch1 & 0xFF) << 24) + ((ch2 & 0xFF) << 16) + ((ch3 & 0xFF) << 8) + (ch4 & 0xFF);
    }

    public long readLong() throws IOException {
        this.align8();
        this._offset += 8;
        byte ch1 = this._buffer[this._offset++];
        byte ch2 = this._buffer[this._offset++];
        byte ch3 = this._buffer[this._offset++];
        byte ch4 = this._buffer[this._offset++];
        byte ch5 = this._buffer[this._offset++];
        byte ch6 = this._buffer[this._offset++];
        byte ch7 = this._buffer[this._offset++];
        byte ch8 = this._buffer[this._offset++];
        return (((long)ch1 & 0xFFL) << 56) + (((long)ch2 & 0xFFL) << 48) + (((long)ch3 & 0xFFL) << 40) + (((long)ch4 & 0xFFL) << 32) + (((long)ch5 & 0xFFL) << 24) + (((long)ch6 & 0xFFL) << 16) + (((long)ch7 & 0xFFL) << 8) + ((long)ch8 & 0xFFL);
    }

    private void align4() throws IOException {
        int frag = this._offset % 4;
        if (frag > 0 && frag < 4) {
            this._offset += 4 - frag;
        }
        if (this._chunkEnd > 0 && this._chunkEnd <= this._offset) {
            this.handleChunk();
        }
    }

    private void align8() throws IOException {
        int frag = this._offset % 8;
        if (frag > 0 && frag < 8) {
            this._offset += 8 - frag;
        }
        if (this._chunkEnd > 0 && this._chunkEnd <= this._offset) {
            this.handleChunk();
        }
    }

    public int read() throws IOException {
        if (this._offset == this._chunkEnd) {
            this.handleChunk();
        } else if (this._chunkEnd > 0 && this._chunkEnd < this._offset) {
            System.out.println(new CharBuffer().append("PAST: ").append(this._offset).append(" ").append(this._chunkEnd).toString());
        }
        return this.readImpl();
    }

    private void handleChunk() throws IOException {
        while (this._offset % 4 != 0) {
            ++this._offset;
        }
        int chunkLength = this.readImpl();
        this._chunkEnd = this.getOffset() + chunkLength;
    }

    private int readImpl() throws IOException {
        if (this._length <= this._offset && this._hasMoreFragments) {
            this.handleFragment();
        }
        return this._buffer[this._offset++];
    }

    public void completeRead() throws IOException {
        this._offset = this._length;
    }

    private void handleFragment() throws IOException {
        if (this._length < this._offset) {
            throw new IllegalStateException(L.l("Read {0} past length {1}", (java.lang.Object)new CharBuffer().append("").append(this._offset).toString(), new CharBuffer().append("").append(this._length).toString()));
        }
        if (this._length <= this._offset) {
            while (this._offset % 8 != 0) {
                ++this._offset;
                ++this._length;
                if (this._chunkEnd <= 0) continue;
                ++this._chunkEnd;
            }
            int len = this._rs.readAll(this._header, 0, this._header.length);
            if (len != this._header.length) {
                throw new EOFException(new CharBuffer().append("Unexpected length: ").append(len).toString());
            }
            if (this._header[0] != 71 || this._header[1] != 73 || this._header[2] != 79 || this._header[3] != 80) {
                throw new IOException(L.l("unknown request {0},{1},{2},{3}", new CharBuffer().append("").append(this._header[0]).toString(), new CharBuffer().append("").append(this._header[1]).toString(), new CharBuffer().append("").append(this._header[2]).toString(), new CharBuffer().append("").append(this._header[3]).toString()));
            }
            this._major = this._header[4];
            this._minor = this._header[5];
            if (this._major != 1) {
                throw new IOException("unknown major");
            }
            this._flags = this._header[6];
            this._isBigEndian = (this._flags & 1) == 0;
            this._hasMoreFragments = (this._flags & 2) == 2;
            this._type = this._header[7];
            this._fragmentOffset += 8;
            this._rs.readAll(this._buffer, this._length, 4);
            int fragLen = this.readInt(this._buffer, this._length);
            if (this._minor == 2) {
                fragLen -= 4;
                this._rs.readAll(this._buffer, this._length, 4);
                int n = this.readInt(this._buffer, this._length);
            }
            this._rs.readAll(this._buffer, this._length, fragLen);
            this.writeHexGroup(this._buffer, this._length, fragLen);
            this._length += fragLen;
            if (this._type != 7) {
                throw new IOException(L.l("expected Fragment at {0}", new CharBuffer().append("").append(this._type).toString()));
            }
        }
    }

    private void skip(int len) throws IOException {
        if (this._length <= this._offset && this._hasMoreFragments) {
            this.handleFragment();
        }
        this._offset += len;
    }

    private void writeHexGroup(byte[] buffer, int offset, int length) {
        int end = offset + length;
        while (offset < end) {
            int j;
            int chunkLength = 16;
            for (j = 0; j < chunkLength; ++j) {
                System.out.print(" ");
                this.printHex(buffer[offset + j]);
            }
            System.out.print(" ");
            for (j = 0; j < chunkLength; ++j) {
                this.printCh(buffer[offset + j]);
            }
            offset += chunkLength;
            System.out.println();
        }
    }

    private void printHex(int d) {
        int ch1 = d >> 4 & 0xF;
        int ch2 = d & 0xF;
        if (ch1 >= 10) {
            System.out.print((char)(97 + ch1 - 10));
        } else {
            System.out.print((char)(48 + ch1));
        }
        if (ch2 >= 10) {
            System.out.print((char)(97 + ch2 - 10));
        } else {
            System.out.print((char)(48 + ch2));
        }
    }

    private void printCh(int d) {
        if (d >= 32 && d <= 127) {
            System.out.print(new CharBuffer().append("").append((char)d).toString());
        } else {
            System.out.print(".");
        }
    }

    private String toCh(int d) {
        if (d >= 32 && d <= 127) {
            return new CharBuffer().append("").append((char)d).toString();
        }
        return new CharBuffer().append("").append(d).toString();
    }

    private static String toHex(int v) {
        CharBuffer cb = new CharBuffer();
        for (int i = 28; i >= 0; i -= 4) {
            int h = v >> i & 0xF;
            if (h >= 10) {
                cb.append((char)(97 + h - 10));
                continue;
            }
            cb.append(h);
        }
        return cb.toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("java.lang.String");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_1() {
        try {
            Class<?> clazz = _resin_compat_class_1;
            if (clazz == null) {
                clazz = _resin_compat_class_1 = Class.forName("org.omg.CORBA.portable.InputStream");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_2() {
        try {
            Class<?> clazz = _resin_compat_class_2;
            if (clazz == null) {
                clazz = _resin_compat_class_2 = Class.forName("com.caucho.iiop.IiopReader");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

