/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.iiop;

import com.caucho.iiop.IiopProtocol;
import com.caucho.iiop.IiopSkeleton;
import com.caucho.log.Log;
import com.caucho.naming.AbstractModel;
import com.caucho.naming.MemoryModel;
import com.caucho.util.CharBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import org.omg.CORBA.Object;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotFound;
import org.omg.CosNaming.NamingContextPackage.NotFoundReason;

public class CosServer {
    private static final Logger log = Log.open(CosServer._resin_compat_class_0());
    private IiopProtocol _iiopServer;
    private String _host;
    private int _port;
    AbstractModel _model = new MemoryModel();
    private static Class _resin_compat_class_0;

    CosServer(IiopProtocol iiopServer) {
        this._iiopServer = iiopServer;
    }

    void setHost(String host) {
        this._host = host;
    }

    void setPort(int port) {
        this._port = port;
    }

    public Object resolve(NameComponent[] n) throws NotFound, CannotProceed, InvalidName {
        java.lang.Object value = null;
        String host = this._host;
        String uri = "";
        try {
            if (log.isLoggable(Level.FINE)) {
                String name = "";
                for (int i = 0; i < n.length; ++i) {
                    name = new CharBuffer().append(name).append("/").append(n[i].id).toString();
                }
                log.fine(new CharBuffer().append("IIOP NameService lookup: ").append(name).toString());
            }
            for (int i = 0; i < n.length; ++i) {
                String name = n[i].id;
                String type = n[i].kind;
                value = this._model.lookup(name);
                if (value != null) continue;
                uri = new CharBuffer().append(uri).append("/").append(name).toString();
            }
            if (value == null) {
                if (uri.equals("")) {
                    String oid = "/NameService";
                    IiopSkeleton skel = this._iiopServer.getService(this._host, this._port, oid);
                    return skel;
                }
                IiopSkeleton skel = this._iiopServer.getService(this._host, this._port, uri);
                if (skel != null) {
                    return skel;
                }
            }
        }
        catch (NamingException e) {
            log.log(Level.FINE, e.toString(), e);
            throw new NotFound(NotFoundReason.from_int((int)0), n);
        }
        log.fine(new CharBuffer().append("IIOP COS NotFound: ").append(uri).toString());
        throw new NotFound(NotFoundReason.from_int((int)0), n);
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.iiop.CosServer");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

