/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.filters;

import com.caucho.log.Log;
import com.caucho.util.IntMap;
import com.caucho.util.L10N;
import java.io.IOException;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;

public class ThrottleFilter
implements Filter {
    private static final L10N L = new L10N(ThrottleFilter._resin_compat_class_0());
    private static final Logger log = Log.open(ThrottleFilter._resin_compat_class_0());
    private IntMap _throttleCache = new IntMap();
    private int _maxConcurrentRequests = 2;
    private static Class _resin_compat_class_0;

    public void setMaxConcurrentRequests(int max) {
        this._maxConcurrentRequests = max;
    }

    public void init(FilterConfig config) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain nextFilter) throws ServletException, IOException {
        boolean isOverflow;
        int count;
        String ip = request.getRemoteAddr();
        ThrottleFilter throttleFilter = this;
        synchronized (throttleFilter) {
            count = this._throttleCache.get(ip);
            if (count <= 0) {
                count = 0;
            }
            if (count < this._maxConcurrentRequests) {
                isOverflow = false;
                this._throttleCache.put(ip, count + 1);
            } else {
                isOverflow = true;
            }
        }
        if (isOverflow) {
            log.info(L.l("'{0}' has too many concurrent requests -- throttling.", ip));
            if (response instanceof HttpServletResponse) {
                ((HttpServletResponse)response).sendError(503);
            }
            return;
        }
        try {
            nextFilter.doFilter(request, response);
        }
        finally {
            throttleFilter = this;
            synchronized (throttleFilter) {
                count = this._throttleCache.get(ip);
                if (count <= 1) {
                    this._throttleCache.remove(ip);
                } else {
                    this._throttleCache.put(ip, count - 1);
                }
            }
        }
    }

    public void destroy() {
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.filters.ThrottleFilter");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

