/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.eswrap.com.caucho.vfs;

import com.caucho.es.Call;
import com.caucho.util.CharBuffer;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.ReadWritePair;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;

public class ReadWritePairEcmaWrap {
    public static void writeByte(ReadWritePair s, int ch) throws Throwable {
        s.getWriteStream().write(ch);
    }

    public static void write(ReadWritePair s, Call call, int length) throws Throwable {
        WriteStream os = s.getWriteStream();
        for (int i = 0; i < length; ++i) {
            String string = call.getArgString(i, length);
            os.print(string);
        }
    }

    public static void writeln(ReadWritePair s, Call call, int length) throws Throwable {
        WriteStream os = s.getWriteStream();
        for (int i = 0; i < length; ++i) {
            String string = call.getArgString(i, length);
            os.print(string);
        }
        os.println();
    }

    public static void writeStream(ReadWritePair s, Call call, int length) throws Throwable {
        if (length < 1) {
            return;
        }
        WriteStream os = s.getWriteStream();
        Object obj = call.getArgObject(0, length);
        if (obj instanceof InputStream) {
            os.writeStream((InputStream)obj);
        } else if (obj instanceof ReadWritePair) {
            os.writeStream(((ReadWritePair)obj).getReadStream());
        } else {
            throw new IllegalArgumentException(new CharBuffer().append("expected read stream at ").append(obj.getClass().getName()).toString());
        }
    }

    public static WriteStream getOutputStream(ReadWritePair s) {
        return s.getWriteStream();
    }

    public static void printf(ReadWritePair s, Call eval, int length) throws Throwable {
        if (length == 0) {
            return;
        }
        WriteStream os = s.getWriteStream();
        String result = eval.printf(length);
        os.print(result);
    }

    public static int readByte(ReadWritePair s) throws IOException {
        ReadStream is = s.getReadStream();
        return is.read();
    }

    public static String read(ReadWritePair s) throws IOException {
        ReadStream is = s.getReadStream();
        int ch = is.readChar();
        if (ch < 0) {
            return null;
        }
        return String.valueOf((char)ch);
    }

    public static String read(ReadWritePair s, int length) throws IOException {
        int ch;
        ReadStream is = s.getReadStream();
        CharBuffer cb = new CharBuffer();
        while (length > 0 && (ch = is.readChar()) >= 0) {
            cb.append((char)ch);
            --length;
        }
        if (cb.length() == 0) {
            return null;
        }
        return cb.toString();
    }

    public static int getAvailable(ReadWritePair s) throws IOException {
        return s.getReadStream().available();
    }

    public static int available(ReadWritePair s) throws IOException {
        return s.getReadStream().available();
    }

    public static String readAvailable(ReadWritePair s, int length) throws IOException {
        int ch;
        ReadStream is = s.getReadStream();
        CharBuffer cb = new CharBuffer();
        while (is.getAvailable() > 0 && (ch = is.readChar()) >= 0) {
            cb.append((char)ch);
        }
        if (cb.length() == 0) {
            return null;
        }
        return cb.toString();
    }

    public static String readln(ReadWritePair s) throws IOException {
        CharBuffer cb;
        ReadStream is = s.getReadStream();
        if (!is.readln(cb = new CharBuffer())) {
            return null;
        }
        return cb.toString();
    }

    public static ReadStream getInputStream(ReadWritePair s) {
        return s.getReadStream();
    }

    public static void setAttribute(ReadWritePair s, String key, Object value) throws IOException {
        s.getWriteStream().setAttribute(key, value);
    }

    public static void removeAttribute(ReadWritePair s, String key) throws IOException {
        s.getWriteStream().removeAttribute(key);
    }

    public static Object getAttribute(ReadWritePair s, String key) throws IOException {
        return s.getReadStream().getAttribute(key);
    }

    public static Iterator getAttributeNames(ReadWritePair s) throws IOException {
        return s.getReadStream().getAttributeNames();
    }

    public static void flush(ReadWritePair s) throws IOException {
        s.getWriteStream().flush();
    }

    public static void close(ReadWritePair s) throws IOException {
        s.getWriteStream().close();
        s.getReadStream().close();
    }
}

