/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.es.parser;

import com.caucho.es.ESId;
import com.caucho.es.parser.Block;
import com.caucho.es.parser.Expr;
import com.caucho.es.parser.JavaTypeExpr;
import com.caucho.util.CharBuffer;
import java.util.HashMap;

class TypeExpr
extends Expr {
    private static HashMap types;
    private static ESId CAUCHO;
    private static ESId JAVA;
    private static ESId PACKAGES;
    private ESId id;
    protected String _typeName;
    private static Class _resin_compat_class_0;
    private static Class _resin_compat_class_1;

    TypeExpr(Block block, ESId id) {
        super(block);
        this.id = id;
        Type type = (Type)types.get(id);
        if (type != null) {
            this.type = type.jsType;
            this._typeName = type._name;
            this.javaType = type.javaClass;
        } else {
            this.type = 1;
            this._typeName = "com.caucho.es.ESBase";
            this.javaType = TypeExpr._resin_compat_class_0();
        }
    }

    static TypeExpr create(Block block, ESId id) {
        if (id == CAUCHO) {
            return new JavaTypeExpr(block, "com.caucho");
        }
        if (id == JAVA) {
            return new JavaTypeExpr(block, "java");
        }
        if (id == PACKAGES) {
            return new JavaTypeExpr(block, "");
        }
        return new TypeExpr(block, id);
    }

    String getTypeName() {
        return this._typeName;
    }

    public String toString() {
        return new CharBuffer().append("TypeExpr[").append(this.javaType).append(" ").append(this.type).append("]").toString();
    }

    static {
        CAUCHO = ESId.intern("caucho");
        JAVA = ESId.intern("java");
        PACKAGES = ESId.intern("Packages");
        types = new HashMap();
        types.put(ESId.intern("boolean"), new Type(ESId.intern("boolean"), 5, Boolean.TYPE));
        types.put(ESId.intern("byte"), new Type(ESId.intern("byte"), 4, Byte.TYPE));
        types.put(ESId.intern("short"), new Type(ESId.intern("short"), 4, Short.TYPE));
        types.put(ESId.intern("int"), new Type(ESId.intern("int"), 4, Integer.TYPE));
        types.put(ESId.intern("long"), new Type(ESId.intern("long"), 3, Long.TYPE));
        types.put(ESId.intern("float"), new Type(ESId.intern("float"), 3, Float.TYPE));
        types.put(ESId.intern("double"), new Type(ESId.intern("double"), 3, Double.TYPE));
        types.put(ESId.intern("String"), new Type(ESId.intern("String"), 2, TypeExpr._resin_compat_class_1()));
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.es.ESBase");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_1() {
        try {
            Class<?> clazz = _resin_compat_class_1;
            if (clazz == null) {
                clazz = _resin_compat_class_1 = Class.forName("java.lang.String");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    static class Type {
        ESId id;
        int jsType;
        String _name;
        Class javaClass;

        Type(ESId id, int jsType, Class cl) {
            this.id = id;
            this.jsType = jsType;
            this._name = cl.getName();
            this.javaClass = cl;
        }
    }
}

