/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.es.parser;

import com.caucho.es.ESException;
import com.caucho.es.ESString;
import com.caucho.es.parser.Block;
import com.caucho.es.parser.Expr;
import com.caucho.es.parser.Function;
import com.caucho.es.parser.LiteralExpr;
import com.caucho.util.CharBuffer;
import java.io.IOException;

class PlusExpr
extends Expr {
    Expr left;
    Expr right;
    int op;

    private PlusExpr(Block block, Expr left, Expr right) {
        super(block);
        this.left = left;
        this.right = right;
    }

    static Expr create(Block block, Expr left, Expr right) throws ESException {
        if (left instanceof LiteralExpr && right instanceof LiteralExpr && (left.getType() == 2 || right.getType() == 2)) {
            LiteralExpr leftLit = (LiteralExpr)left;
            LiteralExpr rightLit = (LiteralExpr)right;
            String string = new CharBuffer().append(leftLit.getLiteral().toString()).append(rightLit.getLiteral()).toString();
            return new LiteralExpr(block, ESString.create(string));
        }
        if (!(right instanceof PlusExpr) || right.getType() != 2) {
            return new PlusExpr(block, left, right);
        }
        PlusExpr pright = (PlusExpr)right;
        if (pright.left.getType() == 2) {
            return PlusExpr.create(block, PlusExpr.create(block, left, pright.left), pright.right);
        }
        return new PlusExpr(block, left, right);
    }

    int getType() {
        int ltype = this.left.getType();
        int rtype = this.right.getType();
        if (ltype == 4 && rtype == 4) {
            return 4;
        }
        if (ltype == 2 || rtype == 2) {
            return 2;
        }
        if (this.left.isNumeric() && this.right.isNumeric()) {
            return 3;
        }
        return 1;
    }

    void exprStatement(Function fun) throws ESException {
        this.left.exprStatement(fun);
        this.right.exprStatement(fun);
    }

    void printInt32Impl() throws IOException {
        this.cl.print("(");
        this.left.printInt32();
        this.cl.print("+");
        this.right.printInt32();
        this.cl.print(")");
    }

    void printNumImpl() throws IOException {
        this.cl.print("(");
        this.left.printNum();
        this.cl.print("+");
        this.right.printNum();
        this.cl.print(")");
    }

    void printStringImpl() throws IOException {
        this.printCharBufferAppend();
        this.cl.print(".close()");
    }

    void printCharBufferAppend() throws IOException {
        if (this.left instanceof PlusExpr && this.left.getType() == 2) {
            ((PlusExpr)this.left).printCharBufferAppend();
        } else {
            this.cl.print("CharBuffer.allocate()");
            this.cl.print(".append(");
            this.left.printJavaString();
            this.cl.print(")");
        }
        this.cl.print(".append(");
        this.right.printJavaString();
        this.cl.print(")");
    }

    void printImpl() throws IOException {
        this.left.print();
        this.cl.print(".plus(");
        this.right.print();
        this.cl.print(")");
    }
}

