/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.es.parser;

import com.caucho.es.ESBase;
import com.caucho.es.ESException;
import com.caucho.es.ESId;
import com.caucho.es.ESParseException;
import com.caucho.es.Script;
import com.caucho.es.parser.Block;
import com.caucho.es.parser.CallExpr;
import com.caucho.es.parser.Expr;
import com.caucho.es.parser.Function;
import com.caucho.es.parser.IdExpr;
import com.caucho.es.parser.JavaClassExpr;
import com.caucho.es.parser.Lexer;
import com.caucho.es.parser.LiteralExpr;
import com.caucho.es.parser.PackageExpr;
import com.caucho.es.parser.ParseClass;
import com.caucho.java.JavaCompiler;
import com.caucho.java.LineMap;
import com.caucho.loader.SimpleLoader;
import com.caucho.log.Log;
import com.caucho.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import com.caucho.util.IntArray;
import com.caucho.util.L10N;
import com.caucho.vfs.MergePath;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;

public class Parser {
    private static final Logger log = Log.open(Parser._resin_compat_class_0());
    private static final L10N L = new L10N(Parser._resin_compat_class_0());
    private static final Object LOCK = new Object();
    static ESId CLINIT = ESId.intern("__clinit__");
    static ESId PROTOTYPE = ESId.intern("prototype");
    static ESId FINALLY = ESId.intern("finally");
    static ESId ANONYMOUS = ESId.intern("anonymous");
    static ESId OBJECT = ESId.intern("Object");
    static ESId REGEXP = ESId.intern("RegExp");
    static ESId ARRAY = ESId.intern("Array");
    static ESId LENGTH = ESId.intern("length");
    static ESId PACKAGES = ESId.intern("Packages");
    static ESId JAVA = ESId.intern("java");
    static ESId COM = ESId.intern("com");
    static ESId CAUCHO = ESId.intern("caucho");
    static final int PREC_DOT = 1;
    static final int PREC_POST = 1;
    static final int PREC_FUN = 2;
    static final int PREC_UMINUS = 3;
    static final int PREC_TIMES = 4;
    static final int PREC_PLUS = 5;
    static final int PREC_SHIFT = 6;
    static final int PREC_CMP = 7;
    static final int PREC_EQ = 8;
    static final int PREC_BITAND = 9;
    static final int PREC_BITXOR = 10;
    static final int PREC_BITOR = 11;
    static final int PREC_AND = 12;
    static final int PREC_OR = 13;
    static final int PREC_COND = 14;
    static final int PREC_ASSIGN = 15;
    static final int PREC_COMMA = 16;
    static final int PREC_MAX = 17;
    ClassLoader parentLoader;
    ClassLoader loader;
    Path scriptPath;
    boolean isEval;
    String className;
    Lexer lexer;
    IntArray hashes = new IntArray();
    ArrayList importList = new ArrayList();
    ParseClass parseClass;
    Function globalFunction;
    Function staticFunction;
    Function function;
    Block block;
    LineMap lineMap;
    Path workPath = CauchoSystem.getWorkPath();
    boolean isFast;
    static ESId BOGUS = ESId.intern("return ");
    private static Class _resin_compat_class_0;

    public Parser() {
        this.addImport("java.lang.*");
        this.addImport("com.caucho.jslib.*");
    }

    public void setParentLoader(ClassLoader parentLoader) {
        this.parentLoader = parentLoader;
    }

    public void setClassLoader(ClassLoader loader) {
        this.loader = loader;
    }

    ClassLoader getClassLoader() {
        if (this.loader != null) {
            return this.loader;
        }
        this.loader = this.parentLoader != null ? SimpleLoader.create(this.parentLoader, this.workPath, null) : SimpleLoader.create(null, this.workPath, null);
        return this.loader;
    }

    public void setScriptPath(Path scriptPath) {
        this.scriptPath = scriptPath;
    }

    public Path getScriptPath() {
        return this.scriptPath;
    }

    public void addImport(String name) {
        if (!this.importList.contains(name)) {
            this.importList.add(name);
        }
    }

    public void setFast(boolean isFast) {
        this.isFast = isFast;
    }

    public void setLineMap(LineMap lineMap) {
        this.lineMap = lineMap;
    }

    public void setClassName(String name) {
        this.className = name;
    }

    public void setWorkDir(Path path) {
        this.workPath = path;
    }

    public Path getWorkDir() {
        return this.workPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Script parse(String name) throws ESException, IOException {
        try {
            Script script;
            String className = this.className != null ? this.className : new CharBuffer().append("_js.").append(JavaCompiler.mangleName(name)).toString();
            if (this.scriptPath == null) {
                MergePath mergePath = new MergePath();
                mergePath.addMergePath(Vfs.lookup());
                ClassLoader parentLoader = this.parentLoader;
                if (parentLoader == null) {
                    parentLoader = Thread.currentThread().getContextClassLoader();
                }
                mergePath.addClassPath(parentLoader);
                this.scriptPath = mergePath;
            }
            if (!(script = this.loadScript(className)).isModified()) {
                script.setScriptPath(this.getScriptPath());
                script.setClassDir(this.workPath);
                return script;
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        Path path = this.getScriptPath().lookup(name);
        ReadStream is = path.openRead();
        try {
            Script script = this.parse(is, name, 1);
            return script;
        }
        finally {
            is.close();
        }
    }

    public Script parse(ReadStream is) throws ESException, IOException {
        return this.parse(is, null, 1);
    }

    public Script parse(ReadStream is, String name, int line) throws ESException, IOException {
        if (name == null) {
            name = is.getUserPath();
        }
        if (line <= 0) {
            line = 1;
        }
        return this.parse(is, name, line, false);
    }

    public Script parseEval(ReadStream is, String name, int line) throws ESException, IOException {
        if (name == null) {
            name = "eval";
        }
        if (line <= 0) {
            line = 1;
        }
        return this.parse(is, name, line, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Script parse(ReadStream is, String name, int line, boolean isEval) throws ESException, IOException {
        if (name == null) {
            name = "anonymous";
        }
        if (line <= 0) {
            line = 1;
        }
        this.lexer = new Lexer(is, name, line);
        if (this.lineMap != null) {
            this.lexer.setLineMap(this.lineMap);
        }
        if (this.className == null) {
            this.className = new CharBuffer().append("_js.").append(JavaCompiler.mangleName(name)).toString();
        }
        if (this.scriptPath == null) {
            MergePath mergePath = new MergePath();
            if (is.getPath() != null) {
                mergePath.addMergePath(is.getPath().getParent());
            } else {
                mergePath.addMergePath(Vfs.lookup());
            }
            ClassLoader parentLoader = this.parentLoader;
            if (parentLoader == null) {
                parentLoader = Thread.currentThread().getContextClassLoader();
            }
            mergePath.addClassPath(parentLoader);
            this.scriptPath = mergePath;
        }
        this.block = null;
        JavaCompiler compiler = JavaCompiler.create(this.getClassLoader());
        compiler.setClassDir(this.workPath);
        this.parseClass = new ParseClass(name, this.className);
        this.parseClass.setParser(this);
        if (is.getPath() != null && is.getPath().getLastModified() > 0L) {
            this.parseClass.setSourcePath(is.getPath());
        }
        this.globalFunction = this.parseClass.newFunction(null, ESId.intern("global"), false);
        this.globalFunction.setFast(this.isFast);
        this.staticFunction = this.parseClass.newFunction(null, ESId.intern("__es_static"), false);
        this.parseClass.setGlobal(this.globalFunction);
        if (isEval) {
            this.block = Block.create(this, this.globalFunction);
            this.block.finish();
            this.function = this.parseClass.newFunction(this.globalFunction, ESId.intern("eval"), false);
            this.function.setEval();
        } else {
            this.function = this.globalFunction;
        }
        this.block = Block.create(this, this.function);
        this.parseBlock(true);
        this.block.finish();
        if (this.lexer.peek() != -1) {
            throw this.expect(L.l("end of file"));
        }
        this.block = Block.create(this, this.staticFunction);
        this.block.finish();
        Object object = LOCK;
        synchronized (object) {
            Script script;
            Path path = this.workPath.lookup(new CharBuffer().append(this.className.replace('.', '/')).append(".java").toString());
            path.getParent().mkdirs();
            WriteStream os = path.openWrite();
            os.setEncoding("JAVA");
            this.parseClass.writeCode(os);
            os.close();
            try {
                compiler.compile(new CharBuffer().append(this.className.replace('.', '/')).append(".java").toString(), null);
                script = this.loadScript(this.className);
            }
            catch (Exception e) {
                throw new ESParseException(e);
            }
            script.setScriptPath(this.getScriptPath());
            script.setClassDir(this.workPath);
            return script;
        }
    }

    private Script loadScript(String className) throws Exception {
        ClassLoader loader = this.getClassLoader();
        Class cl = CauchoSystem.loadClass(className, false, loader);
        Script script = (Script)cl.newInstance();
        script.setScriptPath(this.getScriptPath());
        script.setClassDir(this.workPath);
        return script;
    }

    private Function parseFunction() throws ESException {
        this.function.setNeedsScope();
        ESId id = null;
        if (this.lexer.peek() == 259) {
            this.lexer.next();
            id = this.lexer.getId();
        }
        if (this.lexer.next() != 40) {
            throw this.expect("`('");
        }
        if (id != null) {
            this.function.addVariable(this.block, id, null);
            this.block.newVar(id).getVar().setType(1);
        }
        Block oldBlock = this.block;
        Function oldFun = this.function;
        this.function = this.parseClass.newFunction(oldFun, id, false);
        oldFun.addFunction(this.function);
        this.block = Block.create(this, this.function);
        boolean isFirst = true;
        while (this.lexer.peek() != 41) {
            if (!isFirst && this.lexer.next() != 44) {
                throw this.expect("`,'");
            }
            isFirst = false;
            if (this.lexer.next() != 259) {
                throw this.expect(L.l("formal argument"));
            }
            ESId argId = this.lexer.getId();
            Expr type = null;
            if (this.lexer.peek() == 58) {
                this.lexer.next();
                type = this.parseType();
            }
            this.function.addFormal(this.block, argId, type);
        }
        this.lexer.next();
        if (this.lexer.peek() == 58) {
            this.lexer.next();
            Expr type = this.parseType();
            this.function.setReturnType(type);
        }
        if (this.lexer.next() != 123) {
            throw this.expect("`{'");
        }
        this.parseBlock(false);
        if (this.lexer.next() != 125) {
            throw this.expect("`}'");
        }
        this.block.finish();
        Function newFun = this.function;
        this.function = oldFun;
        this.block = oldBlock;
        return newFun;
    }

    private void parseBlock(boolean isTop) throws ESException {
        block10: while (true) {
            switch (this.lexer.peek()) {
                case 40: 
                case 91: 
                case 257: 
                case 258: 
                case 259: 
                case 260: 
                case 261: 
                case 262: 
                case 264: 
                case 265: 
                case 281: 
                case 282: 
                case 283: 
                case 284: 
                case 296: 
                case 298: 
                case 305: {
                    this.parseStatement();
                    continue block10;
                }
                case 59: 
                case 285: 
                case 287: 
                case 290: 
                case 291: 
                case 292: 
                case 294: 
                case 295: 
                case 297: 
                case 299: 
                case 300: 
                case 308: 
                case 309: 
                case 312: {
                    this.parseStatement();
                    continue block10;
                }
                case 123: {
                    this.block = this.block.startBlock();
                    this.parseStatement();
                    this.block = this.block.finishBlock();
                    continue block10;
                }
                case 310: {
                    this.block.doTry();
                    this.parseCatch();
                    continue block10;
                }
                case 311: {
                    this.block.doTry();
                    this.parseFinally();
                    continue block10;
                }
                case 306: {
                    this.parseClass();
                    continue block10;
                }
                case 313: {
                    this.parseImport();
                    continue block10;
                }
                case 314: {
                    throw new ESException("nostatus");
                }
            }
            break;
        }
    }

    private void parseStatement() throws ESException {
        int lexeme = this.lexer.peek();
        this.hashes.clear();
        int line = this.lexer.getLine();
        Object expr = null;
        this.block.setLine(line);
        if (this.block.isDead) {
            switch (lexeme) {
                case 59: 
                case 296: 
                case 299: 
                case 310: 
                case 311: {
                    break;
                }
                default: {
                    throw this.error(L.l("can't reach statement"));
                }
            }
        }
        switch (lexeme) {
            case 259: {
                this.parseIdentifierStatement();
                break;
            }
            case 40: 
            case 91: 
            case 257: 
            case 258: 
            case 260: 
            case 261: 
            case 262: 
            case 264: 
            case 265: 
            case 281: 
            case 282: 
            case 283: 
            case 284: 
            case 298: 
            case 305: {
                this.block.addExpr(this.parseExpression(17, true));
                this.parseStatementEnd();
                break;
            }
            case 296: {
                this.lexer.next();
                Function newFun = this.parseFunction();
                break;
            }
            case 299: {
                this.parseVar(false);
                this.parseStatementEnd();
                break;
            }
            case 294: {
                this.lexer.next();
                if (this.lexer.peek() == 259 && !this.lexer.seenLineFeed()) {
                    this.block.doBreak(this.lexer.getId());
                    this.lexer.next();
                } else {
                    this.block.doBreak();
                }
                this.parseStatementEnd();
                break;
            }
            case 295: {
                this.lexer.next();
                if (this.lexer.peek() == 259 && !this.lexer.seenLineFeed()) {
                    this.block.doContinue(this.lexer.getId());
                    this.lexer.next();
                } else {
                    this.block.doContinue();
                }
                this.parseStatementEnd();
                break;
            }
            case 297: {
                this.lexer.next();
                if (this.lexer.peek() == 59 || this.lexer.peek() == 125 || this.lexer.seenLineFeed()) {
                    this.block.doReturn();
                } else {
                    this.block.doReturn(this.parseExpression(17, true));
                }
                this.parseStatementEnd();
                break;
            }
            case 285: {
                this.parseIf();
                break;
            }
            case 287: {
                this.parseSwitch();
                break;
            }
            case 290: {
                this.parseWhile(null);
                break;
            }
            case 291: {
                this.parseDo(null);
                break;
            }
            case 292: {
                this.parseFor(null);
                break;
            }
            case 300: {
                this.parseWith();
                break;
            }
            case 308: {
                this.parseSynchronized();
                break;
            }
            case 309: {
                this.parseTry();
                break;
            }
            case 312: {
                this.lexer.next();
                this.block.doThrow(this.parseExpression(17));
                break;
            }
            case 59: {
                this.lexer.next();
                break;
            }
            case 123: {
                this.lexer.next();
                this.parseBlock(false);
                if (this.lexer.next() == 125) break;
                throw this.expect("`}'");
            }
            default: {
                throw this.expect(L.l("statement"));
            }
        }
    }

    private void parseStatementEnd() throws ESException {
        if (this.lexer.peek() == 59) {
            this.lexer.next();
        } else if (this.lexer.peek() != 125 && this.lexer.peek() != -1 && !this.lexer.seenLineFeed()) {
            throw this.expect("`;'");
        }
    }

    private void parseIdentifierStatement() throws ESException {
        ESId id = this.lexer.getId();
        int line = this.lexer.getLine();
        this.lexer.next();
        if (this.lexer.peek() != 58) {
            Expr var = this.getVar(id);
            Expr expr = this.parseExprRec(this.parseTermTail(var, false, true), 17, false, true);
            this.block.addExpr(expr);
            this.parseStatementEnd();
            return;
        }
        this.lexer.next();
        switch (this.lexer.peek()) {
            case 290: {
                this.parseWhile(id);
                break;
            }
            case 291: {
                this.parseDo(id);
                break;
            }
            case 292: {
                this.parseFor(id);
                break;
            }
            default: {
                this.block = this.block.startBlock(id);
                this.parseStatement();
                this.block = this.block.finishBlock();
            }
        }
    }

    private Expr parseType() throws ESException {
        if (this.lexer.next() != 259) {
            throw this.expect(L.l("identifier"));
        }
        Expr type = this.block.newType(this.lexer.getId());
        while (this.lexer.peek() == 46) {
            this.lexer.next();
            if (this.lexer.next() != 259) {
                throw this.expect(L.l("identifier"));
            }
            type = type.fieldReference(this.lexer.getId());
        }
        return type;
    }

    private void parseIf() throws ESException {
        boolean isFirst = true;
        boolean isDead = true;
        this.block = this.block.create();
        while (this.lexer.peek() == 285) {
            this.lexer.next();
            if (this.lexer.next() != 40) {
                throw this.expect("`('");
            }
            this.block.startIf(this.parseBooleanExpression(17), !isFirst);
            isFirst = false;
            if (this.lexer.next() != 41) {
                throw this.expect("`)'");
            }
            this.parseStatement();
            this.block.endBlock();
            if (!this.block.isDead) {
                isDead = false;
            }
            this.block.isDead = false;
            if (this.lexer.peek() != 286) {
                this.block = this.block.pop();
                return;
            }
            this.lexer.next();
        }
        this.block.startElse();
        this.parseStatement();
        this.block.endBlock();
        if (!this.block.isDead) {
            isDead = false;
        }
        this.block = this.block.pop();
        this.block.isDead = isDead;
    }

    private void parseSwitch() throws ESException {
        int ch;
        this.lexer.next();
        if (this.lexer.next() != 40) {
            throw this.expect("`)'");
        }
        Expr test = this.parseExpression(17);
        if (this.lexer.next() != 41) {
            throw this.expect("`)'");
        }
        if (this.lexer.next() != 123) {
            throw this.expect("`{'");
        }
        ArrayList<Expr> exprs = new ArrayList<Expr>();
        this.block = this.block.startSwitch(test);
        block4: while ((ch = this.lexer.peek()) != -1 && ch != 125) {
            switch (ch) {
                case 288: {
                    this.lexer.next();
                    this.block.doCase(exprs.size());
                    exprs.add(this.parseExpression(17));
                    if (this.lexer.next() == 58) continue block4;
                    throw this.expect("`:'");
                }
                case 289: {
                    this.lexer.next();
                    if (this.lexer.next() != 58) {
                        throw this.expect("`:'");
                    }
                    this.block.doDefault();
                    continue block4;
                }
            }
            this.parseStatement();
        }
        if (this.lexer.next() != 125) {
            throw this.expect("`}'");
        }
        this.block = this.block.fillSwitch(exprs);
    }

    private void parseWhile(ESId id) throws ESException {
        this.lexer.next();
        if (this.lexer.next() != 40) {
            throw this.expect("`('");
        }
        Expr expr = this.parseBooleanExpression(17);
        if (expr instanceof LiteralExpr && !((LiteralExpr)expr).getLiteral().toBoolean()) {
            throw this.error(L.l("while (false) is never executed."));
        }
        this.block = this.block.startWhile(id, expr);
        if (this.lexer.next() != 41) {
            throw this.expect("`)'");
        }
        this.parseStatement();
        this.block = this.block.endLoop();
    }

    private void parseFor(ESId id) throws ESException {
        this.lexer.next();
        if (this.lexer.next() != 40) {
            throw this.expect("`('");
        }
        boolean hasValue = false;
        Expr lhs = null;
        if (this.lexer.peek() == 299) {
            lhs = this.parseVar(true);
        } else if (this.lexer.peek() != 59) {
            lhs = this.parseExpression(17);
        } else if (this.lexer.peek() == 293) {
            throw this.expect(L.l("expression"));
        }
        if (this.lexer.peek() == 293) {
            this.parseForIn(id, lhs);
            return;
        }
        if (lhs != null) {
            lhs.exprStatement(this.block.function);
        }
        if (this.lexer.next() != 59) {
            throw this.expect("`;'");
        }
        Expr test = null;
        if (this.lexer.peek() != 59) {
            test = this.parseExpression(17);
        }
        if (this.lexer.next() != 59) {
            throw this.expect("`;'");
        }
        Expr incr = null;
        if (this.lexer.peek() != 41) {
            incr = this.parseExpression(17);
            incr.killValue();
        }
        if (this.lexer.next() != 41) {
            throw this.expect("`)'");
        }
        if (test instanceof LiteralExpr && !((LiteralExpr)test).getLiteral().toBoolean()) {
            throw this.error(L.l("for (;false;) is never executed."));
        }
        this.block = this.block.startFor(id, test, incr);
        this.parseStatement();
        this.block = this.block.endLoop();
    }

    private void parseForIn(ESId id, Expr lhs) throws ESException {
        this.lexer.next();
        String var = this.block.newIterator(id, this.parseExpression(17));
        if (this.lexer.next() != 41) {
            throw this.expect("`)'");
        }
        this.block = this.block.startWhile(id, this.block.hasNext(var));
        this.block.addExpr(lhs.next(var, lhs));
        this.parseStatement();
        this.block = this.block.endLoop();
    }

    private void parseDo(ESId id) throws ESException {
        this.lexer.next();
        this.block = this.block.startDo(id);
        this.parseStatement();
        if (this.lexer.next() != 290) {
            throw this.expect("`while'");
        }
        if (this.lexer.next() != 40) {
            throw this.expect("`('");
        }
        this.block = this.block.endDo(this.parseBooleanExpression(17));
        if (this.lexer.next() != 41) {
            throw this.expect("`)'");
        }
        this.parseStatementEnd();
    }

    private void parseWith() throws ESException {
        this.lexer.next();
        if (this.lexer.next() != 40) {
            throw this.expect("`('");
        }
        this.block = this.block.startWith(this.parseExpression(17));
        if (this.lexer.next() != 41) {
            throw this.expect("`)'");
        }
        this.parseStatement();
        this.block = this.block.endWith();
    }

    private Expr parseVar(boolean keepValue) throws ESException {
        boolean isFirst = true;
        IdExpr retVar = null;
        do {
            this.lexer.next();
            if (this.lexer.next() != 259) {
                throw this.expect(L.l("identifier"));
            }
            ESId name = this.lexer.getId();
            Expr type = null;
            if (this.lexer.peek() == 58) {
                this.lexer.next();
                type = this.parseType();
            }
            this.block.defVar(name, type);
            if (this.lexer.peek() == 61) {
                this.lexer.next();
                IdExpr var = this.block.newVar(name, type);
                Expr value = this.parseExpression(16, true);
                this.block.evalExpr();
                ((Expr)var).assign(value).exprStatement(this.block.function);
            } else if (keepValue) {
                retVar = this.block.newVar(name, type);
            }
            isFirst = false;
        } while (this.lexer.peek() == 44);
        return retVar;
    }

    private void parseSynchronized() throws ESException {
        this.lexer.next();
        if (this.lexer.next() != 40) {
            throw this.expect("`('");
        }
        this.block = this.block.startSynchronized(this.parseExpression(17));
        if (this.lexer.next() != 41) {
            throw this.expect("`)'");
        }
        this.parseStatement();
        this.block = this.block.endSynchronized();
    }

    private void parseTry() throws ESException {
        this.lexer.next();
        this.block = this.block.startTry();
        this.parseStatement();
        this.block = this.block.endTry();
        if (this.lexer.peek() == 310) {
            this.parseCatch();
        } else if (this.lexer.peek() == 311) {
            this.parseFinally();
        } else {
            throw this.error(L.l("expected `catch' or `finally' at {0}", this.getToken()));
        }
    }

    private void parseCatch() throws ESException {
        this.block.function.disallowJavaLocal();
        boolean oldDead = this.block.isDead;
        boolean hasCatchall = false;
        while (this.lexer.peek() == 310) {
            this.block.isDead = false;
            if (hasCatchall) {
                throw this.error(L.l("catch () must be last catch clause"));
            }
            this.lexer.next();
            if (this.lexer.next() != 40) {
                throw this.expect("`('");
            }
            String exceptionClass = "";
            while (this.lexer.peek() == 259) {
                this.lexer.next();
                exceptionClass = new CharBuffer().append(exceptionClass).append((Object)this.lexer.getText()).toString();
                if (this.lexer.peek() != 46) break;
                this.lexer.next();
                exceptionClass = new CharBuffer().append(exceptionClass).append(".").toString();
                if (this.lexer.peek() == 259) continue;
                throw this.expect(L.l("identifier"));
            }
            ESId name = null;
            if (this.lexer.peek() == 259) {
                name = this.lexer.getId();
                this.lexer.next();
            }
            if (this.lexer.next() != 41) {
                if (exceptionClass.equals("")) {
                    throw this.expect(L.l("identifier"));
                }
                throw this.expect("`)'");
            }
            if (name == null) {
                name = ESId.intern(exceptionClass);
                exceptionClass = "java.lang.Exception";
            }
            IdExpr var = null;
            if (name != null) {
                var = this.block.newVar(name);
            }
            this.block = this.block.startCatch(exceptionClass, var);
            this.parseStatement();
            if (!this.block.isDead) {
                oldDead = false;
            }
            this.block = this.block.endCatch();
        }
        this.block.isDead = oldDead;
        if (this.lexer.peek() == 311) {
            this.parseFinally();
        }
    }

    private void parseFinally() throws ESException {
        boolean oldDead = this.block.isDead;
        this.block.isDead = false;
        this.lexer.next();
        this.block = this.block.startFinally();
        this.parseStatement();
        this.block = this.block.endFinally();
        this.block.isDead = oldDead;
    }

    private void parseClass() throws ESException {
        if (this.function.getParent() != null) {
            throw this.error(L.l("`class' only allowed at top level"));
        }
        this.lexer.next();
        if (this.lexer.next() != 259) {
            throw this.expect("class name");
        }
        ESId id = this.lexer.getId();
        ESId proto = this.parseExtends();
        if (this.lexer.next() != 123) {
            throw this.expect("`{'");
        }
        ParseClass oldClass = this.parseClass;
        Function oldGlobal = this.globalFunction;
        Function oldStatic = this.staticFunction;
        Function oldFunction = this.function;
        Block oldBlock = this.block;
        this.parseClass = oldClass.newClass(id);
        this.parseClass.setProto(proto);
        this.globalFunction = this.parseClass.newFunction(null, ESId.intern("global"), true);
        this.staticFunction = this.parseClass.newFunction(null, ESId.intern("__es_static"), true);
        this.parseClass.setGlobal(this.globalFunction);
        this.function = this.globalFunction;
        this.block = Block.create(this, this.function);
        this.parseBlock(true);
        this.block.finish();
        this.block = Block.create(this, this.staticFunction);
        this.block.finish();
        if (this.parseClass.getFunction(id) == null) {
            this.function = this.parseClass.newFunction(null, id, false);
            this.block = Block.create(this, this.function);
            this.block.finish();
        }
        this.block = oldBlock;
        this.function = oldFunction;
        this.globalFunction = oldGlobal;
        this.staticFunction = oldStatic;
        this.parseClass = oldClass;
        if (this.lexer.next() != 125) {
            throw this.expect("`}'");
        }
    }

    private ESId parseExtends() throws ESException {
        if (this.lexer.peek() != 307) {
            return null;
        }
        this.lexer.next();
        if (this.lexer.next() != 259) {
            throw this.expect(L.l("parent class name"));
        }
        return this.lexer.getId();
    }

    private void parseImport() throws ESException {
        CharBuffer path = new CharBuffer();
        this.lexer.next();
        while (true) {
            if (this.lexer.peek() == 263 && this.lexer.getOp() == 42) {
                this.lexer.next();
                path.append('*');
                this.importList.add(path.close());
                return;
            }
            if (this.lexer.peek() != 259) {
                throw this.expect(L.l("identifier"));
            }
            path.append(this.lexer.getText());
            this.lexer.next();
            if (this.lexer.peek() != 46) break;
            this.lexer.next();
            path.append('.');
        }
        String className = path.close();
        String pathName = new CharBuffer().append(className.replace('.', '/')).append(".js").toString();
        Path importPath = this.getScriptPath().lookup(pathName);
        if (importPath.exists()) {
            this.function.cl.addImport(pathName);
            return;
        }
        try {
            CauchoSystem.loadClass(className, false, this.getClassLoader());
            this.importList.add(className);
        }
        catch (ClassNotFoundException e) {
            throw this.error(L.l("can't open import `{0}'", pathName));
        }
    }

    private Expr parseExpression(int prevPrec, boolean isTop) throws ESException {
        Expr result = this.parseExprRec(this.parseTerm(isTop), prevPrec, false, isTop);
        result.getType();
        return result;
    }

    private Expr parseBooleanExpression(int prevPrec) throws ESException {
        Expr result = this.parseExprRec(this.parseTerm(false), prevPrec, true, false);
        result.getType();
        return result;
    }

    private Expr parseExpression(int prevPrec) throws ESException {
        Expr result = this.parseExprRec(this.parseTerm(false), prevPrec, false, false);
        result.getType();
        return result;
    }

    private Expr parseExpression() throws ESException {
        Expr result = this.parseExprRec(this.parseTerm(false), 17, false, false);
        result.getType();
        return result;
    }

    private Expr parseExprRec(Expr lexpr, int prevPrec, boolean isBool, boolean isTop) throws ESException {
        Expr rexpr = null;
        int op = 0;
        int lex = 0;
        int prec = 0;
        while (true) {
            boolean doLookahead = false;
            boolean doPostfix = false;
            boolean isRightAssoc = false;
            int nextPrec = 0;
            int nextOp = 0;
            int nextLex = 0;
            switch (this.lexer.peek()) {
                case 61: {
                    if (op != 0 && lex != 44) {
                        throw this.error(L.l("illegal left hand side of assignment"));
                    }
                    if (isBool) {
                        throw this.error(L.l("assignment used as boolean needs parentheses"));
                    }
                }
                case 263: {
                    if (this.lexer.getOp() == 277 || this.lexer.getOp() == 278) {
                        this.function.setVars();
                    }
                }
                case 44: 
                case 63: 
                case 265: {
                    nextLex = this.lexer.peek();
                    nextOp = this.lexer.getOp();
                    nextPrec = this.lexer.getPrecedence();
                    isRightAssoc = this.lexer.isRightAssoc();
                    doLookahead = true;
                    break;
                }
                default: {
                    return op != 0 ? lexpr.binaryOp(lex, op, rexpr) : lexpr;
                }
            }
            if (nextPrec >= prevPrec) {
                return op != 0 ? lexpr.binaryOp(lex, op, rexpr) : lexpr;
            }
            if (prec != 0) {
                if (nextPrec < prec) {
                    rexpr = this.parseExprRec(rexpr, prec, isBool, isTop);
                    continue;
                }
                lexpr = op != 0 ? lexpr.binaryOp(lex, op, rexpr) : lexpr;
            }
            prec = nextPrec;
            lex = nextLex;
            op = nextOp;
            if (doLookahead) {
                this.lexer.next();
            }
            if (isRightAssoc) {
                rexpr = this.parseExpression(prec + 1, isTop);
                continue;
            }
            if (op == 63) {
                this.function.setVars();
                Expr mexpr = this.parseExpression(16);
                if (this.lexer.peek() != 58) {
                    throw this.expect("`:'");
                }
                this.lexer.next();
                rexpr = this.parseExpression(16, isTop);
                lexpr = lexpr.conditional(mexpr, rexpr);
                op = 0;
                continue;
            }
            rexpr = this.parseTerm(isTop);
        }
    }

    private Expr parseTerm(boolean isTop) throws ESException {
        switch (this.lexer.peek()) {
            case 264: 
            case 265: {
                this.lexer.next();
                int op = this.lexer.getOp();
                return this.parseTerm(isTop).unaryOp(op);
            }
            case 283: {
                this.lexer.next();
                return this.parseTerm(isTop).doVoid();
            }
            case 284: {
                this.lexer.next();
                return this.parseTerm(isTop).typeof();
            }
            case 282: {
                this.lexer.next();
                return this.parseTerm(isTop).delete();
            }
            case 281: {
                this.lexer.next();
                int op = this.lexer.getOp();
                return this.parseTerm(isTop).prefix(op);
            }
            case 40: 
            case 91: 
            case 123: 
            case 257: 
            case 258: 
            case 259: 
            case 260: 
            case 261: 
            case 262: 
            case 296: 
            case 298: 
            case 305: {
                return this.parseLhs(false, isTop);
            }
        }
        throw this.expect(L.l("expression"));
    }

    private Expr parseLhs(boolean hasNew, boolean isTop) throws ESException {
        Expr expr = null;
        switch (this.lexer.next()) {
            case 298: {
                return this.parseTermTail(this.parseLhs(true, isTop), hasNew, isTop);
            }
            case 257: {
                return this.parseTermTail(this.block.newLiteral(this.lexer.getLiteral()), hasNew, isTop);
            }
            case 258: {
                throw new UnsupportedOperationException();
            }
            case 259: {
                return this.parseTermTail(this.getVar(this.lexer.getId()), hasNew, isTop);
            }
            case 260: {
                return this.parseTermTail(this.block.newThis(), hasNew, isTop);
            }
            case 305: {
                if (this.lexer.peek() != 40) {
                    throw this.expect("`('");
                }
                this.function.setArguments();
                return this.parseTermTail(this.block.newVar(ESId.intern("eval")), hasNew, false);
            }
            case 40: {
                expr = this.parseExpression(17);
                if (this.lexer.next() != 41) {
                    throw this.expect("`)'");
                }
                return this.parseTermTail(expr, hasNew, isTop);
            }
            case 123: {
                expr = this.parseObjectLiteral(-1);
                if (this.lexer.next() != 125) {
                    throw this.expect("`}'");
                }
                return this.parseTermTail(expr, hasNew, isTop);
            }
            case 91: {
                expr = this.parseArrayLiteral(-1);
                if (this.lexer.next() != 93) {
                    throw this.expect("`]'");
                }
                return this.parseTermTail(expr, hasNew, isTop);
            }
            case 296: {
                Function newFun = this.parseFunction();
                this.function.addVariable(this.block, newFun.id, null);
                this.block.newVar(newFun.id).getVar().setType(1);
                expr = this.block.newVar(newFun.id);
                return this.parseTermTail(expr, hasNew, isTop);
            }
            case 261: {
                switch (this.lexer.peek()) {
                    case 123: {
                        this.lexer.next();
                        expr = this.parseObjectLiteral(this.lexer.intValue);
                        if (this.lexer.next() != 125) {
                            throw this.expect("`}'");
                        }
                        return this.parseTermTail(expr, hasNew, isTop);
                    }
                    case 91: {
                        this.lexer.next();
                        expr = this.parseArrayLiteral(this.lexer.intValue);
                        if (this.lexer.next() != 93) {
                            throw this.expect("`]'");
                        }
                        return this.parseTermTail(expr, hasNew, isTop);
                    }
                }
                return expr;
            }
        }
        throw this.expect(L.l("term"));
    }

    private Expr parseTermTail(Expr term, boolean hasNew, boolean isTop) throws ESException {
        block7: while (true) {
            switch (this.lexer.peek()) {
                case 46: {
                    this.lexer.next();
                    if (this.lexer.next() != 259) {
                        throw this.expect(L.l("property name"));
                    }
                    term = term.fieldReference(this.lexer.getId());
                    continue block7;
                }
                case 40: {
                    if (isTop && this.lexer.seenLineFeed()) {
                        return term;
                    }
                    this.lexer.next();
                    int n = 0;
                    CallExpr call = hasNew ? term.startNew() : term.startCall();
                    while (this.lexer.peek() != 41) {
                        if (n != 0 && this.lexer.peek() != 44) {
                            throw this.expect("`,'");
                        }
                        if (n != 0) {
                            this.lexer.next();
                        }
                        call.addCallParam(this.parseExpression(16));
                        ++n;
                    }
                    this.lexer.next();
                    if (hasNew) {
                        return call;
                    }
                    term = call;
                    continue block7;
                }
                case 91: {
                    if (isTop && this.lexer.seenLineFeed()) {
                        return term;
                    }
                    this.lexer.next();
                    term = term.fieldReference(this.parseExpression(17));
                    if (this.lexer.next() == 93) continue block7;
                    throw this.expect("`]'");
                }
                case 281: {
                    if (hasNew) {
                        return term.startNew();
                    }
                    if (this.lexer.seenLineFeed()) {
                        return term;
                    }
                    term = term.postfix(this.lexer.getOp());
                    this.lexer.next();
                    continue block7;
                }
                case 64: {
                    this.lexer.next();
                    term = term.cast(this.parseType());
                    continue block7;
                }
            }
            break;
        }
        if (hasNew) {
            return term.startNew();
        }
        return term;
    }

    private Expr parseObjectLiteral(int hash) throws ESException {
        IdExpr expr = this.block.newVar(ESId.intern("Object"));
        CallExpr call = ((Expr)expr).startCall();
        if (this.lexer.peek() == 44) {
            this.lexer.next();
            return call;
        }
        while (this.lexer.peek() == 257 || this.lexer.peek() == 259) {
            ESId id = this.lexer.next() == 257 ? ESId.intern(this.lexer.literal.toString()) : this.lexer.getId();
            if (this.lexer.next() != 58) {
                throw this.expect("`:'");
            }
            call.addCallParam(this.block.newLiteral(id));
            call.addCallParam(this.parseExpression(16));
            if (this.lexer.peek() != 44) break;
            this.lexer.next();
        }
        return call;
    }

    private Expr parseArrayLiteral(int hash) throws ESException {
        IdExpr expr = this.block.newVar(ESId.intern("Array"));
        CallExpr call = ((Expr)expr).startCall();
        boolean isFirst = true;
        while (this.lexer.peek() != 93) {
            if (this.lexer.peek() == 44) {
                this.lexer.next();
                call.addCallParam(this.block.newLiteral(ESBase.esUndefined));
                isFirst = false;
                continue;
            }
            Expr value = this.parseExpression(16);
            if (isFirst && this.lexer.peek() == 93) {
                return this.block.newArray(value);
            }
            if (this.lexer.peek() != 44) {
                call.addCallParam(value);
                break;
            }
            this.lexer.next();
            if (isFirst && this.lexer.peek() == 93) {
                return this.block.newArray(value);
            }
            isFirst = false;
            call.addCallParam(value);
        }
        return call;
    }

    private Expr getVar(ESId name) throws ESException {
        if (name == PACKAGES) {
            return new PackageExpr(this.block);
        }
        if (name == JAVA) {
            return new PackageExpr(this.block).fieldReference(JAVA);
        }
        if (name == CAUCHO) {
            return new PackageExpr(this.block).fieldReference(COM).fieldReference(CAUCHO);
        }
        if (this.block.hasVar(name)) {
            return this.block.newVar(name);
        }
        for (int i = 0; i < this.importList.size(); ++i) {
            String className = (String)this.importList.get(i);
            if (className.endsWith(".*")) {
                className = new CharBuffer().append(className.substring(0, className.length() - 1)).append(name).toString();
            }
            try {
                Class cl = CauchoSystem.loadClass(className, false, this.getClassLoader());
                return new JavaClassExpr(this.block, cl);
            }
            catch (Throwable e) {
                continue;
            }
        }
        return this.block.newVar(name);
    }

    public String getFilename() {
        return this.lexer.getFilename();
    }

    ESException error(String text) {
        return this.lexer.error(text);
    }

    private String getToken() {
        if (this.lexer.isEof()) {
            return "end of file";
        }
        return new CharBuffer().append("`").append(this.lexer.getToken()).append("'").toString();
    }

    private ESException expect(String expect) {
        try {
            return this.lexer.error(L.l("expected {0} at {1}", (Object)expect, this.getToken()));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.es.parser.Parser");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

