/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.es.parser;

import com.caucho.es.ESException;
import com.caucho.es.ESId;
import com.caucho.es.parser.Block;
import com.caucho.es.parser.CallExpr;
import com.caucho.es.parser.Expr;
import com.caucho.es.parser.JavaClassExpr;
import com.caucho.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import java.io.IOException;
import java.lang.reflect.Modifier;

class PackageExpr
extends Expr {
    private Expr rawExpr;
    private String name;

    private PackageExpr(Block block, Expr rawExpr, String name) {
        super(block);
        this.rawExpr = rawExpr;
        this.name = name;
    }

    PackageExpr(Block block) {
        super(block);
        this.rawExpr = block.newVar(ESId.intern("Packages"));
        this.name = null;
    }

    static Expr create(Block block, Expr rawExpr, String name) {
        ClassLoader loader = block.getClassLoader();
        try {
            Class cl = CauchoSystem.loadClass(name, false, loader);
            if (Modifier.isPublic(cl.getModifiers())) {
                return new JavaClassExpr(block, cl);
            }
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        return new PackageExpr(block, rawExpr, name);
    }

    void setType(int type) {
    }

    int getType() {
        return 1;
    }

    Expr getTypeExpr() {
        return null;
    }

    Expr fieldReference(ESId id) throws ESException {
        String newName = null;
        newName = this.name == null ? id.toString() : new CharBuffer().append(this.name).append(".").append(id.toString()).toString();
        return PackageExpr.create(this.block, this.rawExpr.fieldReference(id), newName);
    }

    Expr fieldReference(Expr expr) {
        return this.rawExpr.fieldReference(expr);
    }

    CallExpr startCall() throws ESException {
        return this.rawExpr.startCall();
    }

    CallExpr startNew() throws ESException {
        return this.rawExpr.startNew();
    }

    void printImpl() throws IOException {
        this.rawExpr.printImpl();
    }
}

