/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.es.parser;

import com.caucho.es.ESException;
import com.caucho.es.ESId;
import com.caucho.es.parser.Block;
import com.caucho.es.parser.Expr;
import com.caucho.es.parser.TypeExpr;
import com.caucho.util.CauchoSystem;
import com.caucho.util.CharBuffer;

class JavaTypeExpr
extends TypeExpr {
    JavaTypeExpr(Block block, String className) {
        super(block, null);
        this.type = 6;
        this._typeName = className;
        try {
            this.javaType = CauchoSystem.loadClass(className, false, block.getClassLoader());
        }
        catch (Exception e) {
            this.type = 1;
        }
    }

    JavaTypeExpr(Block block, Class javaClass) {
        super(block, null);
        this.type = 6;
        this.javaType = javaClass;
        this._typeName = this.getTypeName(javaClass);
    }

    private String getTypeName(Class cl) {
        if (cl.isArray()) {
            return new CharBuffer().append(this.getTypeName(cl.getComponentType())).append("[]").toString();
        }
        return cl.getName();
    }

    Expr fieldReference(ESId id) throws ESException {
        if (this._typeName.equals("")) {
            return new JavaTypeExpr(this.block, id.toString());
        }
        return new JavaTypeExpr(this.block, new CharBuffer().append(this._typeName).append(".").append(id).toString());
    }

    public String toString() {
        return new CharBuffer().append("[JavaTypeExpr ").append(this.javaType).append(" ").append(this.type).append("]").toString();
    }
}

