/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.es.parser;

import com.caucho.es.ESBase;
import com.caucho.es.ESException;
import com.caucho.es.ESNumber;
import com.caucho.es.ESWrapperException;
import com.caucho.es.parser.Block;
import com.caucho.es.parser.Expr;
import com.caucho.es.parser.Function;
import com.caucho.es.parser.LiteralExpr;
import com.caucho.util.CharBuffer;
import java.io.IOException;

class BinaryExpr
extends Expr {
    Expr left;
    Expr right;
    int op;
    String temp;
    boolean isSimple;

    protected BinaryExpr(Block block, Expr left, Expr right, int op) {
        super(block);
        this.left = left;
        this.right = right;
        this.op = op;
        this.isSimple = left.isSimple();
        if (!(op != 277 && op != 278 || this.isSimple)) {
            this.temp = block.function.getTemp();
        }
    }

    static Expr create(Block block, Expr left, Expr right, int op) throws ESException {
        ESBase value;
        if (left != null) {
            left.setUsed();
        }
        if (right != null) {
            right.setUsed();
        }
        if (!(left instanceof LiteralExpr) || !(right instanceof LiteralExpr)) {
            return new BinaryExpr(block, left, right, op);
        }
        ESBase lvalue = ((LiteralExpr)left).getLiteral();
        ESBase rvalue = ((LiteralExpr)right).getLiteral();
        try {
            switch (op) {
                case 42: {
                    value = ESNumber.create(lvalue.toNum() * rvalue.toNum());
                    break;
                }
                case 47: {
                    value = ESNumber.create(lvalue.toNum() / rvalue.toNum());
                    break;
                }
                case 45: {
                    value = ESNumber.create(lvalue.toNum() - rvalue.toNum());
                    break;
                }
                case 37: {
                    value = ESNumber.create(lvalue.toNum() % rvalue.toNum());
                    break;
                }
                case 268: {
                    value = ESNumber.create(lvalue.toInt32() << rvalue.toInt32());
                    break;
                }
                case 266: {
                    value = ESNumber.create(lvalue.toInt32() >> rvalue.toInt32());
                    break;
                }
                case 267: {
                    value = ESNumber.create(lvalue.toInt32() >>> rvalue.toInt32());
                    break;
                }
                case 38: {
                    value = ESNumber.create(lvalue.toInt32() & rvalue.toInt32());
                    break;
                }
                case 124: {
                    value = ESNumber.create(lvalue.toInt32() | rvalue.toInt32());
                    break;
                }
                case 94: {
                    value = ESNumber.create(lvalue.toInt32() ^ rvalue.toInt32());
                    break;
                }
                case 277: {
                    value = lvalue.toBoolean() ? rvalue : lvalue;
                    break;
                }
                case 278: {
                    value = lvalue.toBoolean() ? lvalue : rvalue;
                    break;
                }
                case 44: {
                    value = rvalue;
                    break;
                }
                default: {
                    throw new RuntimeException(new CharBuffer().append("").append((char)op).toString());
                }
            }
        }
        catch (Throwable e) {
            throw new ESWrapperException(e);
        }
        return new LiteralExpr(block, value);
    }

    int getType() {
        switch (this.op) {
            case 37: 
            case 42: 
            case 47: {
                return 3;
            }
            case 45: {
                if (this.left.getType() == 4 && this.right.getType() == 4) {
                    return 4;
                }
                return 3;
            }
            case 38: 
            case 94: 
            case 124: 
            case 266: 
            case 267: 
            case 268: {
                return 4;
            }
            case 277: 
            case 278: {
                if (this.left.getType() == this.right.getType()) {
                    return this.left.getType();
                }
                if (this.left.isNum() && this.right.isNum()) {
                    return 3;
                }
                return 1;
            }
            case 44: {
                return 1;
            }
        }
        throw new RuntimeException(new CharBuffer().append("").append((char)this.op).append(" ").append(this.op).toString());
    }

    void exprStatement(Function fun) throws ESException {
        switch (this.op) {
            default: 
        }
        this.left.exprStatement(fun);
        this.right.exprStatement(fun);
    }

    void printNumImpl() throws IOException {
        this.cl.print("(");
        switch (this.op) {
            case 37: 
            case 42: 
            case 45: 
            case 47: {
                this.left.printNum();
                this.cl.print(new CharBuffer().append(" ").append((char)this.op).append(" ").toString());
                this.right.printNum();
                break;
            }
            case 277: {
                if (this.isSimple) {
                    this.left.printBoolean();
                    this.cl.print(" ? ");
                    this.right.printNum();
                    this.cl.print(":");
                    this.left.printNum();
                    break;
                }
                this.cl.print(new CharBuffer().append("(").append(this.temp).append(" = ").toString());
                this.left.print();
                this.cl.print(").toBoolean() ? ");
                this.right.printNum();
                this.cl.print(new CharBuffer().append(":").append(this.temp).append(".toNum()").toString());
                break;
            }
            case 278: {
                if (this.isSimple) {
                    this.left.printBoolean();
                    this.cl.print(" ? ");
                    this.left.printNum();
                    this.cl.print(":");
                    this.right.printNum();
                    break;
                }
                this.cl.print(new CharBuffer().append("(").append(this.temp).append(" = ").toString());
                this.left.print();
                this.cl.print(new CharBuffer().append(").toBoolean() ? ").append(this.temp).append(".toNum() : ").toString());
                this.right.printNum();
                break;
            }
            default: {
                throw new IOException("foo");
            }
        }
        this.cl.print(")");
    }

    void printInt32Impl() throws IOException {
        this.cl.print("(");
        switch (this.op) {
            case 45: {
                this.left.printInt32();
                this.cl.print(new CharBuffer().append(" ").append((char)this.op).append(" ").toString());
                this.right.printInt32();
                break;
            }
            case 268: {
                this.left.printInt32();
                this.cl.print(" << ");
                this.right.printInt32();
                break;
            }
            case 266: {
                this.left.printInt32();
                this.cl.print(" >> ");
                this.right.printInt32();
                break;
            }
            case 267: {
                this.left.printInt32();
                this.cl.print(" >>> ");
                this.right.printInt32();
                break;
            }
            case 38: 
            case 94: 
            case 124: {
                this.left.printInt32();
                this.cl.print(new CharBuffer().append(" ").append((char)this.op).append(" ").toString());
                this.right.printInt32();
                break;
            }
            case 277: {
                if (this.isSimple) {
                    this.left.printBoolean();
                    this.cl.print(" ? ");
                    this.right.printInt32();
                    this.cl.print(":");
                    this.left.printInt32();
                    break;
                }
                this.cl.print(new CharBuffer().append("(").append(this.temp).append(" = ").toString());
                this.left.print();
                this.cl.print(").toBoolean() ? ");
                this.right.printInt32();
                this.cl.print(new CharBuffer().append(":").append(this.temp).append(".toInt32()").toString());
                break;
            }
            case 278: {
                if (this.isSimple) {
                    this.left.printBoolean();
                    this.cl.print(" ? ");
                    this.left.printInt32();
                    this.cl.print(":");
                    this.right.printInt32();
                    break;
                }
                this.cl.print(new CharBuffer().append("(").append(this.temp).append(" = ").toString());
                this.left.print();
                this.cl.print(new CharBuffer().append(").toBoolean() ? ").append(this.temp).append(".toInt32() : ").toString());
                this.right.printInt32();
                break;
            }
            default: {
                throw new IOException("foo");
            }
        }
        this.cl.print(")");
    }

    void printBoolean() throws IOException {
        switch (this.op) {
            case 277: {
                this.cl.print("(");
                this.left.printBoolean();
                this.cl.print(" && ");
                this.right.printBoolean();
                this.cl.print(")");
                break;
            }
            case 278: {
                this.cl.print("(");
                this.left.printBoolean();
                this.cl.print(" || ");
                this.right.printBoolean();
                this.cl.print(")");
                break;
            }
            default: {
                super.printBoolean();
            }
        }
    }

    void printBooleanImpl() throws IOException {
        this.cl.print("(");
        switch (this.op) {
            case 277: {
                this.left.printBoolean();
                this.cl.print(" && ");
                this.right.printBoolean();
                break;
            }
            case 278: {
                this.left.printBoolean();
                this.cl.print(" || ");
                this.right.printBoolean();
                break;
            }
            default: {
                throw new IOException("foo");
            }
        }
        this.cl.print(")");
    }

    void printImpl() throws IOException {
        switch (this.op) {
            case 277: {
                if (this.isSimple) {
                    this.left.printBoolean();
                    this.cl.print(" ? ");
                    this.right.print();
                    this.cl.print(":");
                    this.left.print();
                    break;
                }
                this.cl.print(new CharBuffer().append("((").append(this.temp).append(" = ").toString());
                this.left.print();
                this.cl.print(").toBoolean() ? ");
                this.right.print();
                this.cl.print(new CharBuffer().append(":").append(this.temp).append(")").toString());
                break;
            }
            case 278: {
                if (this.isSimple) {
                    this.left.printBoolean();
                    this.cl.print(" ? ");
                    this.left.print();
                    this.cl.print(":");
                    this.right.print();
                    break;
                }
                this.cl.print(new CharBuffer().append("((").append(this.temp).append(" = ").toString());
                this.left.print();
                this.cl.print(new CharBuffer().append(").toBoolean() ? ").append(this.temp).append(" : ").toString());
                this.right.print();
                this.cl.print(")");
                break;
            }
            case 44: {
                this.cl.print("_env.comma(");
                this.left.print();
                this.cl.print(", ");
                this.right.print();
                this.cl.print(")");
                break;
            }
            default: {
                throw new IOException("foo");
            }
        }
    }
}

