/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.es;

import com.caucho.es.Call;
import com.caucho.es.ESBase;
import com.caucho.es.ESClosure;
import com.caucho.es.ESException;
import com.caucho.es.ESGlobal;
import com.caucho.es.ESString;
import com.caucho.es.Global;
import com.caucho.es.Script;
import com.caucho.util.CharBuffer;
import com.caucho.util.Exit;

public final class ScriptClosure {
    private Script script;
    private Global resin;
    private ESGlobal global;

    ScriptClosure(Global resin, ESGlobal global, Script script) {
        this.script = script;
        this.resin = resin;
        this.global = global;
    }

    public boolean isModified() {
        return this.script.isModified();
    }

    public synchronized Object call(String name) throws Throwable {
        Call call;
        call.caller = call = this.resin.getCall();
        call.top = 1;
        call.setArg(-1, this.global);
        Object value = this.call(this.getFunction(name), call, 0);
        this.resin.freeCall(call);
        return value;
    }

    public synchronized Object call(String name, Object a) throws Throwable {
        Call call;
        call.caller = call = this.resin.getCall();
        call.top = 1;
        call.setArg(-1, this.global);
        call.setArg(0, this.resin.objectWrap(a));
        Object value = this.call(this.getFunction(name), call, 1);
        this.resin.freeCall(call);
        return value;
    }

    public synchronized Object call(String name, Object a, Object b) throws Throwable {
        Call call;
        call.caller = call = this.resin.getCall();
        call.top = 1;
        call.setArg(-1, this.global);
        call.setArg(0, this.resin.objectWrap(a));
        call.setArg(1, this.resin.objectWrap(b));
        Object value = this.call(this.getFunction(name), call, 2);
        this.resin.freeCall(call);
        return value;
    }

    public synchronized Object call(String name, Object a, Object b, Object c) throws Throwable {
        Call call;
        call.caller = call = this.resin.getCall();
        call.top = 1;
        call.setArg(-1, this.global);
        call.setArg(0, this.resin.objectWrap(a));
        call.setArg(1, this.resin.objectWrap(b));
        call.setArg(2, this.resin.objectWrap(c));
        Object value = this.call(this.getFunction(name), call, 3);
        this.resin.freeCall(call);
        return value;
    }

    public synchronized Object call(String name, Object a, Object b, Object c, Object d) throws Throwable {
        Call call;
        call.caller = call = this.resin.getCall();
        call.top = 1;
        call.setArg(-1, this.global);
        call.setArg(0, this.resin.objectWrap(a));
        call.setArg(1, this.resin.objectWrap(b));
        call.setArg(2, this.resin.objectWrap(c));
        call.setArg(3, this.resin.objectWrap(d));
        Object value = this.call(this.getFunction(name), call, 4);
        this.resin.freeCall(call);
        return value;
    }

    public synchronized Object call(String name, Object[] args) throws Throwable {
        Call call;
        call.caller = call = this.resin.getCall();
        call.setArg(0, this.global);
        call.top = 1;
        for (int i = 0; i < args.length; ++i) {
            call.setArg(i, this.resin.objectWrap(args[i]));
        }
        Object value = this.call(this.getFunction(name), call, args.length);
        this.resin.freeCall(call);
        return value;
    }

    private ESClosure getFunction(String name) throws Throwable {
        ESBase fun = this.global.hasProperty(ESString.create(name));
        if (fun == null) {
            throw new ESException(new CharBuffer().append("no such function `").append(name).append("'").toString());
        }
        if (!(fun instanceof ESClosure)) {
            throw new ESException(new CharBuffer().append(name).append(" should be function: ").append(fun).toString());
        }
        return (ESClosure)fun;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object call(ESClosure closure, Call call, int length) throws Throwable {
        int scopeLength;
        call.scopeLength = scopeLength = closure.scopeLength;
        for (int i = 0; i < scopeLength; ++i) {
            call.scope[i] = closure.scope[i];
        }
        boolean doExit = Exit.addExit();
        Global old = this.resin.begin();
        try {
            ESBase value = closure.call(call, length);
            Object object = value == null ? null : value.toJavaObject();
            return object;
        }
        finally {
            Global.end(old);
            if (doExit) {
                Exit.exit();
            }
        }
    }

    public synchronized Object getProperty(String name) {
        try {
            ESBase object = this.global.getProperty(name);
            return object.toJavaObject();
        }
        catch (Throwable e) {
            return null;
        }
    }

    public synchronized void setProperty(String name, Object value) {
        try {
            this.global.setProperty(name, this.resin.objectWrap(value));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

