/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.es;

import com.caucho.es.Call;
import com.caucho.es.ESBase;
import com.caucho.es.ESClosure;
import com.caucho.es.ESException;
import com.caucho.es.ESGlobal;
import com.caucho.es.ESId;
import com.caucho.es.ESObject;
import com.caucho.es.ESString;
import com.caucho.es.Global;
import com.caucho.es.Native;
import com.caucho.es.NativeWrapper;
import com.caucho.es.Script;
import com.caucho.es.parser.Parser;
import com.caucho.util.CharBuffer;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.Vfs;
import java.io.IOException;
import java.util.ArrayList;

class NativeFunction
extends Native {
    static final int NEW = 1;
    static final int TO_STRING = 2;
    static final int CALL = 3;
    static final int APPLY = 4;
    static ESId LENGTH = ESId.intern("length");

    private NativeFunction(String name, int n, int len) {
        super(name, len);
        this.n = n;
    }

    static NativeWrapper create(Global resin) {
        ESBase[] eSBaseArray = new ESBase[1];
        eSBaseArray[0] = resin.getGlobalProto();
        ESBase[] scope = eSBaseArray;
        ESClosure funProto = new ESClosure(scope, 1);
        funProto.name = ESId.intern("Function");
        NativeFunction natFunction = new NativeFunction("Function", 1, 1);
        NativeWrapper function = new NativeWrapper(resin, natFunction, funProto, 3);
        resin.funProto = funProto;
        NativeFunction.put(funProto, "toString", 2, 0);
        NativeFunction.put(funProto, "call", 3, 1);
        NativeFunction.put(funProto, "apply", 4, 2);
        funProto.prototype = resin.objProto;
        funProto.setClean();
        function.setClean();
        return function;
    }

    private static void put(ESObject proto, String name, int n, int len) {
        ESId id = ESId.intern(name);
        proto.put(id, (ESBase)new NativeFunction(name, n, len), 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ESBase call(Call eval, int length) throws Throwable {
        switch (this.n) {
            case 1: {
                return this.createAnonymous(eval, length);
            }
            case 2: {
                if (eval.getThis() instanceof ESClosure) {
                    ESClosure closure = (ESClosure)eval.getThis();
                    return ESString.create(closure.decompile());
                }
                if (eval.getThis() instanceof NativeWrapper) {
                    NativeWrapper wrapper = (NativeWrapper)eval.getThis();
                    return wrapper.fun.toStr();
                }
                throw new ESException(new CharBuffer().append("to string bound to function: ").append(eval.getThis().getClass()).toString());
            }
            case 3: {
                int oldTop = eval.top;
                ESBase fun = eval.getArg(-1);
                ESBase callThis = null;
                try {
                    callThis = length > 0 ? eval.getArg(0) : esNull;
                    if (callThis == esNull || callThis == esUndefined || callThis == esEmpty) {
                        eval.setArg(0, eval.getGlobal());
                    } else {
                        eval.setArg(0, callThis.toObject());
                    }
                    ++eval.top;
                    ESBase eSBase = fun.call(eval, length > 0 ? length - 1 : 0);
                    return eSBase;
                }
                finally {
                    eval.top = oldTop;
                }
            }
            case 4: {
                return this.apply(eval, length);
            }
        }
        throw new ESException("Unknown object function");
    }

    private ESClosure parseFunction(Call eval, int length) throws Throwable {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("function anonymous(");
        ArrayList<ESId> argList = new ArrayList<ESId>();
        for (int i = 0; i < length - 1; ++i) {
            if (i != 0) {
                sbuf.append(",");
            }
            String str = eval.getArg(i).toString();
            int j = 0;
            int p = 0;
            while ((p = str.indexOf(44, j)) >= 0 || (p = str.indexOf(32, j)) >= 0) {
                if (j < p) {
                    argList.add(ESId.intern(str.substring(j, p)));
                }
                j = p + 1;
            }
            if (j < str.length()) {
                argList.add(ESId.intern(str.substring(j)));
            }
            sbuf.append(str);
        }
        ESId[] args = new ESId[argList.size()];
        argList.toArray(args);
        sbuf.append("){");
        if (length > 0) {
            sbuf.append(eval.getArg(length - 1).toString());
        }
        sbuf.append("}\n");
        sbuf.append("return anonymous();");
        Global resin = Global.getGlobalProto();
        Script script = null;
        try {
            Parser parser = new Parser();
            ReadStream is = Vfs.openString(sbuf.toString());
            script = parser.parse(is, "anonymous", 1);
            is.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ESGlobal jsClass = script.initClass(resin, eval.getGlobal());
        ESClosure fun = new ESClosure(ESId.intern("anonymous"), jsClass, null, 2, args, eval.getGlobal());
        return fun;
    }

    private ESBase createAnonymous(Call eval, int length) throws Throwable {
        return this.parseFunction(eval, length);
    }

    private ESBase apply(Call eval, int length) throws Throwable {
        Global resin = Global.getGlobalProto();
        Call call = eval.getCall();
        call.top = 1;
        call.global = eval.global;
        call.caller = eval;
        ESBase fun = eval.getArg(-1);
        ESBase callThis = null;
        callThis = length > 0 ? eval.getArg(0) : esNull;
        if (callThis == esNull || callThis == esUndefined || callThis == esEmpty) {
            call.setArg(-1, eval.getGlobal());
        } else {
            call.setArg(-1, callThis.toObject());
        }
        int j = 0;
        for (int i = 1; i < length; ++i) {
            ESBase arg = eval.getArg(i);
            if (arg == esNull || arg == esUndefined || arg == esEmpty) continue;
            ESBase arglen = arg.hasProperty(LENGTH);
            if (arglen == null) {
                call.setArg(j++, arg);
                continue;
            }
            int len = arglen.toInt32();
            if (j + len > call.stack.length - 2) {
                throw new ESException("stack overflow");
            }
            for (int k = 0; k < len; ++k) {
                call.setArg(j++, arg.getProperty(ESString.create(k)));
            }
            if (len >= 0) continue;
            call.setArg(j++, arg);
        }
        ESBase value = fun.call(call, j);
        resin.freeCall(call);
        return value;
    }
}

