/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.es;

import com.caucho.es.Call;
import com.caucho.es.ESBase;
import com.caucho.es.ESBoolean;
import com.caucho.es.ESClosure;
import com.caucho.es.ESException;
import com.caucho.es.ESId;
import com.caucho.es.ESNullException;
import com.caucho.es.ESString;
import com.caucho.es.ESThunk;
import com.caucho.es.Global;
import com.caucho.es.Native;
import com.caucho.es.PropertyEnumeration;
import com.caucho.util.CharBuffer;
import com.caucho.util.IntMap;
import java.util.HashMap;
import java.util.Iterator;

public class ESObject
extends ESBase {
    static ESId TO_STRING = ESId.intern("toString");
    static ESId VALUE_OF = ESId.intern("valueOf");
    static ESId CALL = ESId.intern("call");
    static ESId CONSTRUCT = ESId.intern("construct");
    static int DIRTY = 0;
    static int CLEAN = DIRTY + 1;
    static int COW = CLEAN + 1;
    int copyState = DIRTY;
    ESString[] propNames;
    ESBase[] propValues;
    ESBase[] propWatch;
    int[] propFlags;
    int size;
    int fill;
    int mask;
    int mark;
    protected boolean snapPrototype;

    protected ESObject() {
    }

    public ESObject(String className, ESBase proto) {
        this.init(className, proto, 16);
    }

    protected ESObject(String className, ESBase proto, int hashSize) {
        this.init(className, proto, hashSize < 16 ? 16 : hashSize);
    }

    private void init(String className, ESBase proto, int hashSize) {
        if (proto == null) {
            Global resin = Global.getGlobalProto();
            ESBase eSBase = proto = resin == null ? null : resin.objProto;
        }
        if (className == null && proto != null) {
            className = proto.className;
        }
        this.prototype = proto;
        this.propNames = new ESString[hashSize];
        this.propValues = new ESBase[hashSize];
        this.propFlags = new int[hashSize];
        this.mask = this.propNames.length - 1;
        this.size = 0;
        this.fill = 0;
        this.copyState = DIRTY;
        this.className = className == null ? "Object" : className;
    }

    void init(String className, ESBase proto) {
        this.init(className, proto, 16);
    }

    void setClean() {
        this.copyState = CLEAN;
    }

    private void resize(int newSize) {
        ESString[] newNames = new ESString[newSize];
        ESBase[] newValues = new ESBase[newSize];
        int[] newFlags = new int[newSize];
        ESBase[] newWatch = null;
        if (this.propWatch != null) {
            newWatch = new ESBase[newSize];
        }
        this.mask = newNames.length - 1;
        block0: for (int i = 0; i < this.propNames.length; ++i) {
            if (this.propValues[i] == null && (this.propFlags[i] & 8) == 0) continue;
            int hash = this.propNames[i].hashCode() & this.mask;
            while (true) {
                if (newNames[hash] == null) {
                    newNames[hash] = this.propNames[i];
                    newValues[hash] = this.propValues[i];
                    newFlags[hash] = this.propFlags[i];
                    if (newWatch == null) continue block0;
                    newWatch[hash] = this.propWatch[i];
                    continue block0;
                }
                hash = hash + 1 & this.mask;
            }
        }
        this.propNames = newNames;
        this.propValues = newValues;
        this.propFlags = newFlags;
        this.propWatch = newWatch;
        this.fill = this.size;
    }

    private void refill() {
        block0: for (int i = 0; i < this.propNames.length; ++i) {
            if (this.propValues[i] == null && (this.propFlags[i] & 8) == 0) {
                this.propNames[i] = null;
                continue;
            }
            int hash = this.propNames[i].hashCode() & this.mask;
            while (true) {
                if (this.propValues[hash] == null && (this.propFlags[hash] & 8) == 0) {
                    this.propNames[hash] = this.propNames[i];
                    this.propValues[hash] = this.propValues[i];
                    this.propFlags[hash] = this.propFlags[i];
                    this.propNames[i] = null;
                    this.propValues[i] = null;
                    this.propFlags[i] = 0;
                    continue block0;
                }
                hash = hash + 1 & this.mask;
            }
        }
        this.fill = this.size;
    }

    public ESBase getProperty(ESString name) throws Throwable {
        int hash = name.hashCode() & this.mask;
        while (true) {
            ESString propName;
            if ((propName = this.propNames[hash]) == name || name.equals(propName)) {
                ESBase value = this.propValues[hash];
                return value == null ? this.prototype.getProperty(name) : value;
            }
            if (propName == null) {
                ESBase value = this.prototype.getProperty(name);
                if (this.snapPrototype) {
                    this.setProperty(name, value);
                }
                return value;
            }
            hash = hash + 1 & this.mask;
        }
    }

    protected boolean canPut(ESString name) {
        int hash = name.hashCode() & this.mask;
        ESString propName;
        while (!name.equals(propName = this.propNames[hash]) || this.propValues[hash] == null) {
            if (propName == null) {
                if (this.prototype instanceof ESObject) {
                    return ((ESObject)this.prototype).canPut(name);
                }
                return true;
            }
            hash = hash + 1 & this.mask;
        }
        return (this.propFlags[hash] & 1) == 0;
    }

    public void setProperty(ESString name, ESBase value) throws Throwable {
        if (this.copyState != DIRTY) {
            if (this.copyState == COW) {
                this.copyAll();
            }
            this.copyState = DIRTY;
        }
        if (value == esEmpty) {
            value = esUndefined;
        }
        int hash = name.hashCode() & this.mask;
        while (true) {
            ESString propName = this.propNames[hash];
            if (this.propValues[hash] == null) {
                if (!this.prototype.canPut(name)) {
                    return;
                }
                if (propName == null) {
                    ++this.fill;
                }
                this.propNames[hash] = name;
                this.propValues[hash] = value;
                this.propFlags[hash] = 0;
                ++this.size;
                if (this.propNames.length <= 4 * this.size) {
                    this.resize(4 * this.propNames.length);
                } else if (this.propNames.length <= 2 * this.fill) {
                    this.refill();
                }
                return;
            }
            if (propName == name || propName.equals(name)) break;
            hash = hash + 1 & this.mask;
        }
        if ((this.propFlags[hash] & 1) != 0) {
            return;
        }
        this.propValues[hash] = value;
    }

    public void put(ESString name, ESBase value, int flags) {
        int hash = name.hashCode() & this.mask;
        while (true) {
            ESString propName;
            if ((propName = this.propNames[hash]) == null || this.propValues[hash] == null || propName.equals(name)) {
                if (propName == null) {
                    ++this.fill;
                }
                if (this.propValues[hash] == null) {
                    ++this.size;
                }
                this.propNames[hash] = name;
                this.propValues[hash] = value;
                this.propFlags[hash] = flags;
                if (this.propNames.length <= 4 * this.size) {
                    this.resize(4 * this.propNames.length);
                } else if (this.propNames.length <= 2 * this.fill) {
                    this.refill();
                }
                return;
            }
            hash = hash + 1 & this.mask;
        }
    }

    public void put(String name, ESBase value, int flags) {
        ESId id = ESId.intern(name);
        this.put(id, value, flags);
    }

    public ESBase delete(ESString name) throws Throwable {
        if (this.copyState != DIRTY) {
            if (this.copyState == COW) {
                this.copyAll();
            }
            this.copyState = DIRTY;
        }
        int hash = name.hashCode() & this.mask;
        ESString hashName;
        while ((hashName = this.propNames[hash]) != null) {
            if (this.propValues[hash] != null && hashName.equals(name)) {
                if ((this.propFlags[hash] & 2) != 0) {
                    return ESBoolean.FALSE;
                }
                this.propValues[hash] = null;
                --this.size;
                return ESBoolean.TRUE;
            }
            hash = hash + 1 & this.mask;
        }
        return ESBoolean.FALSE;
    }

    public void watch(ESString name, ESBase fun) {
        if (this.copyState != DIRTY) {
            if (this.copyState == COW) {
                this.copyAll();
            }
            this.copyState = DIRTY;
        }
        int hash = name.hashCode() & this.mask;
        while (true) {
            ESString propName = this.propNames[hash];
            if (this.propValues[hash] == null) {
                if (!this.prototype.canPut(name)) {
                    return;
                }
                if (propName == null) {
                    ++this.fill;
                }
                this.propNames[hash] = name;
                this.propValues[hash] = esEmpty;
                this.propFlags[hash] = 8;
                if (this.propWatch == null) {
                    this.propWatch = new ESBase[this.propFlags.length];
                }
                this.propWatch[hash] = fun;
                ++this.size;
                if (this.propNames.length <= 4 * this.size) {
                    this.resize(4 * this.propNames.length);
                } else if (this.propNames.length <= 2 * this.fill) {
                    this.refill();
                }
                return;
            }
            if (propName == name || propName.equals(name)) break;
            hash = hash + 1 & this.mask;
        }
        if ((this.propFlags[hash] & 1) != 0) {
            return;
        }
        int n = hash;
        this.propFlags[n] = this.propFlags[n] | 8;
        if (this.propWatch == null) {
            this.propWatch = new ESBase[this.propFlags.length];
        }
        this.propWatch[hash] = fun;
    }

    public void unwatch(ESString name) {
        ESString propName;
        if (this.copyState != DIRTY) {
            if (this.copyState == COW) {
                this.copyAll();
            }
            this.copyState = DIRTY;
        }
        int hash = name.hashCode() & this.mask;
        do {
            if ((propName = this.propNames[hash]) != null) continue;
            return;
        } while (!propName.equals(name));
        int n = hash;
        this.propFlags[n] = this.propFlags[n] & 0xFFFFFFF7;
    }

    public void put(int i, ESBase value, int flags) {
        this.put(ESString.create(i), value, flags);
    }

    public Iterator keys() throws ESException {
        return new PropertyEnumeration(this);
    }

    public ESBase typeof() throws ESException {
        return ESString.create("object");
    }

    public ESBase toPrimitive(int hint) throws Throwable {
        Global resin = Global.getGlobalProto();
        Call eval = resin.getCall();
        eval.global = resin.getGlobal();
        try {
            ESBase value;
            ESBase fun = this.hasProperty(hint == 1 ? TO_STRING : VALUE_OF);
            if (fun instanceof ESClosure || fun instanceof Native) {
                eval.stack[0] = this;
                eval.top = 1;
                value = fun.call(eval, 0);
                if (value instanceof ESBase && !(value instanceof ESObject)) {
                    ESBase eSBase = value;
                    return eSBase;
                }
            }
            if ((fun = this.hasProperty(hint == 1 ? VALUE_OF : TO_STRING)) instanceof ESClosure || fun instanceof Native) {
                eval.stack[0] = this;
                eval.top = 1;
                value = fun.call(eval, 0);
                if (value instanceof ESBase && !(value instanceof ESObject)) {
                    ESBase eSBase = value;
                    return eSBase;
                }
            }
            throw new ESException("cannot convert object to primitive type");
        }
        finally {
            resin.freeCall(eval);
        }
    }

    public ESObject toObject() {
        return this;
    }

    public Object toJavaObject() throws ESException {
        return this;
    }

    public double toNum() throws Throwable {
        ESBase value = this.toPrimitive(2);
        if (value instanceof ESObject) {
            throw new ESException("toPrimitive must return primitive");
        }
        return value.toNum();
    }

    public ESString toStr() throws Throwable {
        ESBase prim = this.toPrimitive(1);
        if (prim instanceof ESObject) {
            throw new ESException("toPrimitive must return primitive");
        }
        return prim.toStr();
    }

    public ESString toSource(IntMap map, boolean isLoopPass) throws Throwable {
        CharBuffer cb = new CharBuffer();
        Global resin = Global.getGlobalProto();
        int mark = map.get(this);
        if (mark > 0 && isLoopPass) {
            return null;
        }
        if (mark > 0) {
            cb.append(new CharBuffer().append("#").append(mark).append("=").toString());
            map.put(this, -mark);
        } else {
            if (mark == 0 && isLoopPass) {
                map.put(this, resin.addMark());
                return null;
            }
            if (mark < 0 && !isLoopPass) {
                return ESString.create(new CharBuffer().append("#").append(-mark).append("#").toString());
            }
        }
        cb.append("{");
        if (isLoopPass) {
            map.put(this, 0);
        }
        Iterator e = this.keys();
        boolean isFirst = true;
        while (e.hasNext()) {
            if (!isFirst) {
                cb.append(", ");
            }
            isFirst = false;
            ESString key = (ESString)e.next();
            cb.append(key);
            cb.append(":");
            ESBase value = this.getProperty(key);
            if (isLoopPass) {
                value.toSource(map, isLoopPass);
                continue;
            }
            cb.append(value.toSource(map, isLoopPass));
        }
        cb.append("}");
        return new ESString(cb.toString());
    }

    public boolean toBoolean() {
        return true;
    }

    ESObject dup() {
        return new ESObject();
    }

    public Object copy(HashMap refs) {
        Object ref = refs.get(this);
        if (ref != null) {
            return ref;
        }
        ESObject copy = this.dup();
        refs.put(this, copy);
        this.copy(refs, copy);
        return copy;
    }

    private void copyAll() {
        this.copyState = DIRTY;
        int len = this.propValues.length;
        ESString[] newPropNames = new ESString[len];
        int[] newPropFlags = new int[len];
        ESBase[] newPropValues = new ESBase[len];
        System.arraycopy(this.propNames, 0, newPropNames, 0, len);
        System.arraycopy(this.propFlags, 0, newPropFlags, 0, len);
        System.arraycopy(this.propValues, 0, newPropValues, 0, len);
        this.propNames = newPropNames;
        this.propFlags = newPropFlags;
        this.propValues = newPropValues;
        if (this.propWatch != null) {
            ESBase[] newPropWatch = new ESBase[len];
            System.arraycopy(this.propWatch, 0, newPropWatch, 0, len);
            this.propWatch = newPropWatch;
        }
    }

    ESObject resinCopy() {
        ESObject obj = this.dup();
        this.copy(obj);
        return obj;
    }

    protected void copy(Object newObj) {
        ESObject obj = (ESObject)newObj;
        obj.prototype = this.prototype;
        obj.className = this.className;
        obj.propNames = this.propNames;
        obj.propValues = this.propValues;
        obj.propFlags = this.propFlags;
        obj.propWatch = this.propWatch;
        obj.size = this.size;
        obj.fill = this.fill;
        obj.mask = this.mask;
        obj.copyState = this.copyState;
        if (obj.copyState == DIRTY) {
            throw new RuntimeException();
        }
        if (this.copyState == CLEAN) {
            this.copyState = COW;
            obj.copyState = COW;
        }
    }

    protected void copy(HashMap refs, Object newObj) {
        ESObject obj = (ESObject)newObj;
        obj.prototype = (ESBase)this.prototype.copy(refs);
        obj.className = this.className;
        obj.propNames = this.propNames;
        obj.propValues = this.propValues;
        obj.propFlags = this.propFlags;
        obj.propWatch = this.propWatch;
        obj.size = this.size;
        obj.fill = this.fill;
        obj.mask = this.mask;
        obj.copyState = this.copyState;
        if (obj.copyState == DIRTY) {
            obj.copyAll();
        } else if (this.copyState == CLEAN) {
            this.copyState = COW;
            obj.copyState = COW;
        }
    }

    ESObject shallowCopy() {
        ESObject obj = this.dup();
        this.shallowCopy(obj);
        return obj;
    }

    protected void shallowCopy(Object newObj) {
        ESObject obj = (ESObject)newObj;
        obj.prototype = this.prototype;
        obj.className = this.className;
        int len = this.propValues.length;
        if (this.propWatch != null) {
            obj.propWatch = new ESBase[len];
            System.arraycopy(this.propWatch, 0, obj.propWatch, 0, len);
        }
        obj.propNames = new ESString[len];
        obj.propFlags = new int[len];
        obj.propValues = new ESBase[len];
        ESString[] newNames = obj.propNames;
        ESString[] oldNames = this.propNames;
        ESBase[] newValues = obj.propValues;
        ESBase[] oldValues = this.propValues;
        int[] newFlags = obj.propFlags;
        int[] oldFlags = this.propFlags;
        for (int i = 0; i < len; ++i) {
            newNames[i] = oldNames[i];
            newValues[i] = oldValues[i];
            newFlags[i] = oldFlags[i];
        }
        obj.size = this.size;
        obj.mask = this.mask;
        obj.fill = this.fill;
        obj.copyState = DIRTY;
    }

    public boolean ecmaEquals(ESBase b) throws Throwable {
        if (b instanceof ESObject || b instanceof ESThunk) {
            return this == b;
        }
        return this.toPrimitive(0).ecmaEquals(b);
    }

    public ESBase call(Call call, int length) throws Throwable {
        ESBase callFun = this.hasProperty(CALL);
        if (callFun != null) {
            call.setThis(this);
            return callFun.call(call, length);
        }
        throw new ESNullException(new CharBuffer().append(this.toStr()).append(" is not a function").toString());
    }

    public ESBase construct(Call call, int length) throws Throwable {
        ESBase callFun = this.hasProperty(CONSTRUCT);
        if (callFun != null) {
            call.setThis(this);
            return callFun.construct(call, length);
        }
        throw new ESNullException(new CharBuffer().append(this.toStr()).append(" is not a constructor").toString());
    }
}

