/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.es;

import com.caucho.es.Call;
import com.caucho.es.ESBase;
import com.caucho.es.ESBoolean;
import com.caucho.es.ESCallable;
import com.caucho.es.ESException;
import com.caucho.es.ESGlobal;
import com.caucho.es.ESId;
import com.caucho.es.ESNumber;
import com.caucho.es.ESObject;
import com.caucho.es.ESString;
import com.caucho.es.Global;

public class ESClosure
extends ESObject {
    static ESString LENGTH = ESId.intern("length");
    static ESString CALLEE = ESId.intern("callee");
    static ESString ARGUMENTS = ESId.intern("arguments");
    static ESString OBJECT = ESId.intern("Object");
    static ESString PROTOTYPE = ESId.intern("prototype");
    static ESString CONSTRUCTOR = ESId.intern("constructor");
    public ESString name;
    private ESCallable esClass;
    public int n;
    ESId[] formals;
    int nFormals;
    ESBase proto;
    ESGlobal global;
    int stackRequired;
    int scopeRequired;
    ESBase[] scope;
    int scopeLength;
    boolean hasFields;

    public ESClosure(ESString name, ESCallable esClass, ESObject proto, int n, ESId[] formals, ESObject global) {
        this.className = "Function";
        this.prototype = Global.getGlobalProto().funProto;
        this.name = name;
        this.esClass = esClass;
        this.proto = proto;
        this.n = n;
        this.formals = formals;
        this.nFormals = formals.length;
        if (global instanceof ESGlobal) {
            this.global = (ESGlobal)global;
        }
        if (global != null) {
            this.scopeLength = 1;
            this.scope = new ESBase[1];
            this.scope[0] = global;
        }
    }

    protected ESClosure(ESBase[] scope, int scopeLength) {
        super("Function", null);
        this.hasFields = true;
        this.scope = scope;
        this.scopeLength = scopeLength;
    }

    protected ESClosure() {
    }

    public void closure(Call env) {
        if (this.scope == null) {
            this.scope = new ESBase[16];
        }
        while (this.scopeLength < env.scopeLength) {
            this.scope[this.scopeLength] = env.scope[this.scopeLength];
            ++this.scopeLength;
        }
        if (this.scopeLength == 0) {
            this.scope[this.scopeLength++] = env.global;
        }
        this.global = (ESGlobal)this.scope[0];
    }

    void setScope(ESBase[] scope, int scopeLength) {
        this.scope = scope;
        this.scopeLength = scopeLength;
    }

    public ESBase hasProperty(ESString id) throws Throwable {
        if (id.equals(PROTOTYPE)) {
            if (this.proto == null) {
                ESObject obj = Global.getGlobalProto().createObject();
                this.proto = obj;
                obj.put(CONSTRUCTOR, (ESBase)this, 4);
            }
            return this.proto;
        }
        if (id.equals(LENGTH)) {
            return ESNumber.create(this.nFormals);
        }
        if (this.hasFields) {
            return super.hasProperty(id);
        }
        if (this.prototype != null) {
            return this.prototype.hasProperty(id);
        }
        return ESBase.esEmpty;
    }

    public ESBase getProperty(ESString id) throws Throwable {
        if (id.equals(PROTOTYPE)) {
            if (this.proto == null) {
                ESObject obj = Global.getGlobalProto().createObject();
                this.proto = obj;
                obj.put(CONSTRUCTOR, (ESBase)this, 4);
            }
            return this.proto;
        }
        if (id.equals(LENGTH)) {
            return ESNumber.create(this.nFormals);
        }
        if (this.hasFields) {
            return super.getProperty(id);
        }
        return this.prototype.getProperty(id);
    }

    public boolean canPut(ESString id) {
        if (id.equals(PROTOTYPE)) {
            return true;
        }
        if (id.equals(LENGTH)) {
            return false;
        }
        if (this.hasFields) {
            return super.canPut(id);
        }
        return true;
    }

    public void setProperty(ESString id, ESBase value) throws Throwable {
        if (id.equals(PROTOTYPE)) {
            this.proto = value;
        } else if (!id.equals(LENGTH)) {
            if (this.hasFields) {
                super.setProperty(id, value);
            } else {
                this.init(this.className, this.prototype);
                this.hasFields = true;
                super.setProperty(id, value);
            }
        }
    }

    public void put(ESString id, ESBase value, int flags) {
        if (id.equals(PROTOTYPE)) {
            this.proto = value;
        } else if (!id.equals(LENGTH)) {
            if (this.hasFields) {
                super.put(id, value, flags);
            } else {
                this.init(this.className, this.prototype);
                this.hasFields = true;
                super.put(id, value, flags);
            }
        }
    }

    public ESBase delete(ESString id) throws Throwable {
        if (id.equals(PROTOTYPE)) {
            this.proto = ESBase.esEmpty;
            return ESBoolean.TRUE;
        }
        if (id.equals(LENGTH)) {
            return ESBoolean.FALSE;
        }
        if (this.hasFields) {
            return super.delete(id);
        }
        return ESBoolean.TRUE;
    }

    public ESString toStr() {
        return ESString.create(this.decompile());
    }

    String decompile() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("function ");
        if (this.name != null && !this.name.toString().startsWith("$lambda")) {
            sbuf.append(this.name);
        }
        sbuf.append("(");
        for (int i = 0; this.formals != null && i < this.nFormals; ++i) {
            if (i != 0) {
                sbuf.append(", ");
            }
            sbuf.append(this.formals[i]);
        }
        sbuf.append(") ");
        sbuf.append("{ ");
        sbuf.append("[compiled code]");
        sbuf.append(" }");
        return sbuf.toString();
    }

    protected ESBase dispatch() throws ESException {
        throw new ESException("dispatch not specialized");
    }

    public ESBase call(Call call, int length) throws Throwable {
        if (this.global != null) {
            call.global = this.global;
        }
        if (this.esClass != null) {
            return this.esClass.call(this.n, call, length);
        }
        return ESBase.esUndefined;
    }

    public ESBase construct(Call eval, int length) throws Throwable {
        Global resin = Global.getGlobalProto();
        ESObject obj = Global.getGlobalProto().createObject();
        ESBase proto = this.proto;
        if (!(proto instanceof ESObject)) {
            proto = resin.object.getProperty(PROTOTYPE);
        }
        if (proto instanceof ESObject) {
            obj.prototype = proto;
        }
        eval.setThis(obj);
        ESBase value = this.call(eval, length);
        return value instanceof ESObject ? (ESObject)value : obj;
    }

    public ESBase typeof() throws ESException {
        return ESString.create("function");
    }

    protected void copy(Object newObj) {
        ESClosure closure = (ESClosure)newObj;
        super.copy(newObj);
        closure.name = this.name;
        closure.esClass = this.esClass;
        closure.n = this.n;
        closure.formals = this.formals;
        closure.nFormals = this.nFormals;
        closure.stackRequired = this.stackRequired;
        closure.scopeRequired = this.scopeRequired;
        closure.scopeLength = this.scopeLength;
        closure.scope = new ESBase[this.scopeLength];
        closure.hasFields = this.hasFields;
        for (int i = 0; i < this.scopeLength; ++i) {
            if (this.scope[i] == null) continue;
            closure.scope[i] = this.scope[i];
        }
        closure.proto = this.proto;
    }

    public ESObject dup() {
        return new ESClosure();
    }

    ESObject resinCopy() {
        ESObject obj = this.dup();
        this.copy(obj);
        return obj;
    }

    ESObject getClassPrototype() throws Throwable {
        ESBase proto = this.hasProperty(PROTOTYPE);
        return (ESObject)proto;
    }

    void setClassPrototype(ESObject proto) throws ESException {
        this.proto = proto;
        proto.put(CONSTRUCTOR, (ESBase)this, 4);
    }
}

