/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.el;

import com.caucho.el.Expr;
import com.caucho.util.CharBuffer;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import javax.servlet.jsp.el.ELException;
import javax.servlet.jsp.el.VariableResolver;

public class UnaryExpr
extends Expr {
    private int _op;
    private Expr _expr;

    public UnaryExpr(int op, Expr expr) {
        this._op = op;
        this._expr = expr;
    }

    public boolean isConstant() {
        return this._expr.isConstant();
    }

    public Object evalObject(VariableResolver env) throws ELException {
        switch (this._op) {
            case 14: {
                return new Boolean(!this._expr.evalBoolean(env));
            }
            case 15: {
                Object obj = this._expr.evalObject(env);
                if (obj == null) {
                    return new Long(0L);
                }
                if (obj instanceof Double || obj instanceof Float) {
                    return new Double(-((Number)obj).doubleValue());
                }
                if (obj instanceof Number) {
                    return new Long(-((Number)obj).longValue());
                }
                if (obj instanceof String) {
                    String s = (String)obj;
                    if (s.indexOf(46) < 0) {
                        return new Long(-UnaryExpr.toLong(obj, env));
                    }
                    return new Double(-UnaryExpr.toDouble(obj, env));
                }
                return new Double(-UnaryExpr.toDouble(obj, env));
            }
            case 16: {
                if (this.evalBoolean(env)) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        }
        throw new UnsupportedOperationException();
    }

    public boolean evalBoolean(VariableResolver env) throws ELException {
        switch (this._op) {
            case 14: {
                return !this._expr.evalBoolean(env);
            }
            case 16: {
                Object obj = this._expr.evalObject(env);
                if (obj == null) {
                    return true;
                }
                if (obj instanceof String) {
                    return "".equals(obj);
                }
                if (obj instanceof Collection) {
                    return ((Collection)obj).isEmpty();
                }
                if (obj instanceof Map) {
                    return ((Map)obj).isEmpty();
                }
                if (obj.getClass().isArray()) {
                    return Array.getLength(obj) == 0;
                }
                return false;
            }
        }
        ELException e = new ELException(L.l("can't compare."));
        UnaryExpr.error(e, env);
        return false;
    }

    public long evalLong(VariableResolver env) throws ELException {
        if (this._op != 15) {
            ELException e = new ELException(L.l("'not' and 'empty' operations can not be converted to long values."));
            UnaryExpr.error(e, env);
            return 0L;
        }
        return -this._expr.evalLong(env);
    }

    public double evalDouble(VariableResolver env) throws ELException {
        if (this._op != 15) {
            ELException e = new ELException(L.l("'not' and 'empty' operations can not be converted to double values."));
            UnaryExpr.error(e, env);
            return 0.0;
        }
        return -this._expr.evalDouble(env);
    }

    public void printCreate(WriteStream os) throws IOException {
        os.print("new com.caucho.el.UnaryExpr(");
        os.print(new CharBuffer().append(this._op).append(", ").toString());
        this._expr.printCreate(os);
        os.print(")");
    }

    public boolean equals(Object o) {
        if (!(o instanceof UnaryExpr)) {
            return false;
        }
        UnaryExpr uexpr = (UnaryExpr)o;
        return this._op == uexpr._op && this._expr.equals(uexpr._expr);
    }

    public String toString() {
        String op;
        switch (this._op) {
            case 15: {
                op = " -";
                break;
            }
            case 14: {
                op = " not ";
                break;
            }
            case 16: {
                op = " empty ";
                break;
            }
            default: {
                op = new CharBuffer().append(" unknown(").append(this._op).append(") ").toString();
            }
        }
        return new CharBuffer().append(op).append(this._expr).toString();
    }
}

