/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.el;

import com.caucho.el.ArrayExpr;
import com.caucho.el.Expr;
import com.caucho.el.FunctionExpr;
import com.caucho.el.MethodExpr;
import com.caucho.el.StringLiteral;
import com.caucho.util.CharBuffer;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import javax.servlet.jsp.el.ELException;
import javax.servlet.jsp.el.VariableResolver;

public class PathExpr
extends Expr {
    private Expr _expr;
    private String _path;

    public PathExpr(Expr expr, String path) {
        this._expr = expr;
        this._path = path;
    }

    public Expr createField(String field) {
        Expr arrayExpr = this._expr.createField(new StringLiteral(field));
        return new PathExpr(arrayExpr, new CharBuffer().append(this._path).append('.').append(field).toString());
    }

    public Expr createMethod(Expr[] args) {
        ArrayExpr array;
        Expr index;
        if (this._expr instanceof ArrayExpr && (index = (array = (ArrayExpr)this._expr).getIndex()) instanceof StringLiteral) {
            StringLiteral string = (StringLiteral)index;
            return new MethodExpr(array.getExpr(), string.getValue(), args);
        }
        return new FunctionExpr(this, args);
    }

    public Object evalObject(VariableResolver env) throws ELException {
        Object value = this._expr.evalObject(env);
        if (value != null) {
            return value;
        }
        return env.resolveVariable(this._path);
    }

    public void printCreate(WriteStream os) throws IOException {
        os.print("new com.caucho.el.PathExpr(");
        this._expr.printCreate(os);
        os.print(", \"");
        os.print(this._path);
        os.print("\")");
    }

    public boolean equals(Object o) {
        if (!(o instanceof PathExpr)) {
            return false;
        }
        PathExpr expr = (PathExpr)o;
        return this._expr.equals(expr._expr) && this._path.equals(expr._path);
    }

    public String toString() {
        return String.valueOf(this._expr);
    }
}

