/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.el;

import com.caucho.el.Expr;
import java.util.HashMap;
import javax.servlet.jsp.el.ELException;
import javax.servlet.jsp.el.VariableResolver;

public abstract class Marshall {
    private static final HashMap<Class, Marshall> ARG_MAP = new HashMap();
    public static final Marshall BOOLEAN = new Marshall(){

        public Object marshall(Expr expr, VariableResolver env) throws ELException {
            return new Boolean(expr.evalBoolean(env));
        }
    };
    public static final Marshall BYTE = new Marshall(){

        public Object marshall(Expr expr, VariableResolver env) throws ELException {
            return new Byte((byte)expr.evalLong(env));
        }
    };
    public static final Marshall SHORT = new Marshall(){

        public Object marshall(Expr expr, VariableResolver env) throws ELException {
            return new Short((short)expr.evalLong(env));
        }
    };
    public static final Marshall INTEGER = new Marshall(){

        public Object marshall(Expr expr, VariableResolver env) throws ELException {
            return new Integer((int)expr.evalLong(env));
        }
    };
    public static final Marshall LONG = new Marshall(){

        public Object marshall(Expr expr, VariableResolver env) throws ELException {
            return new Long(expr.evalLong(env));
        }
    };
    public static final Marshall FLOAT = new Marshall(){

        public Object marshall(Expr expr, VariableResolver env) throws ELException {
            return new Float((float)expr.evalDouble(env));
        }
    };
    public static final Marshall DOUBLE = new Marshall(){

        public Object marshall(Expr expr, VariableResolver env) throws ELException {
            return new Double(expr.evalDouble(env));
        }
    };
    public static final Marshall STRING = new Marshall(){

        public Object marshall(Expr expr, VariableResolver env) throws ELException {
            return expr.evalString(env);
        }
    };
    public static final Marshall CHARACTER = new Marshall(){

        public Object marshall(Expr expr, VariableResolver env) throws ELException {
            String s = expr.evalString(env);
            if (s == null || s.length() == 0) {
                return null;
            }
            return new Character(s.charAt(0));
        }
    };
    public static final Marshall OBJECT = new Marshall(){

        public Object marshall(Expr expr, VariableResolver env) throws ELException {
            return expr.evalObject(env);
        }
    };
    private static Class _resin_compat_class_0;
    private static Class _resin_compat_class_1;
    private static Class _resin_compat_class_2;
    private static Class _resin_compat_class_3;
    private static Class _resin_compat_class_4;
    private static Class _resin_compat_class_5;
    private static Class _resin_compat_class_6;
    private static Class _resin_compat_class_7;
    private static Class _resin_compat_class_8;

    public static Marshall create(Class arg) {
        Marshall marshall = ARG_MAP.get(arg);
        if (marshall != null) {
            return marshall;
        }
        return OBJECT;
    }

    public abstract Object marshall(Expr var1, VariableResolver var2) throws ELException;

    static {
        ARG_MAP.put(Boolean.TYPE, BOOLEAN);
        ARG_MAP.put(Marshall._resin_compat_class_0(), BOOLEAN);
        ARG_MAP.put(Byte.TYPE, BYTE);
        ARG_MAP.put(Marshall._resin_compat_class_1(), BYTE);
        ARG_MAP.put(Short.TYPE, SHORT);
        ARG_MAP.put(Marshall._resin_compat_class_2(), SHORT);
        ARG_MAP.put(Integer.TYPE, INTEGER);
        ARG_MAP.put(Marshall._resin_compat_class_3(), INTEGER);
        ARG_MAP.put(Long.TYPE, LONG);
        ARG_MAP.put(Marshall._resin_compat_class_4(), LONG);
        ARG_MAP.put(Float.TYPE, FLOAT);
        ARG_MAP.put(Marshall._resin_compat_class_5(), FLOAT);
        ARG_MAP.put(Double.TYPE, DOUBLE);
        ARG_MAP.put(Marshall._resin_compat_class_6(), DOUBLE);
        ARG_MAP.put(Character.TYPE, CHARACTER);
        ARG_MAP.put(Marshall._resin_compat_class_7(), CHARACTER);
        ARG_MAP.put(Marshall._resin_compat_class_8(), STRING);
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("java.lang.Boolean");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_1() {
        try {
            Class<?> clazz = _resin_compat_class_1;
            if (clazz == null) {
                clazz = _resin_compat_class_1 = Class.forName("java.lang.Byte");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_2() {
        try {
            Class<?> clazz = _resin_compat_class_2;
            if (clazz == null) {
                clazz = _resin_compat_class_2 = Class.forName("java.lang.Short");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_3() {
        try {
            Class<?> clazz = _resin_compat_class_3;
            if (clazz == null) {
                clazz = _resin_compat_class_3 = Class.forName("java.lang.Integer");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_4() {
        try {
            Class<?> clazz = _resin_compat_class_4;
            if (clazz == null) {
                clazz = _resin_compat_class_4 = Class.forName("java.lang.Long");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_5() {
        try {
            Class<?> clazz = _resin_compat_class_5;
            if (clazz == null) {
                clazz = _resin_compat_class_5 = Class.forName("java.lang.Float");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_6() {
        try {
            Class<?> clazz = _resin_compat_class_6;
            if (clazz == null) {
                clazz = _resin_compat_class_6 = Class.forName("java.lang.Double");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_7() {
        try {
            Class<?> clazz = _resin_compat_class_7;
            if (clazz == null) {
                clazz = _resin_compat_class_7 = Class.forName("java.lang.Character");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_8() {
        try {
            Class<?> clazz = _resin_compat_class_8;
            if (clazz == null) {
                clazz = _resin_compat_class_8 = Class.forName("java.lang.String");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

