/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.el;

import com.caucho.el.ELParseException;
import com.caucho.el.ELParser;
import com.caucho.el.EnvironmentResolver;
import com.caucho.el.Expr;
import com.caucho.el.SystemPropertiesResolver;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.log.Log;
import com.caucho.util.L10N;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.servlet.jsp.el.ELException;
import javax.servlet.jsp.el.VariableResolver;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EL {
    private static final Logger log = Log.open(EL._resin_compat_class_0());
    private static final L10N L = new L10N(EL._resin_compat_class_0());
    private static EnvironmentLocal<VariableResolver> _elEnvironment = new EnvironmentLocal();
    private static EnvironmentLocal<HashMap<String, Object>> _envVar = new EnvironmentLocal();
    public static final Object NULL = new Object();
    private static Class _resin_compat_class_0;

    public static VariableResolver getEnvironment() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        return EL.getEnvironment(loader);
    }

    public static VariableResolver getEnvironment(ClassLoader loader) {
        VariableResolver resolver = _elEnvironment.get(loader);
        if (resolver == null) {
            SystemPropertiesResolver parent = new SystemPropertiesResolver();
            resolver = new EnvironmentResolver(loader, parent);
            _elEnvironment.set(resolver, loader);
        }
        return resolver;
    }

    public static void setEnvironment(VariableResolver env) {
        _elEnvironment.set(env);
    }

    public static void setEnvironment(VariableResolver env, ClassLoader loader) {
        _elEnvironment.set(env, loader);
    }

    public static void setVariableMap(HashMap<String, Object> map, ClassLoader loader) {
        _envVar.set(map, loader);
    }

    public static Object getLevelVar(String name, ClassLoader loader) {
        HashMap<String, Object> varMap = _envVar.getLevel(loader);
        if (varMap == null) {
            return null;
        }
        return varMap.get(name);
    }

    public static Object putVar(String name, Object value) {
        return EL.putVar(name, value, Thread.currentThread().getContextClassLoader());
    }

    public static Object putVar(String name, Object value, ClassLoader loader) {
        HashMap<String, Object> varMap = _envVar.getLevel(loader);
        if (varMap == null) {
            varMap = new HashMap();
            _envVar.set(varMap, loader);
        }
        return varMap.put(name, value);
    }

    public static Object evalObject(String value) throws ELParseException, ELException {
        ELParser parser = new ELParser(value);
        Expr expr = parser.parse();
        return expr.evalObject(EL.getEnvironment());
    }

    public static Object evalObject(String value, VariableResolver env) throws ELParseException, ELException {
        ELParser parser = new ELParser(value);
        Expr expr = parser.parse();
        return expr.evalObject(env);
    }

    public static String evalString(String value, VariableResolver env) throws ELParseException, ELException {
        ELParser parser = new ELParser(value);
        Expr expr = parser.parse();
        return expr.evalString(env);
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.el.EL");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

