/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.el;

import com.caucho.el.Expr;
import com.caucho.util.CharBuffer;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import javax.servlet.jsp.el.ELException;
import javax.servlet.jsp.el.VariableResolver;

public class ConditionalExpr
extends Expr {
    private Expr _test;
    private Expr _trueExpr;
    private Expr _falseExpr;

    public ConditionalExpr(Expr test, Expr trueExpr, Expr falseExpr) {
        this._test = test;
        this._trueExpr = trueExpr;
        this._falseExpr = falseExpr;
    }

    public boolean isConstant() {
        return this._test.isConstant() && this._trueExpr.isConstant() && this._falseExpr.isConstant();
    }

    public Object evalObject(VariableResolver env) throws ELException {
        if (this._test.evalBoolean(env)) {
            return this._trueExpr.evalObject(env);
        }
        return this._falseExpr.evalObject(env);
    }

    public long evalLong(VariableResolver env) throws ELException {
        if (this._test.evalBoolean(env)) {
            return this._trueExpr.evalLong(env);
        }
        return this._falseExpr.evalLong(env);
    }

    public double evalDouble(VariableResolver env) throws ELException {
        if (this._test.evalBoolean(env)) {
            return this._trueExpr.evalDouble(env);
        }
        return this._falseExpr.evalDouble(env);
    }

    public String evalString(VariableResolver env) throws ELException {
        if (this._test.evalBoolean(env)) {
            return this._trueExpr.evalString(env);
        }
        return this._falseExpr.evalString(env);
    }

    public boolean evalBoolean(VariableResolver env) throws ELException {
        if (this._test.evalBoolean(env)) {
            return this._trueExpr.evalBoolean(env);
        }
        return this._falseExpr.evalBoolean(env);
    }

    public void printCreate(WriteStream os) throws IOException {
        os.print("new com.caucho.el.ConditionalExpr(");
        this._test.printCreate(os);
        os.print(", ");
        this._trueExpr.printCreate(os);
        os.print(", ");
        this._falseExpr.printCreate(os);
        os.print(")");
    }

    public boolean equals(Object o) {
        if (!(o instanceof ConditionalExpr)) {
            return false;
        }
        ConditionalExpr expr = (ConditionalExpr)o;
        return this._test == expr._test && this._trueExpr.equals(expr._trueExpr) && this._falseExpr.equals(expr._falseExpr);
    }

    public String toString() {
        return new CharBuffer().append("(").append(this._test).append(" ? ").append(this._trueExpr).append(" : ").append(this._falseExpr).append(")").toString();
    }
}

