/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.xa;

import com.caucho.amber.connection.AmberConnectionImpl;
import com.caucho.ejb.EJBExceptionWrapper;
import com.caucho.ejb.entity.EntityServer;
import com.caucho.ejb.entity.QEntity;
import com.caucho.ejb.xa.EjbTransactionManager;
import com.caucho.ejb.xa.TransactionObject;
import com.caucho.log.Log;
import com.caucho.transaction.TransactionImpl;
import com.caucho.util.Alarm;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJBException;
import javax.ejb.SessionSynchronization;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.UserTransaction;

public class TransactionContext
implements Synchronization {
    static final L10N L = new L10N(TransactionContext._resin_compat_class_0());
    protected static final Logger log = Log.open(TransactionContext._resin_compat_class_0());
    public static final TransactionContext NULL_TRANSACTION = new TransactionContext(null);
    private EjbTransactionManager _container;
    private AmberConnectionImpl _amberConn;
    private UserTransaction _userTransaction;
    private Transaction _transaction;
    TransactionContext _old;
    Transaction _oldTrans;
    private long _startTime;
    private TransactionObject[] _objects = new TransactionObject[16];
    private int _objectTop;
    private SessionSynchronization[] _sessions = new SessionSynchronization[16];
    private int _sessionTop;
    private boolean _isRowLocking;
    private boolean _rollbackOnly;
    private boolean _isUserTransaction;
    private int _depth;
    private boolean _isAlive;
    private boolean _isCommitting;
    private static Class _resin_compat_class_0;

    TransactionContext(EjbTransactionManager container) {
        this._container = container;
        if (container != null) {
            this._userTransaction = container.getUserTransaction();
        }
    }

    void init(boolean pushDepth) {
        if (this._isAlive) {
            log.warning(L.l("Transaction {0} nested start.  This is an internal Resin error, please report it as a bug at bugs@caucho.com.", this));
            throw new IllegalStateException(L.l("nested transaction start"));
        }
        this._transaction = null;
        this._old = null;
        this._oldTrans = null;
        this._objectTop = 0;
        this._sessionTop = 0;
        this._rollbackOnly = false;
        this._depth = pushDepth ? 1 : 0;
        this._isUserTransaction = false;
        this._isAlive = true;
        this._isRowLocking = false;
        this._startTime = Alarm.getCurrentTime();
    }

    public void setTransaction(Transaction transaction) {
        if (this._transaction != null && this._transaction != transaction) {
            throw new IllegalStateException("can't set transaction twice.");
        }
        this._transaction = transaction;
        if (transaction != null) {
            try {
                transaction.registerSynchronization((Synchronization)this);
            }
            catch (Exception e) {
                throw new EJBExceptionWrapper(e);
            }
        }
    }

    public Transaction getTransaction() {
        return this._transaction;
    }

    public boolean isReadOnly() {
        return this._transaction == null;
    }

    public boolean isRowLocking() {
        return this._transaction != null && this._isRowLocking;
    }

    public void setRowLocking(boolean isRowLocking) {
        this._isRowLocking = isRowLocking;
    }

    TransactionContext getOld() {
        return this._old;
    }

    void setOld(TransactionContext old) {
        this._old = old;
    }

    Transaction getOldTrans() {
        return this._oldTrans;
    }

    void setOldTrans(Transaction old) {
        if (old == this._transaction && old != null) {
            throw new IllegalStateException();
        }
        this._oldTrans = old;
    }

    public void pushDepth() {
        if (this._depth == 0) {
            this._isAlive = true;
        }
        ++this._depth;
    }

    public void setUserTransaction(boolean isUserTransaction) {
        if (this._depth == 0) {
            this._isAlive = true;
        }
        this._isUserTransaction = isUserTransaction;
    }

    public boolean getRollbackOnly() {
        return this._rollbackOnly;
    }

    public void setRollbackOnly() {
        this._rollbackOnly = true;
        if (this._transaction != null) {
            try {
                this._transaction.setRollbackOnly();
            }
            catch (Exception e) {
                throw new EJBExceptionWrapper(e);
            }
        }
    }

    public RuntimeException setRollbackOnly(Throwable exn) {
        this._rollbackOnly = true;
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, new CharBuffer().append("rollback only: ").append(exn).toString(), exn);
        }
        if (this._transaction != null) {
            try {
                if (this._transaction instanceof TransactionImpl) {
                    ((TransactionImpl)this._transaction).setRollbackOnly(exn);
                } else {
                    this._transaction.setRollbackOnly();
                }
            }
            catch (Exception e) {
                return EJBExceptionWrapper.createRuntime(exn);
            }
        }
        return EJBExceptionWrapper.createRuntime(exn);
    }

    public void addObject(TransactionObject object) {
        if (this._objectTop + 1 >= this._objects.length) {
            TransactionObject[] newObjects = new TransactionObject[this._objects.length * 2];
            for (int i = 0; i < this._objectTop; ++i) {
                newObjects[i] = this._objects[i];
            }
            this._objects = newObjects;
        }
        this._objects[this._objectTop++] = object;
    }

    public void removeObject(TransactionObject object) {
        for (int i = 0; i < this._objectTop; ++i) {
            if (this._objects[i] != object) continue;
            int j = i;
            while (j + 1 < this._objectTop) {
                this._objects[j] = this._objects[j + 1];
                ++j;
            }
            --i;
            --this._objectTop;
        }
    }

    public QEntity getEntity(EntityServer server, Object primaryKey) {
        for (int i = this._objectTop - 1; i >= 0; --i) {
            QEntity entity;
            TransactionObject obj = this._objects[i];
            if (!(obj instanceof QEntity) || !(entity = (QEntity)obj)._caucho_isMatch(server, primaryKey)) continue;
            return entity;
        }
        return null;
    }

    public AmberConnectionImpl getAmberConnection() {
        if (this._amberConn == null) {
            this._amberConn = this._container.getEJBManager().getAmberManager().createAmberConnection();
        }
        try {
            this._amberConn.setXA(this._transaction != null);
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        return this._amberConn;
    }

    public void addSession(SessionSynchronization session) throws EJBException {
        for (int i = this._sessionTop - 1; i >= 0; --i) {
            if (this._sessions[i] != session) continue;
            return;
        }
        if (this._sessionTop + 1 >= this._sessions.length) {
            SessionSynchronization[] newSessions = new SessionSynchronization[this._sessions.length * 2];
            for (int i = 0; i < this._sessionTop; ++i) {
                newSessions[i] = this._sessions[i];
            }
            this._sessions = newSessions;
        }
        this._sessions[this._sessionTop++] = session;
        try {
            session.afterBegin();
        }
        catch (RemoteException e) {
            EJBException exn = new EJBException(e.toString());
            exn.initCause((Throwable)e);
            throw exn;
        }
    }

    public void sync() throws EJBException {
        try {
            for (int i = this._objectTop - 1; i >= 0; --i) {
                this._objects[i]._caucho_sync();
            }
        }
        catch (Exception e) {
            throw this.setRollbackOnly(e);
        }
    }

    public boolean isEmpty() {
        if (!this._isAlive) {
            return true;
        }
        if (this._transaction == null) {
            return true;
        }
        if (!(this._transaction instanceof TransactionImpl)) {
            return false;
        }
        return ((TransactionImpl)this._transaction).isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws EJBException {
        block14: {
            if (this._isCommitting || --this._depth > 0) {
                return;
            }
            boolean hasCompletion = false;
            try {
                this._isCommitting = true;
                if (!this._isAlive) {
                    log.warning(L.l("Transaction has died"));
                    break block14;
                }
                if (this._transaction == null) {
                    hasCompletion = true;
                    try {
                        this.beforeCompletion();
                        this.afterCompletion(this._rollbackOnly ? 4 : 3);
                        break block14;
                    }
                    catch (Throwable throwable) {
                        this.afterCompletion(this._rollbackOnly ? 4 : 3);
                        throw throwable;
                    }
                }
                if (this._rollbackOnly || this._transaction.getStatus() == 1) {
                    hasCompletion = true;
                    this._userTransaction.rollback();
                } else if (this._transaction.getStatus() != 6) {
                    hasCompletion = true;
                    this._userTransaction.commit();
                }
            }
            catch (Exception e) {
                throw EJBExceptionWrapper.createRuntime(e);
            }
            finally {
                this._isCommitting = false;
                if (!hasCompletion) {
                    this.afterCompletion(4);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws EJBException {
        block13: {
            if (this._isCommitting || --this._depth > 0) {
                return;
            }
            try {
                this._isCommitting = true;
                if (!this._rollbackOnly) {
                    this.setRollbackOnly();
                }
                if (this._transaction == null && this._isAlive) {
                    try {
                        this.beforeCompletion();
                        break block13;
                    }
                    finally {
                        this.afterCompletion(4);
                    }
                }
                this._userTransaction.rollback();
            }
            catch (EJBException e) {
                throw e;
            }
            catch (Exception e) {
                throw new EJBExceptionWrapper(e);
            }
            finally {
                this._isCommitting = false;
                if (this._depth <= 0 && this._transaction != null) {
                    this.afterCompletion(4);
                }
            }
        }
    }

    public void beforeCompletion() {
        try {
            int i;
            if (this._transaction != null && this._transaction.getStatus() == 1) {
                this._rollbackOnly = true;
            }
            for (i = this._sessionTop - 1; i >= 0; --i) {
                this._sessions[i].beforeCompletion();
            }
            for (i = this._objectTop - 1; i >= 0; --i) {
                this._objects[i]._caucho_beforeCompletion(!this._rollbackOnly);
            }
            if (this._amberConn != null) {
                this._amberConn.beforeCommit();
            }
        }
        catch (Throwable e) {
            throw this.setRollbackOnly(e);
        }
    }

    public boolean isDead() {
        return !this._isAlive;
    }

    public void afterCompletion(int status) {
        int i;
        if (!this._isAlive) {
            IllegalStateException e = new IllegalStateException("after completion called for dead transaction.");
            log.log(Level.WARNING, e.toString(), e);
            return;
        }
        boolean wasCommitted = status == 3;
        int sessionTop = this._sessionTop;
        int objectTop = this._objectTop;
        TransactionContext old = this._old;
        Transaction transaction = this._transaction;
        Transaction oldTrans = this._oldTrans;
        this._sessionTop = 0;
        this._objectTop = 0;
        this._old = null;
        if (oldTrans == transaction) {
            oldTrans = null;
        }
        this._oldTrans = null;
        this._rollbackOnly = false;
        Throwable exn = null;
        try {
            AmberConnectionImpl amberConn = this._amberConn;
            this._amberConn = null;
            if (amberConn != null) {
                amberConn.afterCommit(wasCommitted);
                amberConn.freeConnection();
            }
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        for (i = sessionTop - 1; i >= 0; --i) {
            try {
                this._sessions[i].afterCompletion(wasCommitted);
                this._sessions[i] = null;
                continue;
            }
            catch (Throwable e) {
                exn = e;
                log.log(Level.WARNING, e.toString(), e);
            }
        }
        for (i = objectTop - 1; i >= 0; --i) {
            try {
                this._objects[i]._caucho_afterCompletion(wasCommitted);
                this._objects[i] = null;
                continue;
            }
            catch (Throwable e) {
                exn = e;
                log.log(Level.WARNING, e.toString(), e);
            }
        }
        this._transaction = null;
        this._isAlive = false;
        if (this._depth == 0 || this._isUserTransaction && this._depth == 1) {
            this._container.resume(old, oldTrans, transaction);
            this._container.freeTransaction(this);
        }
        if (exn != null) {
            throw EJBExceptionWrapper.createRuntime(exn);
        }
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.ejb.xa.TransactionContext");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

