/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.ql;

import com.caucho.bytecode.JClass;
import com.caucho.bytecode.JMethod;
import com.caucho.config.ConfigException;
import com.caucho.config.LineConfigException;
import com.caucho.ejb.cfg.EjbConfig;
import com.caucho.ejb.cfg.EjbEntityBean;
import com.caucho.ejb.cfg.FunctionSignature;
import com.caucho.ejb.ql.AndExpr;
import com.caucho.ejb.ql.ArgExpr;
import com.caucho.ejb.ql.BetweenExpr;
import com.caucho.ejb.ql.BinaryExpr;
import com.caucho.ejb.ql.CollectionExpr;
import com.caucho.ejb.ql.CollectionIdExpr;
import com.caucho.ejb.ql.EjbQuery;
import com.caucho.ejb.ql.EjbSelectQuery;
import com.caucho.ejb.ql.EmptyExpr;
import com.caucho.ejb.ql.Expr;
import com.caucho.ejb.ql.FunExpr;
import com.caucho.ejb.ql.IdExpr;
import com.caucho.ejb.ql.InExpr;
import com.caucho.ejb.ql.IsExpr;
import com.caucho.ejb.ql.LikeExpr;
import com.caucho.ejb.ql.LiteralExpr;
import com.caucho.ejb.ql.MemberExpr;
import com.caucho.ejb.ql.PathExpr;
import com.caucho.ejb.ql.Query;
import com.caucho.ejb.ql.ThisExpr;
import com.caucho.ejb.ql.UnaryExpr;
import com.caucho.util.CharBuffer;
import com.caucho.util.IntMap;
import com.caucho.util.L10N;
import com.caucho.util.Log;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QLParser
extends Query {
    static final Logger log = Log.open(QLParser._resin_compat_class_4());
    static final L10N L = new L10N(QLParser._resin_compat_class_4());
    static final int IDENTIFIER = 128;
    static final int INTEGER = 129;
    static final int LONG = 130;
    static final int DOUBLE = 131;
    static final int STRING = 132;
    static final int TRUE = 133;
    static final int FALSE = 134;
    static final int UNKNOWN = 135;
    static final int MEMBER = 136;
    static final int OF = 137;
    static final int EMPTY = 138;
    static final int NULL = 139;
    static final int FROM = 140;
    static final int IN = 141;
    static final int SELECT = 142;
    static final int DISTINCT = 143;
    static final int WHERE = 143;
    static final int AS = 144;
    static final int ORDER = 145;
    static final int BY = 146;
    static final int ASC = 147;
    static final int DESC = 148;
    static final int LIMIT = 149;
    static final int OFFSET = 150;
    static final int BETWEEN = 151;
    static final int LIKE = 152;
    static final int ESCAPE = 153;
    static final int IS = 154;
    static final int EQ = 155;
    static final int NE = 156;
    static final int LT = 157;
    static final int LE = 158;
    static final int GT = 159;
    static final int GE = 160;
    static final int AND = 161;
    static final int OR = 162;
    static final int NOT = 163;
    static final int EXTERNAL_DOT = 164;
    static final int ARG = 165;
    static final int THIS = 166;
    private static IntMap _reserved = new IntMap();
    private String _location;
    private EjbEntityBean _bean;
    private EjbEntityBean _target;
    private ArrayList<FunctionSignature> _functions;
    private String _methodName;
    private JClass _returnType;
    private String _returnEJB;
    private String _query;
    private ArrayList<FromItem> _fromList;
    private ArrayList<PathExpr> _fromIds = new ArrayList();
    private Expr _selectExpr;
    private boolean _isDistinct;
    private String _fromTable;
    private String _fromId;
    private IdExpr _thisExpr;
    private Expr _whereExpr;
    private ArrayList<Expr> _argList;
    private ArrayList<Expr> _orderExprList;
    private ArrayList<Boolean> _orderAscendingList;
    private Expr _limitMax;
    private Expr _limitOffset;
    private AndExpr _andExpr;
    private boolean _isWhere;
    private HashMap<String, PathExpr> _idMap;
    private HashMap<Expr, Expr> _pathMap;
    private int _parseIndex;
    private int _token;
    private String lexeme;
    private int _unique;
    private String _booleanTrue = "1";
    private String _booleanFalse = "0";
    private boolean _addArgToQuery = true;
    private boolean _queryLoadsBean = true;
    private int _maxArg;
    private static Class _resin_compat_class_0;
    private static Class _resin_compat_class_1;
    private static Class _resin_compat_class_2;
    private static Class _resin_compat_class_3;
    private static Class _resin_compat_class_4;

    private QLParser(EjbEntityBean bean) {
        this._bean = bean;
        this._functions = bean.getConfig().getFunctions();
    }

    public QLParser(EjbEntityBean bean, String methodName, JMethod method, JClass returnType) throws ConfigException {
        this(bean);
        this.setMethod(method);
        this._methodName = methodName;
        this._returnType = returnType;
        JClass[] exn = method.getExceptionTypes();
        for (int i = 0; i < exn.length; ++i) {
            if (!exn[i].isAssignableTo(QLParser._resin_compat_class_0())) continue;
            return;
        }
        throw new ConfigException(L.l("{0}: `{1}' must throw javax.ejb.FinderException.", (Object)method.getDeclaringClass().getName(), this.getFullMethodName(method)));
    }

    public static void parseOrderBy(EjbEntityBean bean, String orderBy, ArrayList<String> orderList, ArrayList<Boolean> orderAscendingList) throws ConfigException {
        QLParser query = new QLParser(bean);
        query.parseOrderBy(orderBy, orderList, orderAscendingList);
    }

    public void setLocation(String location) {
        this._location = location;
    }

    public EjbEntityBean getPersistentBean() {
        return this._bean;
    }

    public EjbEntityBean getBeanByName(String ejbName) {
        throw new UnsupportedOperationException();
    }

    public EjbEntityBean getBeanByType(JClass type) {
        throw new UnsupportedOperationException();
    }

    public String getName() {
        return this._methodName;
    }

    public ArrayList<FunctionSignature> getFunctions() {
        return this._functions;
    }

    public void setFunctions(ArrayList<FunctionSignature> functions) {
        this._functions = functions;
    }

    public void setBooleanTrue(String literal) {
        this._booleanTrue = literal;
    }

    public void setBooleanFalse(String literal) {
        this._booleanFalse = literal;
    }

    public JClass getReturnType() {
        return this._returnType;
    }

    public String getReturnEJB() {
        return this._selectExpr.getReturnEJB();
    }

    void setReturnType(JClass returnType) {
        this._returnType = returnType;
    }

    public String getQuery() {
        return this._query;
    }

    public Expr getSelectExpr() {
        return this._selectExpr;
    }

    public boolean isDistinct() {
        return this._isDistinct;
    }

    public boolean getQueryLoadsBean() {
        return this._queryLoadsBean;
    }

    public void setQueryLoadsBean(boolean loadBean) {
        this._queryLoadsBean = loadBean;
    }

    IdExpr getThisExpr() {
        return this._thisExpr;
    }

    Expr getWhereExpr() {
        return this._whereExpr;
    }

    ArrayList<Expr> getOrderExprList() {
        return this._orderExprList;
    }

    ArrayList<Boolean> getAscendingList() {
        return this._orderAscendingList;
    }

    Expr getLimitMax() {
        return this._limitMax;
    }

    Expr getLimitOffset() {
        return this._limitOffset;
    }

    ArrayList<FromItem> getFromList() {
        return this._fromList;
    }

    void addFromItem(String id, String table) {
        this._fromList.add(new FromItem(id, table));
    }

    public int getUnique() {
        return this._unique++;
    }

    public void addArg(Expr expr) {
        this._argList.add(expr);
    }

    ArrayList<Expr> getArgList() {
        return this._argList;
    }

    public void parseOrderBy(String orderBy, ArrayList<String> orderList, ArrayList<Boolean> orderAscendingList) throws ConfigException {
        this._query = orderBy;
        this._parseIndex = 0;
        this._unique = 0;
        this._token = -1;
        int token = -1;
        do {
            if ((token = this.scanToken()) != 128) {
                throw this.error(L.l("unexpected token `{0}' in order-by", this.tokenName(token)));
            }
            orderList.add(this.lexeme.toString());
            token = this.scanToken();
            if (token == 148) {
                token = this.scanToken();
                orderAscendingList.add(Boolean.FALSE);
                continue;
            }
            if (token == 147) {
                token = this.scanToken();
                orderAscendingList.add(Boolean.TRUE);
                continue;
            }
            orderAscendingList.add(Boolean.TRUE);
        } while (token == 44);
        if (token >= 0) {
            throw this.error(L.l("extra token {0} at end of order-by", this.tokenName(this.peekToken())));
        }
    }

    public EjbQuery parseQuery(String query) throws ConfigException {
        int token;
        this._query = query;
        this._fromList = new ArrayList();
        this._pathMap = new HashMap();
        this._idMap = new HashMap();
        this._argList = new ArrayList();
        this._parseIndex = 0;
        this._unique = 0;
        this._token = -1;
        this.setConfig(this._bean.getConfig());
        while ((token = this.peekToken()) >= 0 && token != 140) {
            token = this.scanToken();
        }
        if (token != 140) {
            throw this.error(L.l("expected FROM at {0}", this.tokenName(token)));
        }
        this.scanToken();
        this.parseFrom();
        token = this.peekToken();
        if (token >= 0 && token != 143 && token != 145) {
            throw this.error(L.l("expected WHERE or ORDER at {0}", this.tokenName(token)));
        }
        this._parseIndex = 0;
        this._token = -1;
        token = this.scanToken();
        if (token != 142) {
            throw this.error(L.l("expected SELECT at {0}", this.tokenName(token)));
        }
        if (this.peekToken() == 143) {
            this.scanToken();
            this._isDistinct = true;
        }
        this._selectExpr = this.parseExpr();
        if (this._selectExpr instanceof PathExpr) {
            ((PathExpr)this._selectExpr).setUsesField();
        }
        if ((token = this.peekToken()) != 140) {
            throw this.error(L.l("expected FROM at {0}", this.tokenName(token)));
        }
        while ((token = this.peekToken()) >= 0 && token != 143 && token != 145) {
            token = this.scanToken();
        }
        this._addArgToQuery = true;
        token = this.scanToken();
        if (token == 143) {
            this._isWhere = true;
            this._whereExpr = this.parseExpr();
            this._isWhere = false;
            token = this.scanToken();
        }
        if (this._whereExpr != null && !this._whereExpr.isBoolean()) {
            throw this.error(L.l("WHERE must be a boolean expression at {0}", this._whereExpr));
        }
        this._addArgToQuery = false;
        int oldMaxArg = this._maxArg;
        if (token == 145) {
            if (this.peekToken() == 146) {
                this.scanToken();
            }
            if (this._orderExprList == null) {
                this._orderExprList = new ArrayList();
            }
            if (this._orderAscendingList == null) {
                this._orderAscendingList = new ArrayList();
            }
            do {
                this._orderExprList.add(this.parseExpr());
                token = this.peekToken();
                if (token == 148) {
                    token = this.scanToken();
                    this._orderAscendingList.add(Boolean.FALSE);
                    continue;
                }
                if (token == 147) {
                    token = this.scanToken();
                    this._orderAscendingList.add(Boolean.TRUE);
                    continue;
                }
                this._orderAscendingList.add(Boolean.TRUE);
            } while ((token = this.scanToken()) == 44);
        }
        if (token == 150) {
            this._limitOffset = this.parseExpr();
            token = this.scanToken();
            if (!this._limitOffset.getJavaType().getName().equals("int")) {
                throw this.error(L.l("OFFSET `{0}' must be an integer expression", this._limitMax));
            }
        }
        if (token == 149) {
            this._limitMax = this.parseExpr();
            token = this.scanToken();
            if (!this._limitMax.getJavaType().getName().equals("int")) {
                throw this.error(L.l("LIMIT `{0}' must be an integer expression", this._limitMax));
            }
        }
        if (token >= 0) {
            throw this.error(L.l("extra token {0} at end of query", this.tokenName(this.peekToken())));
        }
        this._maxArg = oldMaxArg;
        EjbSelectQuery ejbQuery = new EjbSelectQuery(this._query);
        ejbQuery.setDistinct(this._isDistinct);
        ejbQuery.setFromList(this._fromIds);
        ejbQuery.setSelectExpr(this._selectExpr);
        ejbQuery.setWhereExpr(this._whereExpr);
        ejbQuery.setMaxArg(this._maxArg);
        ejbQuery.setThisExpr(this._thisExpr);
        ejbQuery.setOrderBy(this._orderExprList, this._orderAscendingList);
        ejbQuery.setOffset(this._limitOffset);
        ejbQuery.setLimit(this._limitMax);
        return ejbQuery;
    }

    private void parseFrom() throws ConfigException {
        boolean moreTables = true;
        while (moreTables) {
            int token = this.scanToken();
            if (token == 141) {
                if (this.scanToken() != 40) {
                    throw this.error(L.l("expected `(' at {0} while parsing IN(<collection-path>).", this.tokenName(token)));
                }
                this.parseFromCollection();
            } else if (token == 128) {
                String id = this.lexeme;
                if (this.peekToken() == 144) {
                    this.scanToken();
                }
                this.parseFromTable(id);
            } else {
                throw this.error(L.l("expected identifier at {0} while parsing FROM", this.tokenName(token)));
            }
            if (this.peekToken() == 44) {
                this.scanToken();
                moreTables = true;
                continue;
            }
            moreTables = false;
        }
    }

    private void parseFromTable(String table) throws ConfigException {
        int token = this.scanToken();
        if (token != 128) {
            throw this.error(L.l("expected identifier at {0} while parsing FROM {1} [AS] var", (Object)this.tokenName(token), table));
        }
        String name = this.lexeme;
        EjbConfig ejbConfig = this._bean.getConfig();
        EjbEntityBean entity = ejbConfig.findEntityBySchema(table);
        if (entity == null) {
            throw this.error(L.l("`{0}' is an unknown entity-bean schema in `FROM {0} AS {1}'", (Object)table, name));
        }
        IdExpr id = new IdExpr(this, name, entity);
        this.addIdentifier(name, id);
        this.addFromItem(name, entity.getSQLTable());
        this._fromIds.add(id);
    }

    private void parseFromCollection() throws ConfigException {
        int token;
        Expr expr = this.parseDotExpr();
        if (this.scanToken() != 41) {
            throw this.error(L.l("expected `)' at {0} while parsing IN(<collection-path>).", this.tokenName(this._token)));
        }
        if (!(expr instanceof CollectionExpr)) {
            throw this.error(L.l("expected <collection-path> expression at `{0}'", expr));
        }
        CollectionExpr collectionExpr = (CollectionExpr)expr;
        if (this.peekToken() == 144) {
            this.scanToken();
        }
        if ((token = this.scanToken()) != 128) {
            throw this.error(L.l("expected identifier expression at {0} while parsing `IN({1}) AS id'", (Object)this.tokenName(token), expr));
        }
        String name = this.lexeme;
        CollectionIdExpr idExpr = new CollectionIdExpr(this, name, collectionExpr);
        this.addIdentifier(name, idExpr);
        this._fromIds.add(idExpr);
    }

    private Expr parseExpr() throws ConfigException {
        return this.parseOrExpr();
    }

    private Expr parseOrExpr() throws ConfigException {
        Expr expr = this.parseAndExpr();
        int token = this.peekToken();
        while ((token = this.peekToken()) == 162) {
            this.scanToken();
            expr = new BinaryExpr(this, token, expr, this.parseAndExpr());
        }
        return expr;
    }

    private Expr parseAndExpr() throws ConfigException {
        AndExpr oldAnd = this._andExpr;
        AndExpr andExpr = new AndExpr(this);
        if (this._isWhere) {
            this._andExpr = andExpr;
        }
        Expr expr = this.parseNotExpr();
        andExpr.add(expr);
        int token = this.peekToken();
        while ((token = this.peekToken()) == 161) {
            this.scanToken();
            expr = this.parseNotExpr();
            andExpr.add(expr);
        }
        this._andExpr = oldAnd;
        return andExpr.getSingleExpr();
    }

    private Expr parseNotExpr() throws ConfigException {
        int token = this.peekToken();
        if (token == 163) {
            this.scanToken();
            Expr expr = this.parseCmpExpr();
            return new UnaryExpr(163, expr);
        }
        return this.parseCmpExpr();
    }

    private Expr parseCmpExpr() throws ConfigException {
        int token = this.peekToken();
        boolean isNot = false;
        Expr expr = this.parseArithmeticExpr();
        token = this.peekToken();
        if (token == 163) {
            this.scanToken();
            isNot = true;
            token = this.peekToken();
        }
        if (token >= 155 && token <= 160) {
            this.scanToken();
            return this.parseIs(new BinaryExpr(this, token, expr, this.parseAddExpr()));
        }
        if (token == 151) {
            this.scanToken();
            Expr a = this.parseArithmeticExpr();
            token = this.scanToken();
            if (token != 161) {
                throw this.error(L.l("Expected 'AND' at {0}", this.tokenName(token)));
            }
            Expr b = this.parseArithmeticExpr();
            return this.parseIs(new BetweenExpr(expr, a, b, isNot));
        }
        if (token == 152) {
            this.scanToken();
            Expr pattern = this.parseArithmeticExpr();
            String escape = null;
            if (this.peekToken() == 153) {
                this.scanToken();
                token = this.scanToken();
                if (token != 132) {
                    throw this.error(L.l("Expected string at {0}", this.tokenName(token)));
                }
                escape = this.lexeme.toString();
            }
            return this.parseIs(new LikeExpr(expr, pattern, escape, isNot));
        }
        if (token == 141) {
            this.scanToken();
            token = this.scanToken();
            if (token != 40) {
                throw this.error(L.l("Expected '(' after IN at {0}", this.tokenName(token)));
            }
            ArrayList<Expr> args = new ArrayList<Expr>();
            while ((token = this.peekToken()) > 0 && token != 41) {
                Expr arg = this.parseArithmeticExpr();
                args.add(arg);
                token = this.peekToken();
                if (token != 44) continue;
                this.scanToken();
                token = this.peekToken();
            }
            if (this.peekToken() != 41) {
                throw this.error(L.l("Expected ')' after IN at {0}", this.tokenName(token)));
            }
            this.scanToken();
            return new InExpr(this, expr, args, isNot);
        }
        if (token == 154) {
            this.scanToken();
            if (isNot) {
                throw this.error(L.l("'NOT IS' is an invalid expression."));
            }
            token = this.scanToken();
            if (token == 163) {
                isNot = true;
                token = this.scanToken();
            }
            if (token == 139) {
                return this.parseIs(new IsExpr(this, expr, 139, isNot));
            }
            if (token == 138) {
                if (!(expr instanceof CollectionExpr)) {
                    throw this.error(L.l("IS EMPTY requires collection path at `{0}'", expr));
                }
                return this.parseIs(new EmptyExpr(expr, isNot));
            }
            throw this.error(L.l("`{0}' unexpected after IS.", this.tokenName(token)));
        }
        if (token == 136) {
            this.scanToken();
            token = this.peekToken();
            if (token == 137) {
                token = this.scanToken();
            }
            Expr collection = this.parseDotExpr();
            return this.parseIs(new MemberExpr(isNot, expr, collection));
        }
        return expr;
    }

    private Expr parseIs(Expr base) throws ConfigException {
        int token;
        boolean isNot;
        if (this.peekToken() != 154) {
            return base;
        }
        this.scanToken();
        boolean bl = isNot = this.peekToken() == 163;
        if (isNot) {
            this.scanToken();
        }
        if ((token = this.scanToken()) == 135) {
            return new IsExpr(this, base, 139, isNot);
        }
        if (token == 133) {
            return isNot ? new UnaryExpr(163, base) : base;
        }
        if (token == 134) {
            return isNot ? base : new UnaryExpr(163, base);
        }
        throw this.error(L.l("expected TRUE or FALSE at {0}", this.tokenName(token)));
    }

    private Expr parseArithmeticExpr() throws ConfigException {
        return this.parseAddExpr();
    }

    private Expr parseAddExpr() throws ConfigException {
        Expr expr = this.parseMulExpr();
        int token = this.peekToken();
        while ((token = this.peekToken()) == 45 || token == 43) {
            this.scanToken();
            expr = new BinaryExpr(this, token, expr, this.parseMulExpr());
        }
        return expr;
    }

    private Expr parseMulExpr() throws ConfigException {
        Expr expr = this.parseUnaryExpr();
        int token = this.peekToken();
        while ((token = this.peekToken()) == 42 || token == 47) {
            this.scanToken();
            expr = new BinaryExpr(this, token, expr, this.parseUnaryExpr());
        }
        return expr;
    }

    private Expr parseUnaryExpr() throws ConfigException {
        int token = this.peekToken();
        if (token == 43 || token == 45) {
            this.scanToken();
            return new UnaryExpr(token, this.parseRefExpr());
        }
        return this.parseRefExpr();
    }

    private Expr parseRefExpr() throws ConfigException {
        Expr expr = this.parseDotExpr();
        int token = this.peekToken();
        if (token == 164) {
            this.scanToken();
            token = this.scanToken();
            if (token != 128) {
                throw this.error(L.l("expected field identifier at {0}", this.tokenName(token)));
            }
            expr = expr.newField(this.lexeme);
            expr.evalTypes();
            if (!expr.isExternal()) {
                throw this.error(L.l("`{0}' must refer to an external entity bean", expr));
            }
        }
        return expr;
    }

    private Expr parseDotExpr() throws ConfigException {
        int token;
        Expr expr = this.parseTerm();
        while ((token = this.peekToken()) == 46) {
            Expr field;
            this.scanToken();
            token = this.scanToken();
            if (token != 128) {
                throw this.error(L.l("expected field identifier at {0}", this.tokenName(token)));
            }
            expr.evalTypes();
            if (expr.isExternal()) {
                throw this.error(L.l("`{0}' must not refer to an external entity bean", expr));
            }
            expr = field = expr.newField(this.lexeme);
            Expr equiv = this._pathMap.get(field);
            if (equiv != null) {
                expr = equiv;
                continue;
            }
            this._pathMap.put(field, field);
        }
        return expr;
    }

    private Expr parseTerm() throws ConfigException {
        int token = this.scanToken();
        switch (token) {
            case 128: {
                String name = this.lexeme.toString();
                if (this.peekToken() != 40) {
                    return this.getIdentifier(name);
                }
                return this.parseFunction(name);
            }
            case 134: {
                return new LiteralExpr(this._booleanFalse, Boolean.TYPE);
            }
            case 133: {
                return new LiteralExpr(this._booleanTrue, Boolean.TYPE);
            }
            case 129: {
                return new LiteralExpr(this.lexeme, Integer.TYPE);
            }
            case 130: {
                return new LiteralExpr(this.lexeme, Long.TYPE);
            }
            case 131: {
                return new LiteralExpr(this.lexeme, Double.TYPE);
            }
            case 132: {
                return new LiteralExpr(this.lexeme, QLParser._resin_compat_class_1());
            }
            case 165: {
                ArgExpr arg = new ArgExpr(this, Integer.parseInt(this.lexeme));
                if (this._addArgToQuery) {
                    this.addArg(arg);
                }
                return arg;
            }
            case 166: {
                if (this._thisExpr == null) {
                    this._thisExpr = new IdExpr(this, "caucho_this", this._bean);
                    this.addFromItem("caucho_this", this._bean.getSQLTable());
                    this._fromIds.add(this._thisExpr);
                    this._argList.add(0, new ThisExpr(this, this._bean));
                }
                return this._thisExpr;
            }
            case 40: {
                Expr expr = this.parseExpr();
                token = this.scanToken();
                if (token != 41) {
                    throw this.error(L.l("expected `)' at {0}", this.tokenName(token)));
                }
                return expr;
            }
        }
        throw this.error(L.l("expected term at {0}", this.tokenName(token)));
    }

    private Expr parseFunction(String name) throws ConfigException {
        Expr expr;
        ArrayList<Expr> args = new ArrayList<Expr>();
        int token = this.scanToken();
        if (token != 40) {
            throw this.error(L.l("expected `(' at {0} while parsing function {1}()", (Object)this.tokenName(token), name));
        }
        while ((token = this.peekToken()) != 41 && token > 0) {
            expr = this.parseExpr();
            args.add(expr);
            token = this.peekToken();
            if (token != 44) continue;
            this.scanToken();
        }
        if (token != 41) {
            throw this.error(L.l("expected `)' at {0} while parsing function {1}", (Object)this.tokenName(token), name));
        }
        this.scanToken();
        if (name.equalsIgnoreCase("object")) {
            if (args.size() != 1) {
                throw this.error(L.l("OBJECT() requires a single argument"));
            }
            expr = (Expr)args.get(0);
            if (!expr.getJavaType().isAssignableTo(QLParser._resin_compat_class_2()) && !expr.getJavaType().isAssignableTo(QLParser._resin_compat_class_3())) {
                throw this.error(L.l("OBJECT({0}) requires an entity bean as its argument at `{1}'", (Object)expr, expr.getJavaType()));
            }
            return expr;
        }
        try {
            return new FunExpr(name, args, this._functions);
        }
        catch (ConfigException e) {
            throw this.error(e.getMessage());
        }
    }

    void addIdentifier(String name, PathExpr expr) throws ConfigException {
        Expr oldExpr = this._idMap.get(name);
        if (oldExpr != null) {
            throw this.error(L.l("`{0}' is defined twice", name));
        }
        this._idMap.put(name, expr);
    }

    PathExpr getIdentifier(String name) throws ConfigException {
        PathExpr expr = this._idMap.get(name);
        if (expr == null) {
            throw this.error(L.l("`{0}' is an unknown identifier", name));
        }
        return expr;
    }

    private int peekToken() throws ConfigException {
        if (this._token > 0) {
            return this._token;
        }
        this._token = this.scanToken();
        return this._token;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int scanToken() throws ConfigException {
        if (this._token > 0) {
            int value = this._token;
            this._token = -1;
            return value;
        }
        int sign = 1;
        int ch = this.read();
        while (Character.isWhitespace((char)ch)) {
            ch = this.read();
        }
        switch (ch) {
            case -1: 
            case 40: 
            case 41: 
            case 42: 
            case 44: 
            case 46: 
            case 47: {
                return ch;
            }
            case 43: {
                ch = this.read();
                if (ch >= 48 && ch <= 57) break;
                this.unread(ch);
                return 43;
            }
            case 45: {
                ch = this.read();
                if (ch >= 48 && ch <= 57) {
                    sign = -1;
                    break;
                }
                this.unread(ch);
                return 45;
            }
            case 61: {
                ch = this.read();
                if (ch == 62) {
                    return 164;
                }
                this.unread(ch);
                return 155;
            }
            case 60: {
                ch = this.read();
                if (ch == 61) {
                    return 158;
                }
                if (ch == 62) {
                    return 156;
                }
                this.unread(ch);
                return 157;
            }
            case 62: {
                ch = this.read();
                if (ch == 61) {
                    return 160;
                }
                this.unread(ch);
                return 159;
            }
            case 63: {
                CharBuffer cb = CharBuffer.allocate();
                int index = 0;
                ch = this.read();
                while (ch >= 48 && ch <= 57) {
                    cb.append((char)ch);
                    index = 10 * index + ch - 48;
                    ch = this.read();
                }
                this.unread(ch);
                this.lexeme = cb.close();
                if (index <= 0) {
                    throw this.error(L.l("`{0}' must refer to a positive argument", new CharBuffer().append("?").append(this.lexeme).toString()));
                }
                if (this._maxArg < index) {
                    this._maxArg = index;
                }
                return 165;
            }
            case 64: {
                ch = this.read();
                if (ch != 64) {
                    throw this.error(L.l("`@' expected at {0}", this.charName(ch)));
                }
                return this.scanToken();
            }
        }
        if (Character.isJavaIdentifierStart((char)ch)) {
            CharBuffer cb = CharBuffer.allocate();
            while (ch > 0 && Character.isJavaIdentifierPart((char)ch)) {
                cb.append((char)ch);
                ch = this.read();
            }
            this.unread(ch);
            this.lexeme = cb.close();
            String lower = this.lexeme.toLowerCase();
            int token = _reserved.get(lower);
            if (token > 0) {
                return token;
            }
            return 128;
        }
        if (ch >= 48 && ch <= 57) {
            CharBuffer cb = CharBuffer.allocate();
            int type = 129;
            if (sign < 0) {
                cb.append('-');
            }
            while (ch >= 48 && ch <= 57) {
                cb.append((char)ch);
                ch = this.read();
            }
            if (ch == 46) {
                type = 131;
                cb.append('.');
                ch = this.read();
                while (ch >= 48 && ch <= 57) {
                    cb.append((char)ch);
                    ch = this.read();
                }
            }
            if (ch == 101 || ch == 69) {
                type = 131;
                cb.append('e');
                ch = this.read();
                if (ch == 43 || ch == 45) {
                    cb.append((char)ch);
                    ch = this.read();
                }
                if (ch < 48 || ch > 57) {
                    throw this.error(L.l("exponent needs digits at {0}", this.charName(ch)));
                }
                while (ch >= 48 && ch <= 57) {
                    cb.append((char)ch);
                    ch = this.read();
                }
            }
            if (ch == 70 || ch == 68) {
                type = 131;
            } else if (ch == 76) {
                type = 130;
            } else {
                this.unread(ch);
            }
            this.lexeme = cb.close();
            return type;
        }
        if (ch != 39) {
            throw this.error(L.l("unexpected char at {0}", new CharBuffer().append("").append((char)ch).toString()));
        }
        CharBuffer cb = CharBuffer.allocate();
        cb.append("'");
        ch = this.read();
        while (ch >= 0) {
            block42: {
                if (ch == 39) {
                    ch = this.read();
                    if (ch == 39) {
                        cb.append("''");
                        break block42;
                    } else {
                        this.unread(ch);
                        break;
                    }
                }
                cb.append((char)ch);
            }
            ch = this.read();
        }
        cb.append("'");
        this.lexeme = cb.close();
        return 132;
    }

    private int read() {
        if (this._parseIndex < this._query.length()) {
            return this._query.charAt(this._parseIndex++);
        }
        return -1;
    }

    private void unread(int ch) {
        if (ch >= 0) {
            --this._parseIndex;
        }
    }

    private String getFullMethodName(JMethod method) {
        return method.getFullName();
    }

    private String getFullMethodName(String methodName, JClass[] params) {
        String name = new CharBuffer().append(methodName).append("(").toString();
        for (int i = 0; i < params.length; ++i) {
            if (i != 0) {
                name = new CharBuffer().append(name).append(", ").toString();
            }
            name = new CharBuffer().append(name).append(params[i].getPrintName()).toString();
        }
        return new CharBuffer().append(name).append(")").toString();
    }

    private String getClassName(Class cl) {
        if (cl.isArray()) {
            return new CharBuffer().append(this.getClassName(cl.getComponentType())).append("[]").toString();
        }
        if (cl.getName().startsWith("java")) {
            int p = cl.getName().lastIndexOf(46);
            return cl.getName().substring(p + 1);
        }
        return cl.getName();
    }

    @Override
    public ConfigException error(String msg) {
        msg = new CharBuffer().append(msg).append("\nin \"").append(this._query).append("\"").toString();
        if (this._location != null) {
            return new LineConfigException(new CharBuffer().append(this._location).append(msg).toString());
        }
        return new ConfigException(msg);
    }

    private String charName(int ch) {
        if (ch < 0) {
            return L.l("end of query");
        }
        return String.valueOf((char)ch);
    }

    private String tokenName(int token) {
        switch (token) {
            case 144: {
                return "AS";
            }
            case 140: {
                return "FROM";
            }
            case 141: {
                return "IN";
            }
            case 142: {
                return "SELECT";
            }
            case 143: {
                return "WHERE";
            }
            case 162: {
                return "OR";
            }
            case 161: {
                return "AND";
            }
            case 163: {
                return "NOT";
            }
            case 151: {
                return "BETWEEN";
            }
            case 166: {
                return "THIS";
            }
            case 133: {
                return "FALSE";
            }
            case 138: {
                return "EMPTY";
            }
            case 136: {
                return "MEMBER";
            }
            case 137: {
                return "OF";
            }
            case 139: {
                return "NULL";
            }
            case 145: {
                return "ORDER";
            }
            case 146: {
                return "BY";
            }
            case 147: {
                return "ASC";
            }
            case 148: {
                return "DESC";
            }
            case 149: {
                return "LIMIT";
            }
            case 164: {
                return "=>";
            }
            case -1: {
                return L.l("end of query");
            }
        }
        if (token < 128) {
            return new CharBuffer().append("'").append(String.valueOf((char)token)).append("'").toString();
        }
        return new CharBuffer().append("'").append(this.lexeme).append("'").toString();
    }

    public static ArrayList<FunctionSignature> getStandardFunctions() {
        return FunExpr.getStandardFunctions();
    }

    public String toString() {
        return new CharBuffer().append("QLParser[").append(this.getMethod()).append("]").toString();
    }

    public boolean equals(Object b) {
        if (!(b instanceof QLParser)) {
            return false;
        }
        QLParser bSel = (QLParser)b;
        if (this._bean != bSel._bean) {
            return false;
        }
        return QLParser.methodEquals(this.getMethod(), bSel.getMethod());
    }

    static boolean methodEquals(JMethod a, JMethod b) {
        JClass[] bParam;
        if (!a.getName().equals(b.getName())) {
            return false;
        }
        JClass[] aParam = a.getParameterTypes();
        if (aParam.length != (bParam = b.getParameterTypes()).length) {
            return false;
        }
        for (int i = 0; i < aParam.length; ++i) {
            if (aParam[i].equals(bParam[i])) continue;
            return false;
        }
        return true;
    }

    static {
        _reserved.put("as", 144);
        _reserved.put("from", 140);
        _reserved.put("in", 141);
        _reserved.put("select", 142);
        _reserved.put("distinct", 143);
        _reserved.put("where", 143);
        _reserved.put("order", 145);
        _reserved.put("by", 146);
        _reserved.put("asc", 147);
        _reserved.put("desc", 148);
        _reserved.put("limit", 149);
        _reserved.put("offset", 150);
        _reserved.put("or", 162);
        _reserved.put("and", 161);
        _reserved.put("not", 163);
        _reserved.put("between", 151);
        _reserved.put("like", 152);
        _reserved.put("escape", 153);
        _reserved.put("is", 154);
        _reserved.put("this", 166);
        _reserved.put("true", 133);
        _reserved.put("false", 134);
        _reserved.put("unknown", 135);
        _reserved.put("empty", 138);
        _reserved.put("member", 136);
        _reserved.put("of", 137);
        _reserved.put("null", 139);
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("javax.ejb.FinderException");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_1() {
        try {
            Class<?> clazz = _resin_compat_class_1;
            if (clazz == null) {
                clazz = _resin_compat_class_1 = Class.forName("java.lang.String");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_2() {
        try {
            Class<?> clazz = _resin_compat_class_2;
            if (clazz == null) {
                clazz = _resin_compat_class_2 = Class.forName("javax.ejb.EntityBean");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_3() {
        try {
            Class<?> clazz = _resin_compat_class_3;
            if (clazz == null) {
                clazz = _resin_compat_class_3 = Class.forName("javax.ejb.EJBLocalObject");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_4() {
        try {
            Class<?> clazz = _resin_compat_class_4;
            if (clazz == null) {
                clazz = _resin_compat_class_4 = Class.forName("com.caucho.ejb.ql.QLParser");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    static class LinkItem {
        String columnA;
        String tableA;
        String columnB;
        String tableB;

        LinkItem(String tableA, String columnA, String tableB, String columnB) {
            this.columnA = columnA;
            this.tableA = tableA;
            this.columnB = columnB;
            this.tableB = tableB;
        }

        public boolean equals(Object o) {
            if (!(o instanceof LinkItem)) {
                return false;
            }
            LinkItem link = (LinkItem)o;
            if (this.tableA.equals(link.tableA) && this.columnA.equals(link.columnA) && this.tableB.equals(link.tableB) && this.columnB.equals(link.columnB)) {
                return true;
            }
            return this.tableA.equals(link.tableB) && this.columnA.equals(link.columnB) && this.tableB.equals(link.tableA) && this.columnB.equals(link.columnA);
        }
    }

    static class FromItem {
        String _id;
        String _table;

        FromItem(String id, String table) {
            this._id = id;
            this._table = table;
        }
    }
}

