/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.ql;

import com.caucho.ejb.ql.ArgExpr;
import com.caucho.ejb.ql.EjbQuery;
import com.caucho.ejb.ql.Expr;
import com.caucho.ejb.ql.IdExpr;
import com.caucho.ejb.ql.LiteralExpr;
import com.caucho.ejb.ql.PathExpr;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.util.Log;
import java.util.ArrayList;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbSelectQuery
extends EjbQuery {
    private static final Logger log = Log.open(EjbSelectQuery._resin_compat_class_0());
    private static final L10N L = new L10N(EjbSelectQuery._resin_compat_class_0());
    private ArrayList<PathExpr> _fromList;
    protected Expr _selectExpr;
    protected Expr _whereExpr;
    protected IdExpr _thisExpr;
    private ArrayList<Expr> _orderByExpr;
    private ArrayList<Boolean> _orderByAscending;
    private Expr _offsetExpr;
    private Expr _limitExpr;
    private boolean _queryLoadsBean = true;
    private boolean _isDistinct = false;
    private static Class _resin_compat_class_0;

    EjbSelectQuery(String ejbql) {
        super(ejbql);
    }

    public void setFromList(ArrayList<PathExpr> fromList) {
        this._fromList = fromList;
    }

    public void setSelectExpr(Expr selectExpr) {
        this._selectExpr = selectExpr;
    }

    public void setWhereExpr(Expr whereExpr) {
        this._whereExpr = whereExpr;
    }

    public void setThisExpr(IdExpr thisExpr) {
        this._thisExpr = thisExpr;
    }

    public IdExpr getThisExpr() {
        return this._thisExpr;
    }

    public void setOrderBy(ArrayList<Expr> exprList, ArrayList<Boolean> ascendingList) {
        this._orderByExpr = exprList;
        this._orderByAscending = ascendingList;
    }

    public void setOffset(Expr offset) {
        this._offsetExpr = offset;
    }

    @Override
    public int getOffsetValue() {
        if (this._offsetExpr instanceof LiteralExpr) {
            return Integer.parseInt(((LiteralExpr)this._offsetExpr).getValue());
        }
        return -1;
    }

    @Override
    public int getOffsetArg() {
        if (this._offsetExpr instanceof ArgExpr) {
            return ((ArgExpr)this._offsetExpr).getIndex();
        }
        return -1;
    }

    public void setLimit(Expr limit) {
        this._limitExpr = limit;
    }

    @Override
    public int getLimitValue() {
        if (this._limitExpr instanceof LiteralExpr) {
            return Integer.parseInt(((LiteralExpr)this._limitExpr).getValue());
        }
        return -1;
    }

    @Override
    public int getLimitArg() {
        if (this._limitExpr instanceof ArgExpr) {
            return ((ArgExpr)this._limitExpr).getIndex();
        }
        return -1;
    }

    public void setDistinct(boolean isDistinct) {
        this._isDistinct = isDistinct;
    }

    public void setQueryLoadsBean(boolean queryLoadsBean) {
        this._queryLoadsBean = queryLoadsBean;
    }

    public boolean getQueryLoadsBean() {
        return this._queryLoadsBean;
    }

    @Override
    public String toAmberQuery(String[] args) {
        int i;
        CharBuffer cb = new CharBuffer();
        cb.append("SELECT ");
        if (this._isDistinct) {
            cb.append("DISTINCT ");
        }
        this._selectExpr.generateSelect(cb);
        cb.append(" FROM ");
        for (i = 0; i < this._fromList.size(); ++i) {
            PathExpr item = this._fromList.get(i);
            if (i != 0) {
                cb.append(", ");
            }
            item.generateAmber(cb);
        }
        if (this._whereExpr != null) {
            cb.append(" WHERE ");
            this._whereExpr.generateWhere(cb);
        }
        if (this._thisExpr != null) {
            if (this._whereExpr == null) {
                cb.append(" WHERE ");
            } else {
                cb.append(" AND ");
            }
            for (i = 0; i < this._thisExpr.getComponentCount(); ++i) {
                if (i != 0) {
                    cb.append(" AND ");
                }
                this._thisExpr.generateComponent(cb, i);
                cb.append(new CharBuffer().append("=?").append(this.getMaxArg() + i + 1).toString());
            }
        }
        if (this._orderByExpr != null && this._orderByExpr.size() > 0) {
            cb.append(" ORDER BY ");
            for (i = 0; i < this._orderByExpr.size(); ++i) {
                Expr orderBy;
                if (i != 0) {
                    cb.append(", ");
                }
                if ((orderBy = this._orderByExpr.get(i)) instanceof ArgExpr) {
                    cb.append(new CharBuffer().append("\" + ").append(args[((ArgExpr)orderBy).getIndex() - 1]).append(" + \"").toString());
                } else {
                    orderBy.generateSelect(cb);
                }
                if (!Boolean.FALSE.equals(this._orderByAscending.get(i))) continue;
                cb.append(" DESC");
            }
        }
        return cb.toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.ejb.ql.EjbSelectQuery");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

