/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.ql;

import com.caucho.config.ConfigException;
import com.caucho.ejb.ql.Expr;
import com.caucho.ejb.ql.Query;
import com.caucho.util.CharBuffer;
import java.util.ArrayList;

class AndExpr
extends Expr {
    private ArrayList<Expr> _components = new ArrayList();

    AndExpr(Query query) throws ConfigException {
        this.setJavaType(Boolean.TYPE);
    }

    void evalTypes() throws ConfigException {
        this.setJavaType(Boolean.TYPE);
    }

    void add(Expr expr) {
        this._components.add(expr);
    }

    Expr getSingleExpr() {
        if (this._components.size() == 1) {
            return this._components.get(0);
        }
        return this;
    }

    void generateWhere(CharBuffer cb) {
        if (this._components.size() == 1) {
            Expr comp = this._components.get(0);
            comp.generateWhere(cb);
            return;
        }
        for (int i = 0; i < this._components.size(); ++i) {
            Expr comp = this._components.get(i);
            if (i != 0) {
                cb.append(" AND ");
            }
            comp.generateWhereSubExpr(cb);
        }
    }

    void generateWhereSubExpr(CharBuffer cb) {
        cb.append("(");
        this.generateWhere(cb);
        cb.append(")");
    }

    void printSelect(CharBuffer cb) throws ConfigException {
        cb.append("(");
        this.generateWhere(cb);
        cb.append(")");
    }

    public String toString() {
        CharBuffer value = CharBuffer.allocate();
        value.append("(");
        for (int i = 0; i < this._components.size(); ++i) {
            Expr comp = this._components.get(i);
            if (i != 0) {
                value.append(" AND ");
            }
            value.append(comp.toString());
        }
        value.append(")");
        return value.close();
    }
}

