/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.protocol;

import com.caucho.config.ConfigException;
import com.caucho.ejb.AbstractServer;
import com.caucho.ejb.protocol.EjbIiopRemoteService;
import com.caucho.ejb.protocol.HandleEncoder;
import com.caucho.ejb.protocol.ProtocolContainer;
import com.caucho.ejb.protocol.Skeleton;
import com.caucho.iiop.IiopContext;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;

public class IiopProtocolContainer
extends ProtocolContainer {
    private static final L10N L = new L10N(IiopProtocolContainer._resin_compat_class_0());
    private IiopContext _context;
    private static Class _resin_compat_class_0;

    private IiopProtocolContainer(IiopContext context) {
        this._context = context;
    }

    public static IiopProtocolContainer createProtocolContainer() {
        IiopContext context = IiopContext.getLocalContext();
        if (context != null) {
            return new IiopProtocolContainer(context);
        }
        return null;
    }

    public String getName() {
        return "iiop";
    }

    public void addServer(AbstractServer server) {
        if (server.getHomeObject() == null) {
            return;
        }
        EjbIiopRemoteService service = new EjbIiopRemoteService(server);
        this._context.setService(server.getEJBName(), service);
        if (server.getJndiName() != null) {
            this._context.setService(server.getJndiName(), service);
        }
    }

    public void removeServer(AbstractServer server) {
        if (server.getHomeObject() == null) {
            return;
        }
        this._context.removeService(server.getEJBName());
        if (server.getJndiName() != null) {
            this._context.removeService(server.getJndiName());
        }
    }

    protected HandleEncoder createHandleEncoder(AbstractServer server, Class primaryKeyClass) throws ConfigException {
        if (this._urlPrefix != null) {
            return new HandleEncoder(server, new CharBuffer().append(this._urlPrefix).append(server.getEJBName()).toString());
        }
        return new HandleEncoder(server, server.getEJBName());
    }

    public Skeleton getSkeleton(String uri, String queryString) throws Exception {
        throw new UnsupportedOperationException();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.ejb.protocol.IiopProtocolContainer");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

