/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.protocol;

import com.caucho.ejb.AbstractServer;
import com.caucho.ejb.protocol.AbstractHandle;
import com.caucho.ejb.protocol.AbstractHomeHandle;
import com.caucho.ejb.protocol.HandleImpl;
import com.caucho.ejb.protocol.HomeHandleImpl;
import com.caucho.log.Log;
import com.caucho.util.Base64;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.util.RandomUtil;
import java.util.logging.Logger;

public class HandleEncoder {
    private static final L10N L = new L10N(HandleEncoder._resin_compat_class_0());
    private static final Logger log = Log.open(HandleEncoder._resin_compat_class_0());
    private AbstractServer _server;
    private String _serverId;
    private static Class _resin_compat_class_0;

    public HandleEncoder(String serverId) {
        this._serverId = serverId;
    }

    public HandleEncoder(AbstractServer server, String serverId) {
        this(serverId);
        this.setServer(server);
    }

    protected void setServer(AbstractServer server) {
        this._server = server;
    }

    protected AbstractServer getServer() {
        return this._server;
    }

    public String getServerId() {
        return this._serverId;
    }

    public void setServerId(String id) {
        this._serverId = id;
    }

    public AbstractHomeHandle createHomeHandle() {
        if (this._server != null) {
            try {
                return new HomeHandleImpl(this._server.getEJBHome(), this._serverId);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return new HomeHandleImpl(this._serverId);
    }

    public String getURL() {
        return this._serverId;
    }

    public String getURL(String primaryKey) {
        return new CharBuffer().append(this._serverId).append("?id=").append(primaryKey).toString();
    }

    public AbstractHandle createHandle(String objectId) {
        return new HandleImpl(this._serverId, objectId);
    }

    public String createRandomStringKey() {
        long id = RandomUtil.getRandomLong();
        CharBuffer cb = new CharBuffer();
        Base64.encode(cb, id);
        for (int i = 1; i < cb.length(); ++i) {
            if (cb.charAt(i) != '/') continue;
            cb.setCharAt(i, '-');
        }
        return cb.toString();
    }

    protected String encodePrimaryKey(Object primaryKey) {
        if (this._server != null) {
            return this._server.encodeId(primaryKey);
        }
        return String.valueOf(primaryKey);
    }

    public Object objectIdToKey(Object id) {
        return id;
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.ejb.protocol.HandleEncoder");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

