/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.message;

import com.caucho.config.ConfigException;
import com.caucho.ejb.AbstractContext;
import com.caucho.ejb.AbstractServer;
import com.caucho.ejb.EjbServerManager;
import com.caucho.ejb.message.MessageDrivenContextImpl;
import com.caucho.util.L10N;
import com.caucho.util.Log;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.MessageDrivenBean;
import javax.ejb.MessageDrivenContext;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;
import javax.jms.Topic;

public class MessageServer
extends AbstractServer {
    private static final L10N L = new L10N(MessageServer._resin_compat_class_0());
    protected static final Logger log = Log.open(MessageServer._resin_compat_class_0());
    private Connection _connection;
    private Destination _destination;
    private String _subscriptionName;
    private String _selector;
    private int _acknowledgeMode = 1;
    private int _consumerMax = 5;
    private MessageDrivenContext _context;
    private ArrayList<Consumer> _consumers = new ArrayList();
    private static Class _resin_compat_class_0;

    public MessageServer(EjbServerManager manager) {
        super(manager);
        this._context = new MessageDrivenContextImpl(this);
    }

    public void setDestination(Destination destination) {
        this._destination = destination;
    }

    public void setConsumerMax(int consumer) {
        this._consumerMax = consumer;
    }

    public void init() throws Exception {
    }

    public void start() throws Exception {
        Connection connection;
        ConnectionFactory factory = null;
        if (factory == null) {
            factory = this._ejbManager.getConnectionFactory();
        }
        if (this._destination == null) {
            throw new ConfigException(L.l("No destination is configured."));
        }
        if (this._consumerMax <= 0) {
            throw new ConfigException(L.l("No listeners are configured."));
        }
        if (factory == null) {
            throw new ConfigException(L.l("Message beans need a jms-connection-factory.  The ConnectionFactory object must be configured."));
        }
        this._connection = connection = factory.createConnection();
        if (this._destination instanceof Topic) {
            this._consumerMax = 1;
        }
        for (int i = 0; i < this._consumerMax; ++i) {
            Consumer consumer = new Consumer();
            this._consumers.add(consumer);
            consumer.start();
        }
        this._connection.start();
    }

    void generate() throws Exception {
    }

    public AbstractContext getContext(Object obj, boolean foo) {
        throw new UnsupportedOperationException();
    }

    public Connection getJMSConnection() {
        return this._connection;
    }

    public Destination getDestination() {
        return this._destination;
    }

    public void destroy() {
        try {
            ArrayList<Consumer> consumers = new ArrayList<Consumer>(this._consumers);
            this._consumers = null;
            Iterator<Consumer> i$ = consumers.iterator();
            while (i$.hasNext()) {
                Consumer consumer = i$.next();
                consumer.destroy();
            }
            if (this._connection != null) {
                this._connection.close();
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.ejb.message.MessageServer");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    class Consumer {
        private Session _session;
        private MessageConsumer _consumer;
        private MessageListener _listener;

        Consumer() throws Exception {
        }

        void start() throws Exception {
            Class cl = MessageServer.this._contextImplClass;
            this._listener = (MessageListener)cl.newInstance();
            if (this._listener instanceof MessageDrivenBean) {
                MessageDrivenBean bean = (MessageDrivenBean)this._listener;
                bean.setMessageDrivenContext(MessageServer.this._context);
            }
            Method create = null;
            try {
                create = cl.getMethod("ejbCreate", new Class[0]);
                create.invoke((Object)this._listener, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
            boolean transacted = false;
            this._session = MessageServer.this._connection.createSession(transacted, MessageServer.this._acknowledgeMode);
            if (MessageServer.this._subscriptionName != null) {
                Topic topic = (Topic)MessageServer.this._destination;
                this._consumer = this._session.createDurableSubscriber(topic, MessageServer.this._subscriptionName, MessageServer.this._selector, true);
            } else {
                this._consumer = this._session.createConsumer(MessageServer.this._destination, MessageServer.this._selector);
            }
            this._consumer.setMessageListener(this._listener);
        }

        public Session getSession() throws JMSException {
            return this._session;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void destroy() throws JMSException {
            Session session = this._session;
            this._session = null;
            try {
                if (session != null) {
                    session.close();
                }
            }
            finally {
                if (this._listener instanceof MessageDrivenBean) {
                    MessageDrivenBean bean = (MessageDrivenBean)this._listener;
                    this._listener = null;
                    bean.ejbRemove();
                }
            }
        }
    }
}

