/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.hessian;

import com.caucho.ejb.hessian.HessianReader;
import com.caucho.ejb.hessian.HessianWriter;
import com.caucho.ejb.protocol.Skeleton;
import com.caucho.ejb.xa.EjbTransactionManager;
import com.caucho.hessian.io.HessianInput;
import com.caucho.hessian.io.HessianOutput;
import com.caucho.hessian.io.HessianProtocolException;
import com.caucho.util.CharBuffer;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class XAResourceSkeleton
extends Skeleton {
    protected static final Logger log = Logger.getLogger(XAResourceSkeleton._resin_compat_class_0().getName());
    private EjbTransactionManager _tm;
    private static Class _resin_compat_class_0;

    XAResourceSkeleton(EjbTransactionManager tm) {
        this._tm = tm;
    }

    public void _service(InputStream is, OutputStream os) throws Exception {
        HessianReader in = new HessianReader(is);
        HessianWriter out = new HessianWriter(os);
        in.startCall();
        String method = in.getMethod();
        try {
            if (method.equals("commitOnePhase") || method.equals("commitOnePhase_string") || method.equals("commitOnePhase_1")) {
                this.executeCommitOnePhase(in, out);
            } else if (method.equals("commit") || method.equals("commit_string") || method.equals("commit_1")) {
                this.executeCommit(in, out);
            } else if (method.equals("rollback") || method.equals("rollback_string") || method.equals("rollback_1")) {
                this.executeRollback(in, out);
            } else if (method.equals("prepare") || method.equals("prepare_string") || method.equals("prepare_1")) {
                this.executePrepare(in, out);
            } else {
                this.executeUnknown(method, in, out);
            }
        }
        catch (HessianProtocolException e) {
            throw e;
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
            out.startReply();
            out.writeFault("ServiceException", e.getMessage(), e);
            out.completeReply();
        }
    }

    private void executeCommitOnePhase(HessianInput in, HessianOutput out) throws Throwable {
        String xid = in.readString();
        in.completeCall();
        this._tm.commitTransaction(xid);
        out.startReply();
        out.writeNull();
        out.completeReply();
    }

    private void executeCommit(HessianInput in, HessianOutput out) throws Throwable {
        String xid = in.readString();
        in.completeCall();
        this._tm.commitTransaction(xid);
        out.startReply();
        out.writeNull();
        out.completeReply();
    }

    private void executePrepare(HessianInput in, HessianOutput out) throws Throwable {
        String xid = in.readString();
        in.completeCall();
        out.startReply();
        out.writeInt(0);
        out.completeReply();
    }

    private void executeRollback(HessianInput in, HessianOutput out) throws Throwable {
        String xid = in.readString();
        in.completeCall();
        this._tm.rollbackTransaction(xid);
        out.startReply();
        out.writeNull();
        out.completeReply();
    }

    protected void executeUnknown(String method, HessianInput in, HessianOutput out) throws Exception {
        if (method.equals("_hessian_getAttribute")) {
            String key = in.readString();
            in.completeCall();
            out.startReply();
            out.writeNull();
            out.completeReply();
        } else {
            out.startReply();
            out.writeFault("NoMethod", new CharBuffer().append("no such method: ").append(method).toString(), null);
            out.completeReply();
        }
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.ejb.hessian.XAResourceSkeleton");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

