/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.hessian;

import com.caucho.ejb.AbstractServer;
import com.caucho.ejb.hessian.HessianProtocol;
import com.caucho.ejb.hessian.HessianReader;
import com.caucho.ejb.hessian.HessianWriter;
import com.caucho.ejb.protocol.EjbProtocolManager;
import com.caucho.ejb.protocol.Skeleton;
import com.caucho.hessian.io.HessianInput;
import com.caucho.hessian.io.HessianOutput;
import com.caucho.hessian.io.HessianProtocolException;
import com.caucho.log.Log;
import com.caucho.util.CharBuffer;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJBHome;

public class NameContextSkeleton
extends Skeleton {
    protected static final Logger log = Log.open(NameContextSkeleton._resin_compat_class_1());
    private HessianProtocol _protocol;
    private String _prefix;
    private static Class _resin_compat_class_0;
    private static Class _resin_compat_class_1;

    NameContextSkeleton(HessianProtocol protocol, String prefix) {
        this._protocol = protocol;
        this._prefix = prefix;
    }

    public void _service(InputStream is, OutputStream os) throws Exception {
        HessianReader in = new HessianReader(is);
        HessianWriter out = new HessianWriter(os);
        in.startCall();
        String method = in.getMethod();
        try {
            if (method.equals("lookup") || method.equals("lookup_string") || method.equals("lookup_1")) {
                this.executeLookup(in, out);
            } else if (method.equals("list")) {
                this.executeList(in, out);
            } else {
                this.executeUnknown(method, in, out);
            }
        }
        catch (HessianProtocolException e) {
            throw e;
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
            out.startReply();
            out.writeFault("ServiceException", e.getMessage(), e);
            out.completeReply();
        }
    }

    private void executeLookup(HessianInput in, HessianOutput out) throws Throwable {
        String name = in.readString();
        in.completeCall();
        EjbProtocolManager container = this._protocol.getProtocolManager();
        AbstractServer server = container.getServerByEJBName(name);
        if (server != null) {
            EJBHome home = server.getEJBHome();
            out.startReply();
            if (home != null) {
                out.writeObject(home);
            } else {
                out.writeObject(server.getRemoteObject());
            }
            out.completeReply();
        } else if (container.getRemoteChildren(name) != null) {
            out.startReply();
            String serverId = new CharBuffer().append(this._prefix).append(name).toString();
            if (serverId.startsWith("/")) {
                serverId = serverId.substring(1);
            }
            out.writeRemote(NameContextSkeleton._resin_compat_class_0().getName(), new CharBuffer().append(this._protocol.getURLPrefix()).append(serverId).toString());
            out.completeReply();
        } else {
            out.startReply();
            out.writeNull();
            out.completeReply();
        }
    }

    private void executeList(HessianInput in, HessianOutput out) throws Throwable {
        in.completeCall();
        EjbProtocolManager container = this._protocol.getProtocolManager();
        AbstractServer server = container.getServerByEJBName(this._prefix);
        if (server != null) {
            EJBHome home = server.getEJBHome();
            out.startReply();
            out.writeNull();
            out.completeReply();
        } else {
            ArrayList<String> children = container.getRemoteChildren(this._prefix);
            if (children != null) {
                out.startReply();
                out.writeObject(children.toArray(new String[children.size()]));
                out.completeReply();
            } else {
                out.startReply();
                out.writeNull();
                out.completeReply();
            }
        }
    }

    protected void executeUnknown(String method, HessianInput in, HessianOutput out) throws Exception {
        if (method.equals("_hessian_getAttribute")) {
            String key = in.readString();
            in.completeCall();
            out.startReply();
            if ("java.api.class".equals(key)) {
                out.writeString(NameContextSkeleton._resin_compat_class_0().getName());
            } else if ("java.home.class".equals(key)) {
                out.writeString(NameContextSkeleton._resin_compat_class_0().getName());
            } else if ("java.object.class".equals(key)) {
                out.writeString(NameContextSkeleton._resin_compat_class_0().getName());
            } else if ("home-class".equals(key)) {
                out.writeString(NameContextSkeleton._resin_compat_class_0().getName());
            } else if ("remote-class".equals(key)) {
                out.writeString(NameContextSkeleton._resin_compat_class_0().getName());
            } else {
                out.writeNull();
            }
            out.completeReply();
        } else {
            out.startReply();
            out.writeFault("NoMethod", new CharBuffer().append("no such method: ").append(method).toString(), null);
            out.completeReply();
        }
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.services.name.NameServerRemote");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_1() {
        try {
            Class<?> clazz = _resin_compat_class_1;
            if (clazz == null) {
                clazz = _resin_compat_class_1 = Class.forName("com.caucho.ejb.hessian.NameContextSkeleton");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

