/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.hessian;

import com.caucho.config.ConfigException;
import com.caucho.ejb.AbstractServer;
import com.caucho.ejb.hessian.HessianHandleEncoder;
import com.caucho.ejb.hessian.HessianSkeleton;
import com.caucho.ejb.hessian.HessianSkeletonGenerator;
import com.caucho.ejb.hessian.HessianStubFactory;
import com.caucho.ejb.hessian.MessageSkeleton;
import com.caucho.ejb.hessian.NameContextSkeleton;
import com.caucho.ejb.hessian.XAResourceSkeleton;
import com.caucho.ejb.message.MessageServer;
import com.caucho.ejb.protocol.HandleEncoder;
import com.caucho.ejb.protocol.ProtocolContainer;
import com.caucho.ejb.protocol.Skeleton;
import com.caucho.hessian.io.HessianRemoteResolver;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;

public class HessianProtocol
extends ProtocolContainer {
    static L10N L = new L10N(HessianProtocol._resin_compat_class_0());
    private Class _objectSkelClass;
    private Class _homeSkelClass;
    private HashMap<AbstractServer, Class> _homeSkeletonMap = new HashMap();
    private HashMap<AbstractServer, Class> _objectSkeletonMap = new HashMap();
    private HessianRemoteResolver _resolver = new HessianStubFactory();
    private static Class _resin_compat_class_0;

    public String getName() {
        return "hessian";
    }

    protected HandleEncoder createHandleEncoder(AbstractServer server, Class primaryKeyClass) throws ConfigException {
        return new HessianHandleEncoder(server, new CharBuffer().append(this.getURLPrefix()).append(server.getEJBName()).toString(), primaryKeyClass);
    }

    String calculateURL(String ejbName) {
        return new CharBuffer().append(this.getURLPrefix()).append(ejbName).toString();
    }

    public Skeleton getSkeleton(String uri, String queryString) throws Exception {
        String serverId = uri;
        String objectId = null;
        if (queryString != null) {
            int p = queryString.indexOf(61);
            objectId = p >= 0 ? queryString.substring(p + 1) : queryString;
        }
        if (serverId.equals("/_ejb_xa_resource")) {
            return new XAResourceSkeleton(this.getProtocolManager().getServerManager().getTransactionManager());
        }
        AbstractServer server = this.getProtocolManager().getServerByEJBName(serverId);
        if (server == null) {
            ArrayList<String> children = this.getProtocolManager().getRemoteChildren(serverId);
            if (children != null && children.size() > 0) {
                return new NameContextSkeleton(this, serverId);
            }
            return null;
        }
        if (objectId != null) {
            Object key = server.getHandleEncoder("hessian").objectIdToKey(objectId);
            EJBObject obj = server.getContext(key, false).getRemoteView();
            Class objectSkelClass = this.getObjectSkelClass(server);
            HessianSkeleton skel = (HessianSkeleton)objectSkelClass.newInstance();
            skel._setServer(server);
            skel._setResolver(this._resolver);
            skel._setObject(obj);
            return skel;
        }
        if (server instanceof MessageServer) {
            return new MessageSkeleton((MessageServer)server);
        }
        Object remote = server.getRemoteObject();
        if (remote instanceof EJBHome) {
            Class homeSkelClass = this.getHomeSkelClass(server);
            HessianSkeleton skel = (HessianSkeleton)homeSkelClass.newInstance();
            skel._setServer(server);
            skel._setResolver(this._resolver);
            skel._setObject(remote);
            return skel;
        }
        if (remote instanceof EJBObject) {
            Class skelClass = this.getObjectSkelClass(server);
            HessianSkeleton skel = (HessianSkeleton)skelClass.newInstance();
            skel._setServer(server);
            skel._setResolver(this._resolver);
            skel._setObject(remote);
            return skel;
        }
        return null;
    }

    protected Class getHomeSkelClass(AbstractServer server) throws Exception {
        Class homeSkelClass = this._homeSkeletonMap.get(server);
        if (homeSkelClass != null) {
            return homeSkelClass;
        }
        Class remoteHomeClass = server.getRemoteHomeClass();
        homeSkelClass = HessianSkeletonGenerator.generate(remoteHomeClass, this.getWorkPath());
        this._homeSkeletonMap.put(server, homeSkelClass);
        return homeSkelClass;
    }

    protected Class getObjectSkelClass(AbstractServer server) throws Exception {
        Class objectSkelClass = this._objectSkeletonMap.get(server);
        if (objectSkelClass != null) {
            return objectSkelClass;
        }
        Class remoteObjectClass = server.getRemoteObjectClass();
        objectSkelClass = HessianSkeletonGenerator.generate(remoteObjectClass, this.getWorkPath());
        this._objectSkeletonMap.put(server, objectSkelClass);
        return objectSkelClass;
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.ejb.hessian.HessianProtocol");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

