/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.hessian;

import com.caucho.config.ConfigException;
import com.caucho.ejb.AbstractServer;
import com.caucho.ejb.EJBExceptionWrapper;
import com.caucho.ejb.hessian.HessianHandle;
import com.caucho.ejb.hessian.HessianHandleEncoder;
import com.caucho.ejb.hessian.HessianHomeHandle;
import com.caucho.ejb.hessian.HessianStub;
import com.caucho.ejb.hessian.HomeStub;
import com.caucho.ejb.hessian.MetaStub;
import com.caucho.ejb.hessian.ObjectStub;
import com.caucho.ejb.hessian.StubGenerator;
import com.caucho.ejb.protocol.EjbProtocolManager;
import com.caucho.ejb.protocol.HandleEncoder;
import com.caucho.hessian.io.HessianRemoteResolver;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;

class HessianClientContainer
implements HessianRemoteResolver {
    protected static L10N L = new L10N(HessianClientContainer._resin_compat_class_0());
    private static EnvironmentLocal<Map<String, HessianClientContainer>> _hessianClient = new EnvironmentLocal("caucho.hessian.client");
    private String _serverId;
    private HessianHandleEncoder _handleEncoder;
    EJBHome _ejbHome;
    Class _homeClass;
    Class _remoteClass;
    Class _homeStubClass;
    Class _remoteStubClass;
    Class _primaryKeyClass;
    private String _basicAuth;
    private static Class _resin_compat_class_0;

    HessianClientContainer(String serverId) throws ConfigException {
        this._serverId = serverId;
        this._remoteStubClass = this.getRemoteStubClass();
        this._homeStubClass = this.getHomeStubClass();
    }

    static HessianClientContainer find(String serverId) {
        try {
            Map<String, HessianClientContainer> map = _hessianClient.getLevel();
            HessianClientContainer client = null;
            if (map != null) {
                client = map.get(serverId);
            }
            if (client == null) {
                client = new HessianClientContainer(serverId);
                if (map == null) {
                    map = new Hashtable<String, HessianClientContainer>();
                }
                map.put(serverId, client);
                _hessianClient.set(map);
            }
            return client;
        }
        catch (Exception e) {
            throw EJBExceptionWrapper.createRuntime(e);
        }
    }

    protected EJBHome getHomeStub() throws ConfigException {
        try {
            HomeStub homeStub = (HomeStub)this._homeStubClass.newInstance();
            homeStub._init(this._serverId, this);
            return homeStub;
        }
        catch (IllegalAccessException e) {
            throw new ConfigException(e);
        }
        catch (InstantiationException e) {
            throw new ConfigException(e);
        }
    }

    protected EJBObject createObjectStub(String url) throws ConfigException {
        try {
            ObjectStub objStub = (ObjectStub)this._remoteStubClass.newInstance();
            objStub._init(url, this);
            return objStub;
        }
        catch (IllegalAccessException e) {
            throw new ConfigException(e);
        }
        catch (InstantiationException e) {
            throw new ConfigException(e);
        }
    }

    HessianHomeHandle getHomeHandle() {
        return new HessianHomeHandle(this._ejbHome, this._serverId);
    }

    HessianHandle createHandle(String url) {
        return new HessianHandle(url);
    }

    public HandleEncoder getHandleEncoder() {
        try {
            if (this._handleEncoder == null) {
                this._handleEncoder = new HessianHandleEncoder(null, this._serverId, this.getPrimaryKeyClass());
            }
            return this._handleEncoder;
        }
        catch (Exception e) {
            throw EJBExceptionWrapper.createRuntime(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Class getHomeStubClass() throws ConfigException {
        if (this._homeStubClass != null) {
            return this._homeStubClass;
        }
        HessianClientContainer hessianClientContainer = this;
        synchronized (hessianClientContainer) {
            if (this._homeStubClass != null) {
                return this._homeStubClass;
            }
            StubGenerator gen = new StubGenerator();
            this._homeStubClass = gen.createHomeStub(this.getHomeClass());
        }
        return this._homeStubClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Class getRemoteStubClass() throws ConfigException {
        if (this._remoteStubClass != null) {
            return this._remoteStubClass;
        }
        HessianClientContainer hessianClientContainer = this;
        synchronized (hessianClientContainer) {
            if (this._remoteStubClass != null) {
                return this._remoteStubClass;
            }
            Class remoteClass = this.getRemoteClass();
            if (remoteClass == null) {
                return null;
            }
            StubGenerator gen = new StubGenerator();
            this._remoteStubClass = gen.createObjectStub(remoteClass);
        }
        return this._remoteStubClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Class getHomeClass() throws ConfigException {
        if (this._homeClass != null) {
            return this._homeClass;
        }
        try {
            HessianClientContainer hessianClientContainer = this;
            synchronized (hessianClientContainer) {
                if (this._homeClass != null) {
                    return this._homeClass;
                }
                String className = this.getHomeClassName();
                this._homeClass = CauchoSystem.loadClass(className, false, null);
            }
        }
        catch (ClassNotFoundException e) {
            throw new ConfigException(e);
        }
        return this._homeClass;
    }

    String getHomeClassName() throws ConfigException {
        AbstractServer server = EjbProtocolManager.getJVMServer(this._serverId);
        if (server != null) {
            Class cl = server.getRemoteHomeClass();
            if (cl != null) {
                return cl.getName();
            }
            throw new ConfigException(L.l("`{0}' has no remote interface.", this._serverId));
        }
        try {
            Path path = Vfs.lookup(this._serverId);
            return (String)MetaStub.call(path, "_hessian_getAttribute", "home-class");
        }
        catch (Throwable e) {
            throw new ConfigException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Class getRemoteClass() throws ConfigException {
        if (this._remoteClass != null) {
            return this._remoteClass;
        }
        try {
            HessianClientContainer hessianClientContainer = this;
            synchronized (hessianClientContainer) {
                if (this._remoteClass != null) {
                    return this._remoteClass;
                }
                String className = this.getRemoteClassName();
                if (className == null || className.equals("null")) {
                    return null;
                }
                this._remoteClass = CauchoSystem.loadClass(className, false, null);
            }
        }
        catch (ClassNotFoundException e) {
            throw new ConfigException(e);
        }
        return this._remoteClass;
    }

    String getRemoteClassName() throws ConfigException {
        AbstractServer server = EjbProtocolManager.getJVMServer(this._serverId);
        if (server != null) {
            Class cl = server.getRemoteObjectClass();
            if (cl != null) {
                return cl.getName();
            }
            throw new ConfigException(L.l("`{0}' has no remote interface.", this._serverId));
        }
        try {
            Path path = Vfs.lookup(this._serverId);
            return (String)MetaStub.call(path, "_hessian_getAttribute", "remote-class");
        }
        catch (Throwable e) {
            throw new ConfigException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Class getPrimaryKeyClass() throws ConfigException {
        if (this._primaryKeyClass != null) {
            return this._primaryKeyClass;
        }
        try {
            HessianClientContainer hessianClientContainer = this;
            synchronized (hessianClientContainer) {
                if (this._primaryKeyClass != null) {
                    return this._primaryKeyClass;
                }
                String className = this.getPrimaryKeyClassName();
                this._primaryKeyClass = CauchoSystem.loadClass(className, false, null);
            }
        }
        catch (ClassNotFoundException e) {
            throw new ConfigException(e);
        }
        return this._primaryKeyClass;
    }

    String getPrimaryKeyClassName() throws ConfigException {
        AbstractServer server = EjbProtocolManager.getJVMServer(this._serverId);
        if (server != null) {
            Class cl = server.getPrimaryKeyClass();
            if (cl != null) {
                return cl.getName();
            }
            throw new ConfigException(L.l("`{0}' has no remote interface.", this._serverId));
        }
        try {
            Path path = Vfs.lookup(this._serverId);
            return (String)MetaStub.call(path, "_hessian_getAttribute", "primary-key-class");
        }
        catch (Throwable e) {
            throw new ConfigException(e);
        }
    }

    public Object lookup(String type, String url) throws IOException {
        try {
            Class api = CauchoSystem.loadClass(type);
            return this.create(api, url);
        }
        catch (Exception e) {
            throw new IOException(String.valueOf(e));
        }
    }

    public Object create(Class api, String url) throws Exception {
        StubGenerator gen = new StubGenerator();
        gen.setClassDir(CauchoSystem.getWorkPath());
        Class cl = gen.createStub(api);
        HessianStub stub = (HessianStub)cl.newInstance();
        stub._init(url, this);
        return stub;
    }

    String getBasicAuthentication() {
        return this._basicAuth;
    }

    void setBasicAuthentication(String auth) {
        this._basicAuth = auth != null ? new CharBuffer().append("Basic ").append(auth).toString() : auth;
    }

    public String toString() {
        return new CharBuffer().append("HessianClientContainer[").append(this._serverId).append("]").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.ejb.hessian.HessianClientContainer");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

