/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.gen;

import com.caucho.java.JavaWriter;
import com.caucho.java.gen.CallChain;
import com.caucho.java.gen.FilterCallChain;
import com.caucho.util.L10N;
import java.io.IOException;

public class TransactionChain
extends FilterCallChain {
    private static final L10N L = new L10N(TransactionChain._resin_compat_class_0());
    private int _xaType;
    private static Class _resin_compat_class_0;

    public TransactionChain(CallChain next, int xaType) {
        super(next);
        this._xaType = xaType;
    }

    public static TransactionChain create(CallChain next, int xaType) {
        return new TransactionChain(next, xaType);
    }

    public void generateCall(JavaWriter out, String retType, String var, String[] args) throws IOException {
        out.println("Thread thread = Thread.currentThread();");
        out.println("ClassLoader oldLoader = thread.getContextClassLoader();");
        out.print("com.caucho.ejb.xa.TransactionContext trans");
        switch (this._xaType) {
            case 7: {
                out.println(" = _xaManager.beginSingleRead();");
                break;
            }
            case 4: {
                out.println(" = _xaManager.beginRequiresNew();");
                break;
            }
            case 0: 
            case 1: {
                out.println(" = _xaManager.suspend();");
                break;
            }
            case 6: {
                out.println(" = _xaManager.beginNever();");
                break;
            }
            case 3: {
                out.println(" = _xaManager.beginRequired();");
                break;
            }
            case 5: {
                out.println(" = _xaManager.beginMandatory();");
                break;
            }
            default: {
                out.println(" = _xaManager.beginSupports();");
            }
        }
        out.println("try {");
        out.pushDepth();
        out.println("thread.setContextClassLoader(_context._server.getClassLoader());");
        super.generateCall(out, retType, var, args);
        out.popDepth();
        out.println("} catch (RuntimeException e) {");
        out.pushDepth();
        out.println("throw trans.setRollbackOnly(e);");
        out.popDepth();
        out.println("} finally {");
        out.pushDepth();
        out.println("thread.setContextClassLoader(oldLoader);");
        out.println("trans.commit();");
        out.popDepth();
        out.println("}");
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.ejb.gen.TransactionChain");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

