/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.gen;

import com.caucho.bytecode.JClass;
import com.caucho.bytecode.JMethod;
import com.caucho.ejb.cfg.CmrManyToMany;
import com.caucho.ejb.cfg.CmrManyToOne;
import com.caucho.ejb.cfg.CmrRelation;
import com.caucho.ejb.cfg.EjbEntityBean;
import com.caucho.java.JavaWriter;
import com.caucho.java.gen.BaseClass;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.io.IOException;

public class CollectionClass
extends BaseClass {
    private static final L10N L = new L10N(CollectionClass._resin_compat_class_1());
    private CmrRelation _oneToMany;
    private static Class _resin_compat_class_0;
    private static Class _resin_compat_class_1;

    public CollectionClass(CmrRelation oneToMany, String className) {
        this._oneToMany = oneToMany;
        this.setClassName(className);
        JClass retType = oneToMany.getGetter().getReturnType();
        if (retType.isAssignableTo(CollectionClass._resin_compat_class_0())) {
            this.setSuperClassName("com.caucho.ejb.entity.CmpSetImpl");
        } else {
            this.setSuperClassName("com.caucho.ejb.entity.CmpCollectionImpl");
        }
    }

    public void generateClassContent(JavaWriter out) throws IOException {
        this.generateConstructor(out);
        this.generateAdd(out);
        this.generateRemove(out);
        super.generateClassContent(out);
    }

    public void generateConstructor(JavaWriter out) throws IOException {
        EjbEntityBean sourceBean = this._oneToMany.getBean();
        String sourceType = sourceBean.getLocal().getName();
        out.println();
        out.println("Bean _bean;");
        out.println(new CharBuffer().append(sourceType).append(" _beanLocal;").toString());
        out.println();
        out.println(new CharBuffer().append("public ").append(this.getClassName()).append("(Bean bean, com.caucho.amber.AmberQuery query)").toString());
        out.println("{");
        out.pushDepth();
        out.println("_bean = bean;");
        out.println("_beanLocal = bean._ejb_context._viewLocal;");
        out.println("fill(query);");
        out.popDepth();
        out.println("}");
    }

    public void generateAdd(JavaWriter out) throws IOException {
        out.println();
        out.println("public boolean addImpl(Object v)");
        out.println("{");
        out.pushDepth();
        EjbEntityBean targetBean = this._oneToMany.getTargetBean();
        String targetType = targetBean.getLocal().getName();
        out.println("if (v == null)");
        out.println("  return false;");
        out.println(new CharBuffer().append("else if (! (v instanceof ").append(targetType).append("))").toString());
        out.println("  throw new IllegalArgumentException(v.getClass().getName() + \": \" + v);");
        CmrRelation targetRelation = this._oneToMany.getTargetRelation();
        if (targetRelation instanceof CmrManyToOne) {
            CmrManyToOne manyToOne = (CmrManyToOne)targetRelation;
            JMethod setter = manyToOne.getSetter();
            if (setter != null) {
                out.println(new CharBuffer().append(targetType).append(" bean = (").append(targetType).append(") v;").toString());
                JMethod localDstSetter = EjbEntityBean.getMethod(targetBean.getLocal(), setter);
                if (localDstSetter != null) {
                    out.print("bean");
                } else {
                    out.print(new CharBuffer().append("((").append(targetBean.getEJBClass().getName()).append(") ").toString());
                    out.print("((com.caucho.ejb.entity.EntityObject) bean)._caucho_getBean(_ejb_trans, true))");
                }
                out.println(new CharBuffer().append(".").append(setter.getName()).append("(_beanLocal);").toString());
            }
        } else if (this._oneToMany instanceof CmrManyToMany) {
            CmrManyToMany manyToMany = (CmrManyToMany)this._oneToMany;
            JMethod getter = manyToMany.getGetter();
            if (manyToMany.isTargetUnique()) {
                out.println(new CharBuffer().append("_bean.__amber_").append(getter.getName()).append("_remove_target(v);").toString());
            }
            out.println(new CharBuffer().append("_bean.__amber_").append(getter.getName()).append("_add(v);").toString());
        }
        out.println("return true;");
        out.popDepth();
        out.println("}");
    }

    public void generateRemove(JavaWriter out) throws IOException {
        out.println();
        out.println("protected boolean removeImpl(Object v)");
        out.println("{");
        out.pushDepth();
        EjbEntityBean targetBean = this._oneToMany.getTargetBean();
        String targetType = targetBean.getLocal().getName();
        out.println("if (v == null)");
        out.println("  return false;");
        out.println(new CharBuffer().append("else if (! (v instanceof ").append(targetType).append("))").toString());
        out.println("  throw new IllegalArgumentException(v.getClass().getName() + \": \" + v);");
        CmrRelation targetRelation = this._oneToMany.getTargetRelation();
        if (targetRelation instanceof CmrManyToOne) {
            CmrManyToOne manyToOne = (CmrManyToOne)targetRelation;
            JMethod setter = manyToOne.getSetter();
            JMethod getter = manyToOne.getGetter();
            if (setter != null) {
                out.println("if (_bean != null) {");
                out.pushDepth();
                out.println(new CharBuffer().append(targetType).append(" bean = (").append(targetType).append(") v;").toString());
                out.println("if (_beanLocal != null) {");
                out.pushDepth();
                JMethod localDstSetter = EjbEntityBean.getMethod(targetBean.getLocal(), setter);
                String bean = "bean";
                if (localDstSetter == null) {
                    String beanClass = targetBean.getEJBClass().getName();
                    out.print(new CharBuffer().append(beanClass).append(" bean1 = ((").append(beanClass).append(") ").toString());
                    out.print("((com.caucho.ejb.entity.EntityObject) bean)._caucho_getBean(_ejb_trans, true));");
                    bean = "bean1";
                }
                out.println(new CharBuffer().append("if (_beanLocal.equals(").append(bean).append(".").append(getter.getName()).append("())) {").toString());
                out.pushDepth();
                out.println(new CharBuffer().append(bean).append(".").append(setter.getName()).append("(null);").toString());
                out.popDepth();
                out.println("}");
                out.popDepth();
                out.println("}");
                out.popDepth();
                out.println("}");
                out.println();
            }
        } else if (this._oneToMany instanceof CmrManyToMany) {
            CmrManyToMany manyToMany = (CmrManyToMany)this._oneToMany;
            JMethod getter = manyToMany.getGetter();
            out.println(new CharBuffer().append("_bean.__amber_").append(getter.getName()).append("_remove(v);").toString());
        }
        out.println("return true;");
        out.popDepth();
        out.println("}");
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("java.util.Set");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_1() {
        try {
            Class<?> clazz = _resin_compat_class_1;
            if (clazz == null) {
                clazz = _resin_compat_class_1 = Class.forName("com.caucho.ejb.gen.CollectionClass");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

