/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.entity;

import com.caucho.amber.AmberException;
import com.caucho.amber.connection.AmberConnectionImpl;
import com.caucho.amber.connection.CacheConnectionImpl;
import com.caucho.amber.entity.AmberEntityHome;
import com.caucho.amber.entity.EntityItem;
import com.caucho.ejb.AbstractContext;
import com.caucho.ejb.AbstractServer;
import com.caucho.ejb.EJBExceptionWrapper;
import com.caucho.ejb.EjbServerManager;
import com.caucho.ejb.FinderExceptionWrapper;
import com.caucho.ejb.entity.AmberEntityFactory;
import com.caucho.ejb.entity.QEntityContext;
import com.caucho.ejb.protocol.AbstractHandle;
import com.caucho.ejb.protocol.JVMObject;
import com.caucho.util.Alarm;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.logging.Level;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.FinderException;
import javax.ejb.HomeHandle;
import javax.ejb.ObjectNotFoundException;
import javax.sql.DataSource;

public class EntityServer
extends AbstractServer {
    private static final L10N L = new L10N(EntityServer._resin_compat_class_0());
    private DataSource _dataSource;
    private HomeHandle _homeHandle;
    private QEntityContext _homeContext;
    private int _random;
    private boolean _isInit;
    private boolean _isCMP;
    private boolean _isLoadLazyOnTransaction = true;
    private Field[] _primaryKeyFields;
    private Throwable _exception;
    private AmberEntityHome _amberEntityHome;
    private ArrayList<RemoveListener> _removeListeners = new ArrayList();
    private ArrayList<EntityServer> _updateListeners;
    private Constructor _contextConstructor;
    private boolean _isCacheable = true;
    private long _cacheTimeout = 1000L;
    private long _invalidateTime;
    private int _jdbcIsolation = -1;
    private static Class _resin_compat_class_0;

    public EntityServer(EjbServerManager ejbManager) {
        super(ejbManager);
    }

    public Class getPrimaryKeyClass() {
        return this._primaryKeyClass;
    }

    public void setCMP(boolean isCMP) {
        this._isCMP = isCMP;
    }

    public boolean isCMP() {
        return this._isCMP;
    }

    public boolean getBeanManagedPersistence() {
        return !this._isCMP;
    }

    public boolean isLoadLazyOnTransaction() {
        return this._isLoadLazyOnTransaction;
    }

    public void setLoadLazyOnTransaction(boolean isLoadLazy) {
        this._isLoadLazyOnTransaction = isLoadLazy;
    }

    public boolean doLoad(long loadTime) {
        if (loadTime <= this._invalidateTime) {
            return true;
        }
        long expiresTime = Alarm.getCurrentTime() - this._cacheTimeout;
        return loadTime <= expiresTime;
    }

    public void setAmberEntityHome(AmberEntityHome home) {
        this._amberEntityHome = home;
    }

    public void invalidateCache() {
        this._invalidateTime = Alarm.getCurrentTime();
    }

    public void setPrimaryKeyClass(Class cl) {
        this._primaryKeyClass = cl;
    }

    public void init() throws Exception {
        try {
            Class primaryKeyClass;
            this._jdbcIsolation = this._ejbManager.getJDBCIsolation();
            Class[] param = new Class[]{EntityServer._resin_compat_class_0()};
            this._contextConstructor = this._contextImplClass.getConstructor(param);
            this._homeContext = (QEntityContext)this._contextConstructor.newInstance(this);
            this._localHome = this._homeContext.createLocalHome();
            this._remoteHomeView = this._homeContext.createRemoteHomeView();
            this.initRelations();
            if (this._isCMP) {
                this._amberEntityHome.setEntityFactory(new AmberEntityFactory(this));
            }
            if ((primaryKeyClass = this.getPrimaryKeyClass()) != null && !primaryKeyClass.isPrimitive() && !primaryKeyClass.getName().startsWith("java.lang.")) {
                this._primaryKeyFields = primaryKeyClass.getFields();
            }
            log.config(new CharBuffer().append("initialized entity bean: ").append(this).toString());
        }
        catch (Exception e) {
            this._exception = e;
            throw e;
        }
    }

    private void initRelations() {
        if (!this.isCMP()) {
            return;
        }
    }

    protected AbstractHandle createHandle(Object primaryKey) {
        return this.getHandleEncoder().createHandle(this.encodeId(primaryKey));
    }

    public String encodeId(Object primaryKey) {
        if (this._primaryKeyFields == null) {
            return String.valueOf(primaryKey);
        }
        try {
            CharBuffer cb = new CharBuffer();
            for (int i = 0; i < this._primaryKeyFields.length; ++i) {
                if (i != 0) {
                    cb.append(',');
                }
                cb.append(this._primaryKeyFields[i].get(primaryKey));
            }
            return cb.toString();
        }
        catch (IllegalAccessException e) {
            throw new EJBExceptionWrapper(e);
        }
    }

    public void postCreate(Object key, QEntityContext cxt) {
        this._ejbManager.putEntityIfNew(this, key, cxt);
    }

    public void addRemoveListener(QEntityContext context) {
        Object listener = null;
        if (!this._removeListeners.contains(listener)) {
            this._removeListeners.add((RemoveListener)listener);
        }
    }

    public void addUpdateListener(EntityServer listener) {
        if (this._updateListeners == null) {
            this._updateListeners = new ArrayList();
        }
        if (!this._updateListeners.contains(listener)) {
            this._updateListeners.add(listener);
        }
    }

    public void remove(Object key) {
        for (int i = this._removeListeners.size() - 1; i >= 0; --i) {
            RemoveListener listener = this._removeListeners.get(i);
            try {
                listener._listener._caucho_remove_callback(listener._listenClass, key);
                continue;
            }
            catch (Throwable e) {
                EJBExceptionWrapper.createRuntime(e);
            }
        }
    }

    public void removeCache(Object key) {
        this._ejbManager.removeEntity(this, key);
    }

    public AbstractContext findByPrimaryKey(Object key) throws FinderException {
        return this.getContext(key, this._isCMP);
    }

    public AbstractContext findByPrimaryKey(int key) throws FinderException {
        return this.getContext(new Long(key), this._isCMP);
    }

    public AbstractContext findKnownObjectByPrimaryKey(Object key) {
        if (key == null) {
            return null;
        }
        try {
            return this.getContext(key, false);
        }
        catch (FinderException e) {
            throw EJBExceptionWrapper.createRuntime(e);
        }
    }

    public Object findKnownObjectByPrimaryKey(int key) {
        return this.findKnownObjectByPrimaryKey(new Integer(key));
    }

    public EJBHome getClientHome() throws RemoteException {
        if (!this._isInit) {
            this._isInit = true;
        }
        if (this._remoteHome == null) {
            try {
                this._remoteHome = this._jvmClient.createHomeStub();
            }
            catch (Exception e) {
                EJBExceptionWrapper.createRuntime(e);
            }
        }
        return this._remoteHome;
    }

    public EJBHome getEJBHome() throws RemoteException {
        return this._remoteHomeView;
    }

    public EJBLocalHome getClientLocalHome() {
        if (!this._isInit) {
            this._isInit = true;
        }
        return this._localHome;
    }

    public Object getHomeObject() {
        if (!this._isInit) {
            this._isInit = true;
        }
        return this._remoteHomeView;
    }

    JVMObject createEJBObject(Object primaryKey) {
        if (this._remoteStubClass == null) {
            throw new IllegalStateException(L.l("`{0}' has no remote interface.  Local beans must be called from a local context. Remote beans need a home and a remote interface.", this.getEJBName()));
        }
        try {
            JVMObject obj = (JVMObject)this._remoteStubClass.newInstance();
            obj._init(this, primaryKey);
            return obj;
        }
        catch (Exception e) {
            throw new EJBExceptionWrapper(e);
        }
    }

    public AbstractContext getContext(Object key) throws FinderException {
        return this.getContext(key, this._isCMP);
    }

    public AbstractContext getContext(Object key, boolean forceLoad) throws FinderException {
        if (key == null) {
            return null;
        }
        QEntityContext cxt = this._ejbManager.getEntity(this, key);
        try {
            if (cxt == null) {
                EntityItem amberItem = null;
                if (this._isCMP) {
                    CacheConnectionImpl aConn = this._amberEntityHome.getManager().getCacheConnection();
                    try {
                        amberItem = this._amberEntityHome.findEntityItem(aConn, key, forceLoad);
                    }
                    catch (AmberException e) {
                        String name = this.getEJBName();
                        if (name.startsWith("/")) {
                            name = name.substring(1);
                        }
                        ObjectNotFoundException exn = new ObjectNotFoundException(L.l("'{0}' is an unknown entity.", new CharBuffer().append(name).append("[").append(key).append("]").toString()));
                        exn.initCause((Throwable)e);
                        throw exn;
                    }
                    finally {
                        ((AmberConnectionImpl)aConn).freeConnection();
                    }
                }
                cxt = (QEntityContext)this._contextConstructor.newInstance(this);
                cxt.setPrimaryKey(key);
                if (amberItem != null) {
                    cxt.__caucho_setAmber(amberItem);
                }
            }
            if (forceLoad && !this._isLoadLazyOnTransaction && this.getTransactionManager().getTransaction() != null) {
                cxt._caucho_load();
            }
            cxt = this._ejbManager.putEntityIfNew(this, key, cxt);
            return cxt;
        }
        catch (FinderException e) {
            throw e;
        }
        catch (Exception e) {
            throw FinderExceptionWrapper.create(e);
        }
    }

    public Connection getConnection(boolean isReadOnly) throws SQLException {
        if (isReadOnly) {
            return this._dataSource.getConnection();
        }
        Connection conn = this._dataSource.getConnection();
        if (this._jdbcIsolation > 0) {
            conn.setTransactionIsolation(this._jdbcIsolation);
        }
        return conn;
    }

    public void update(Object key) {
        if (key == null) {
            return;
        }
        QEntityContext cxt = this._ejbManager.getEntity(this, key);
        if (cxt == null) {
            return;
        }
        cxt.update();
    }

    public void updateView(Object key) {
        if (this._updateListeners == null) {
            return;
        }
        for (int i = this._updateListeners.size() - 1; i >= 0; --i) {
            EntityServer server = this._updateListeners.get(i);
            server.update(key);
        }
    }

    public String randomString(int max, int i) {
        return String.valueOf(++this._random);
    }

    public int randomInt(int max, int i) {
        return max;
    }

    public static IllegalStateException createGetStateException(int state) {
        switch (state) {
            case 0: {
                return new IllegalStateException(L.l("Can't access CMP field for a removed object."));
            }
            case 1: {
                return new IllegalStateException(L.l("Can't access CMP field for a dead object.  The object is dead due to a runtime exception and rollback."));
            }
            case 2: {
                return new IllegalStateException(L.l("Can't access CMP field for an uninitialized object."));
            }
            case 3: {
                return new IllegalStateException(L.l("Can't access CMP field from a Home object."));
            }
        }
        return new IllegalStateException(L.l("Can't access CMP field from an unknown state."));
    }

    public static IllegalStateException createSetStateException(int state) {
        switch (state) {
            case 0: {
                return new IllegalStateException(L.l("Can't set CMP field for a removed object."));
            }
            case 1: {
                return new IllegalStateException(L.l("Can't set CMP field for a dead object.  The object is dead due to a runtime exception and rollback."));
            }
            case 2: {
                return new IllegalStateException(L.l("Can't set CMP field for an uninitialized object."));
            }
            case 3: {
                return new IllegalStateException(L.l("Can't set CMP field from a Home object."));
            }
        }
        return new IllegalStateException(L.l("Can't set CMP field from an unknown state."));
    }

    public void destroy() {
        ArrayList<QEntityContext> beans = new ArrayList<QEntityContext>();
        this._ejbManager.removeBeans(beans, this);
        Collections.sort(beans, new EntityCmp());
        for (int i = 0; i < beans.size(); ++i) {
            QEntityContext cxt = beans.get(i);
            try {
                cxt.destroy();
                continue;
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
        QEntityContext homeContext = this._homeContext;
        this._homeContext = null;
        try {
            if (homeContext != null) {
                homeContext.destroy();
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        super.destroy();
    }

    public String toString() {
        return new CharBuffer().append("EntityServer[").append(this._ejbName).append("]").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.ejb.entity.EntityServer");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class EntityCmp
    implements Comparator<QEntityContext> {
        EntityCmp() {
        }

        @Override
        public int compare(QEntityContext ca, QEntityContext cb) {
            try {
                String sa = String.valueOf(ca.getPrimaryKey());
                String sb = String.valueOf(cb.getPrimaryKey());
                return sa.compareTo(sb);
            }
            catch (Exception e) {
                return 0;
            }
        }
    }

    static class RemoveListener {
        QEntityContext _listener;
        Class _listenClass;

        RemoveListener(QEntityContext listener, Class listenClass) {
            this._listener = listener;
            this._listenClass = listenClass;
        }

        public boolean equals(Object o) {
            if (!(o instanceof RemoveListener)) {
                return false;
            }
            RemoveListener listener = (RemoveListener)o;
            return this._listener.equals(listener._listener) && this._listenClass.equals(listener._listenClass);
        }

        public String toString() {
            return new CharBuffer().append("RemoveListener[").append(this._listener).append("]").toString();
        }
    }
}

