/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.doclet;

import com.caucho.config.ConfigException;
import com.caucho.config.LineConfigException;
import com.caucho.doclet.ClassDocImpl;
import com.caucho.doclet.DocImpl;
import com.caucho.doclet.MethodDocImpl;
import com.caucho.doclet.TagImpl;
import com.caucho.java.JavaWriter;
import com.caucho.log.Log;
import com.caucho.util.Alarm;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.util.QDate;
import com.caucho.vfs.Path;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;

public class EjbObjectGenerator {
    private static final Logger log = Log.open(EjbObjectGenerator._resin_compat_class_0());
    private static final L10N L = new L10N(EjbObjectGenerator._resin_compat_class_0());
    private ClassDocImpl _classDoc;
    private boolean _isLocal = true;
    private String _fullClassName;
    private String _shortClassName;
    private String _package;
    private String _interfaceName;
    private String _primKeyClass;
    private static Class _resin_compat_class_0;

    EjbObjectGenerator(ClassDocImpl classDoc) {
        this._classDoc = classDoc;
    }

    public void setLocal(boolean isLocal) {
        this._isLocal = isLocal;
    }

    public void setClassName(String className) {
        this._fullClassName = className;
        int p = className.lastIndexOf(46);
        if (p > 0) {
            this._shortClassName = className.substring(p + 1);
            this._package = className.substring(0, p);
        } else {
            this._shortClassName = className;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(Path path) throws IOException, ConfigException {
        this._interfaceName = this._classDoc.getAttribute("@ejb.home", "local-class");
        this._primKeyClass = this._classDoc.getAttribute("@ejb.pk", "class");
        if (this._primKeyClass == null) {
            this._primKeyClass = "java.lang.String";
        }
        path.getParent().mkdirs();
        WriteStream os = path.openWrite();
        try {
            JavaWriter out = new JavaWriter(os);
            this.generate(out);
        }
        finally {
            os.close();
        }
    }

    public void generate(JavaWriter out) throws IOException, ConfigException {
        out.println("/**");
        out.println(" * object interface generated by Resin-EE doclet.");
        out.println(new CharBuffer().append(" * on ").append(QDate.formatLocal(Alarm.getCurrentTime())).toString());
        out.println(" */");
        if (this._package != null) {
            out.println();
            out.println(new CharBuffer().append("package ").append(this._package).append(";").toString());
        }
        out.println();
        out.println(new CharBuffer().append("public interface ").append(this._shortClassName).toString());
        if (this._isLocal) {
            String localExtends = this._classDoc.getAttribute("@ejb.interface", "local-extends");
            if (localExtends == null) {
                localExtends = "javax.ejb.EJBLocalObject";
            }
            out.println(new CharBuffer().append("  extends ").append(localExtends).append(" {").toString());
        } else {
            String remoteExtends = this._classDoc.getAttribute("@ejb.interface", "extends");
            if (remoteExtends == null) {
                remoteExtends = "javax.ejb.EJBObject";
            }
            out.println(new CharBuffer().append("  extends ").append(remoteExtends).append(" {").toString());
        }
        out.pushDepth();
        this.generateMethods(out);
        out.popDepth();
        out.println("}");
    }

    public void generateMethods(JavaWriter out) throws IOException, ConfigException {
        ArrayList<MethodDocImpl> methodList = this._classDoc.getMethods();
        for (int i = 0; i < methodList.size(); ++i) {
            ArrayList<TagImpl> tagList;
            MethodDocImpl method = methodList.get(i);
            if (method.getName().startsWith("ejb") || (tagList = method.getTagList("@ejb.interface-method")) == null) continue;
            out.println();
            out.print(new CharBuffer().append("public ").append(method.getReturnType()).append(" ").toString());
            out.print(new CharBuffer().append(method.getName()).append("(").toString());
            ArrayList<MethodDocImpl.Param> paramList = method.getParameters();
            for (int j = 0; j < paramList.size(); ++j) {
                MethodDocImpl.Param param = paramList.get(j);
                if (j > 0) {
                    out.print(", ");
                }
                out.print(new CharBuffer().append(param.getType()).append(" ").append(param.getName()).toString());
            }
            out.println(");");
        }
    }

    private ConfigException error(DocImpl loc, String msg) {
        if (loc == null) {
            return new ConfigException(msg);
        }
        if (loc.getPosition() == null) {
            return new ConfigException(new CharBuffer().append(loc.getName()).append(": ").append(msg).toString());
        }
        return new LineConfigException(new CharBuffer().append(loc.getPosition()).append(msg).toString());
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.ejb.doclet.EjbObjectGenerator");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

