/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.doclet;

import com.caucho.config.ConfigException;
import com.caucho.config.LineConfigException;
import com.caucho.doclet.ClassDocImpl;
import com.caucho.doclet.DocImpl;
import com.caucho.doclet.MethodDocImpl;
import com.caucho.doclet.RootDocImpl;
import com.caucho.doclet.TagImpl;
import com.caucho.ejb.doclet.DocletRelation;
import com.caucho.java.JavaWriter;
import com.caucho.log.Log;
import com.caucho.util.BeanUtil;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Logger;

public class EjbJarGenerator {
    private static final Logger log = Log.open(EjbJarGenerator._resin_compat_class_0());
    private static final L10N L = new L10N(EjbJarGenerator._resin_compat_class_0());
    private HashMap<String, DocletRelation> _relations;
    private static Class _resin_compat_class_0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(Path path, RootDocImpl rootDoc) throws IOException, ConfigException {
        WriteStream os = path.openWrite();
        try {
            JavaWriter out = new JavaWriter(os);
            this._relations = new HashMap();
            this.generate(out, rootDoc);
        }
        finally {
            os.close();
        }
    }

    public void generate(JavaWriter out, RootDocImpl rootDoc) throws IOException, ConfigException {
        out.println("<ejb-jar xmlns='http://caucho.com/ns/resin'>");
        out.pushDepth();
        out.println("<enterprise-beans>");
        out.pushDepth();
        Collection<ClassDocImpl> classes = rootDoc.getClasses();
        Iterator<ClassDocImpl> iter = classes.iterator();
        while (iter.hasNext()) {
            ClassDocImpl classDoc = iter.next();
            if (!classDoc.isAssignableTo("javax.ejb.EntityBean")) continue;
            this.generateEntity(out, classDoc);
        }
        out.popDepth();
        out.println("</enterprise-beans>");
        if (this._relations.size() > 0) {
            this.generateRelations(out);
        }
        out.popDepth();
        out.println("</ejb-jar>");
    }

    public void generateEntity(JavaWriter out, ClassDocImpl classDoc) throws IOException, ConfigException {
        String cacheSize;
        String cacheTimeout;
        String readOnly;
        String ejbName = classDoc.getAttribute("@ejb.bean", "name");
        if (ejbName == null) {
            return;
        }
        out.println("<entity>");
        out.pushDepth();
        boolean isCMP = !"Bean".equals(classDoc.getAttribute("@ejb.bean", "type"));
        out.println(new CharBuffer().append("<ejb-name>").append(ejbName).append("</ejb-name>").toString());
        this.generateEntityClasses(out, classDoc);
        String sqlTable = classDoc.getAttribute("@ejb.persistence", "table-name");
        if (sqlTable == null) {
            sqlTable = classDoc.getAttribute("@resin-ejb.entity-bean", "sql-table");
        }
        if (sqlTable != null) {
            out.println(new CharBuffer().append("<sql-table>").append(sqlTable).append("</sql-table>").toString());
        }
        if (isCMP) {
            this.generateCmpFields(out, classDoc);
            this.generateCmpRelations(out, classDoc);
            this.generateCmpFind(out, classDoc);
        }
        if ((readOnly = classDoc.getAttribute("@resin-ejb.bean", "read-only")) != null && !readOnly.equalsIgnoreCase("false")) {
            out.println("<read-only/>");
        }
        if ((cacheTimeout = classDoc.getAttribute("@resin-ejb.bean", "cache-timeout")) != null) {
            out.println(new CharBuffer().append("<cache-timeout>").append(cacheTimeout).append("</cache-timeout>").toString());
        }
        if ((cacheSize = classDoc.getAttribute("@resin-ejb.bean", "cache-size")) != null) {
            out.println(new CharBuffer().append("<cache-size>").append(cacheSize).append("</cache-size>").toString());
        }
        out.popDepth();
        out.println("</entity>");
    }

    public void generateEntityClasses(JavaWriter out, ClassDocImpl classDoc) throws IOException, ConfigException {
        String remoteHome = classDoc.getAttribute("@ejb.home", "remote-class");
        String remote = classDoc.getAttribute("@ejb.interface", "remote-class");
        if (remoteHome != null && remote == null) {
            throw this.error(classDoc, L.l("Remote @ejb.interface expected to match remote @ejb.home `{0}'. ", remoteHome));
        }
        if (remote != null && remoteHome == null) {
            throw this.error(classDoc, L.l("Remote @ejb.home expected to match remote @ejb.interface `{0}'. ", remote));
        }
        if (remoteHome != null) {
            out.println(new CharBuffer().append("<home>").append(remoteHome).append("</home>").toString());
        }
        if (remote != null) {
            out.println(new CharBuffer().append("<remote>").append(remote).append("</remote>").toString());
        }
        String localHome = classDoc.getAttribute("@ejb.home", "local-class");
        String local = classDoc.getAttribute("@ejb.interface", "local-class");
        if (localHome != null && local == null) {
            throw this.error(classDoc, L.l("Local @ejb.interface expected to match local @ejb.home `{0}'. ", localHome));
        }
        if (local != null && localHome == null) {
            throw this.error(classDoc, L.l("Local @ejb.home expected to match local @ejb.interface `{0}'. ", local));
        }
        if (localHome != null) {
            out.println(new CharBuffer().append("<local-home>").append(localHome).append("</local-home>").toString());
        }
        if (local != null) {
            out.println(new CharBuffer().append("<local>").append(local).append("</local>").toString());
        }
        out.println(new CharBuffer().append("<ejb-class>").append(classDoc.getName()).append("</ejb-class>").toString());
        String persistent = classDoc.getAttribute("@ejb.bean", "type");
        if (persistent == null) {
            out.println("<persistence-type>Container</persistence-type>");
        } else if (persistent.equals("CMP")) {
            out.println("<persistence-type>Container</persistence-type>");
        } else {
            out.println("<persistence-type>Bean</persistence-type>");
        }
        String keyClass = classDoc.getAttribute("@ejb.pk", "class");
        if (keyClass == null) {
            out.println("<prim-key-class>java.lang.String</prim-key-class>");
        } else {
            out.println(new CharBuffer().append("<prim-key-class>").append(keyClass).append("</prim-key-class>").toString());
        }
        String reentrant = classDoc.getAttribute("@ejb.bean", "reentrant");
        if (reentrant == null) {
            out.println("<reentrant>False</reentrant>");
        } else if (reentrant.equals("True") || reentrant.equals("False")) {
            out.println(new CharBuffer().append("<reentrant>").append(reentrant).append("</reentrant>").toString());
        } else {
            throw this.error(classDoc, L.l("@ejb.bean reentrant='{0}' is an unknown value.  reentrant must either be `True' or `False'.", reentrant));
        }
        String schema = classDoc.getAttribute("@ejb.bean", "schema");
        if (schema != null) {
            out.println(new CharBuffer().append("<abstract-schema-name>").append(schema).append("</abstract-schema-name>").toString());
        }
    }

    public void generateCmpFields(JavaWriter out, ClassDocImpl classDoc) throws IOException, ConfigException {
        HashSet<String> fields = new HashSet<String>();
        ArrayList<MethodDocImpl> methodList = classDoc.getMethods();
        for (int i = 0; i < methodList.size(); ++i) {
            String fieldName;
            MethodDocImpl method = methodList.get(i);
            if (method.getTagList("@ejb.persistent-field") == null && method.getTagList("@ejb.persistence") == null || fields.contains(fieldName = this.getFieldName(method))) continue;
            out.println();
            out.println("<cmp-field>");
            out.pushDepth();
            fields.add(fieldName);
            out.println(new CharBuffer().append("<field-name>").append(fieldName).append("</field-name>").toString());
            String sqlColumn = method.getAttribute("@ejb.persistence", "column-name");
            if (sqlColumn == null) {
                sqlColumn = method.getAttribute("@resin-ejb.cmp-field", "sql-column");
            }
            if (sqlColumn != null) {
                out.println(new CharBuffer().append("<sql-column>").append(sqlColumn).append("</sql-column>").toString());
            }
            out.popDepth();
            out.println("</cmp-field>");
        }
        String primKeyField = classDoc.getAttribute("@ejb.bean", "primkey-field");
        if (primKeyField != null) {
            out.println();
            out.println(new CharBuffer().append("<primkey-field>").append(primKeyField).append("</primkey-field>").toString());
        }
    }

    public void generateCmpRelations(JavaWriter out, ClassDocImpl classDoc) throws IOException, ConfigException {
        ArrayList<MethodDocImpl> methodList = classDoc.getMethods();
        HashSet<String> fields = new HashSet<String>();
        for (int i = 0; i < methodList.size(); ++i) {
            String fieldName;
            MethodDocImpl method = methodList.get(i);
            if (method.getTagList("@ejb.relation") == null || fields.contains(fieldName = this.getFieldName(method))) continue;
            fields.add(fieldName);
            String relationName = method.getAttribute("@ejb.relation", "name");
            if (relationName == null) {
                throw this.error(method, L.l("`{0}' is missing an ejb.relation name", method.getName()));
            }
            String targetEJB = method.getAttribute("@ejb.relation", "target-ejb");
            DocletRelation rel = this._relations.get(relationName);
            String ejbName = classDoc.getAttribute("@ejb.bean", "name");
            boolean isSource = true;
            if (rel == null) {
                rel = new DocletRelation();
                rel.setName(relationName);
                this._relations.put(relationName, rel);
                isSource = true;
            } else {
                isSource = false;
            }
            if (targetEJB != null) {
                isSource = true;
                rel.setTargetEJB(targetEJB);
            }
            if (isSource) {
                rel.setSourceEJB(ejbName);
                rel.setSourceField(fieldName);
                continue;
            }
            rel.setTargetEJB(ejbName);
            rel.setTargetField(fieldName);
        }
    }

    public void generateCmpFind(JavaWriter out, ClassDocImpl classDoc) throws IOException, ConfigException {
        ArrayList<TagImpl> tagList = classDoc.getTagList("@ejb.finder");
        if (tagList == null) {
            return;
        }
        for (int i = 0; i < tagList.size(); ++i) {
            TagImpl tag = tagList.get(i);
            String signature = tag.getAttribute("signature");
            String query = tag.getAttribute("query");
            out.println();
            out.println("<query>");
            out.pushDepth();
            out.println(new CharBuffer().append("<query-method>").append(signature).append("</query-method>").toString());
            out.println(new CharBuffer().append("<ejb-ql><![CDATA[").append(query).append("]]></ejb-ql>").toString());
            out.popDepth();
            out.println("</query>");
        }
    }

    public void generateRelations(JavaWriter out) throws IOException, ConfigException {
        if (this._relations.size() == 0) {
            return;
        }
        out.println();
        out.println("<relationships>");
        out.pushDepth();
        Iterator<DocletRelation> iter = this._relations.values().iterator();
        while (iter.hasNext()) {
            DocletRelation rel = iter.next();
            out.println();
            out.println("<ejb-relation>");
            out.pushDepth();
            out.println("<ejb-relationship-role>");
            out.pushDepth();
            out.println("<relationship-role-source>");
            out.pushDepth();
            out.println(new CharBuffer().append("<ejb-name>").append(rel.getSourceEJB()).append("</ejb-name>").toString());
            out.popDepth();
            out.println("</relationship-role-source>");
            out.println("<cmr-field>");
            out.pushDepth();
            out.println(new CharBuffer().append("<cmr-field-name>").append(rel.getSourceField()).append("</cmr-field-name>").toString());
            out.popDepth();
            out.println("</cmr-field>");
            out.popDepth();
            out.println("</ejb-relationship-role>");
            out.println();
            out.println("<ejb-relationship-role>");
            out.pushDepth();
            out.println("<relationship-role-source>");
            out.pushDepth();
            out.println(new CharBuffer().append("<ejb-name>").append(rel.getTargetEJB()).append("</ejb-name>").toString());
            out.popDepth();
            out.println("</relationship-role-source>");
            if (rel.getTargetField() != null) {
                out.println("<cmr-field>");
                out.pushDepth();
                out.println(new CharBuffer().append("<cmr-field-name>").append(rel.getTargetField()).append("</cmr-field-name>").toString());
                out.popDepth();
                out.println("</cmr-field>");
            }
            out.popDepth();
            out.println("</ejb-relationship-role>");
            out.popDepth();
            out.println("</ejb-relation>");
        }
        out.popDepth();
        out.println("</relationships>");
    }

    private String getFieldName(MethodDocImpl method) {
        String name = method.getName();
        return BeanUtil.methodNameToPropertyName(name);
    }

    private String escape(String string) {
        CharBuffer cb = CharBuffer.allocate();
        block5: for (int i = 0; i < string.length(); ++i) {
            char ch = string.charAt(i);
            switch (ch) {
                case '<': {
                    cb.append("&lt;");
                    continue block5;
                }
                case '>': {
                    cb.append("&gt;");
                    continue block5;
                }
                case '&': {
                    cb.append("&amp;");
                    continue block5;
                }
                default: {
                    cb.append(ch);
                }
            }
        }
        return cb.close();
    }

    private ConfigException error(DocImpl loc, String msg) {
        if (loc == null) {
            return new ConfigException(msg);
        }
        if (loc.getPosition() == null) {
            return new ConfigException(new CharBuffer().append(loc.getName()).append(": ").append(msg).toString());
        }
        return new LineConfigException(new CharBuffer().append(loc.getPosition()).append(msg).toString());
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.ejb.doclet.EjbJarGenerator");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

