/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.doclet;

import com.caucho.doclet.ClassDocImpl;
import com.caucho.doclet.DocletCompiler;
import com.caucho.doclet.RootDocImpl;
import com.caucho.doclet.TagImpl;
import com.caucho.ejb.doclet.EjbHomeGenerator;
import com.caucho.ejb.doclet.EjbJarGenerator;
import com.caucho.ejb.doclet.EjbObjectGenerator;
import com.caucho.log.Log;
import com.caucho.make.Make;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbDocletTask
implements Make {
    private static final L10N L = new L10N(EjbDocletTask._resin_compat_class_0());
    private static final Logger log = Log.open(EjbDocletTask._resin_compat_class_0());
    private Path _srcdir;
    private Path _dstdir;
    private boolean _isComplete;
    private static Class _resin_compat_class_0;

    public void setSrcdir(Path path) {
        this._srcdir = path;
    }

    public void setDstdir(Path path) {
        this._dstdir = path;
    }

    @Override
    public void make() throws Exception {
        Path srcDir;
        Path dstDir = this._dstdir;
        if (dstDir == null) {
            dstDir = Vfs.lookup("WEB-INF/classes");
        }
        if ((srcDir = this._srcdir) == null) {
            srcDir = dstDir;
        }
        ArrayList<String> paths = new ArrayList<String>();
        this.gatherPaths(paths, srcDir);
        DocletCompiler doclet = new DocletCompiler();
        if (!this._isComplete) {
            this._isComplete = true;
            RootDocImpl rootDoc = doclet.run(srcDir, paths);
            ArrayList<ClassDocImpl> entityClasses = new ArrayList<ClassDocImpl>();
            Collection<ClassDocImpl> classes = rootDoc.getClasses();
            for (ClassDocImpl classDoc : classes) {
                if (!classDoc.isAssignableTo("javax.ejb.EntityBean")) continue;
                if (classDoc.getTagList("@ejb.bean") == null) {
                    log.fine(L.l("`{0}' is not an XDoclet bean", classDoc.getName()));
                    continue;
                }
                String generate = classDoc.getAttribute("@ejb.bean", "generate");
                if ("false".equals(generate)) continue;
                entityClasses.add(classDoc);
            }
            if (entityClasses.size() == 0) {
                return;
            }
            new EjbJarGenerator().generate(Vfs.lookup("WEB-INF/xdoclet.ejb"), rootDoc);
            for (int i = 0; i < entityClasses.size(); ++i) {
                this.generateEntity(srcDir, dstDir, (ClassDocImpl)entityClasses.get(i));
            }
        }
    }

    private void generateEntity(Path srcDir, Path destDir, ClassDocImpl classDoc) throws Exception {
        String className = classDoc.getName();
        Path beanPath = srcDir.lookup(new CharBuffer().append(className.replace('.', '/')).append(".java").toString());
        ArrayList<TagImpl> homeList = classDoc.getTagList("@ejb.home");
        for (int i = 0; homeList != null && i < homeList.size(); ++i) {
            Path path;
            TagImpl homeTag = homeList.get(i);
            String homeClass = homeTag.getAttribute("local-class");
            if (homeClass == null || (path = destDir.lookup(new CharBuffer().append(homeClass.replace('.', '/')).append(".java").toString())).getLastModified() >= beanPath.getLastModified()) continue;
            log.finer(new CharBuffer().append("generating ").append(homeClass).toString());
            EjbHomeGenerator gen = new EjbHomeGenerator(classDoc);
            gen.setLocal(true);
            gen.setClassName(homeClass);
            gen.generate(path);
        }
        ArrayList<TagImpl> objectList = classDoc.getTagList("@ejb.interface");
        for (int i = 0; objectList != null && i < objectList.size(); ++i) {
            Path path;
            TagImpl objectTag = objectList.get(i);
            String objectClass = objectTag.getAttribute("local-class");
            if (objectClass == null || (path = destDir.lookup(new CharBuffer().append(objectClass.replace('.', '/')).append(".java").toString())).getLastModified() >= beanPath.getLastModified()) continue;
            log.finer(new CharBuffer().append("generating ").append(objectClass).toString());
            EjbObjectGenerator gen = new EjbObjectGenerator(classDoc);
            gen.setLocal(true);
            gen.setClassName(objectClass);
            gen.generate(path);
        }
    }

    public void gatherPaths(ArrayList<String> paths, Path srcDir) throws Exception {
        String[] list = srcDir.list();
        for (int i = 0; i < list.length; ++i) {
            Path subSrc = srcDir.lookup(list[i]);
            if (subSrc.isDirectory()) {
                this.gatherPaths(paths, subSrc);
                continue;
            }
            if (!list[i].endsWith("Bean.java")) continue;
            paths.add(subSrc.getNativePath());
        }
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.ejb.doclet.EjbDocletTask");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

