/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.cfg;

import com.caucho.bytecode.JMethod;
import com.caucho.config.ConfigException;
import com.caucho.ejb.cfg.EjbEntityBean;
import com.caucho.ejb.cfg.MethodSignature;
import com.caucho.ejb.cfg.QueryMethod;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.util.ArrayList;

public class Query {
    private static L10N L = new L10N(Query._resin_compat_class_0());
    private EjbEntityBean _entity;
    private String _location;
    private String _description;
    private MethodSignature _signature;
    private String methodName;
    private String methodIntf;
    private Object value;
    private String _ejbQL;
    private ArrayList paramTypes;
    private static Class _resin_compat_class_0;

    public Query(EjbEntityBean entity) {
        this._entity = entity;
    }

    public void setConfigLocation(String filename, int line) {
        if (filename != null) {
            this._location = new CharBuffer().append(filename).append(':').append(line).append(": ").toString();
        }
    }

    public String getConfigLocation() {
        return this._location;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public void setQueryMethod(QueryMethod queryMethod) throws ConfigException {
        this._signature = queryMethod.getSignature();
        String methodName = this._signature.getName();
        if (methodName.equals("findByPrimaryKey")) {
            throw new ConfigException(L.l("'findByPrimaryKey' can't be defined in a query."));
        }
        if (methodName.startsWith("find")) {
            JMethod method = EjbEntityBean.findMethod(this._signature, this._entity.getRemoteHome(), "home");
            if (method == null) {
                method = EjbEntityBean.findMethod(this._signature, this._entity.getLocalHome(), "local-home");
            }
            if (method == null) {
                throw new ConfigException(L.l("Query method '{0}' must be defined in either the <home> or <local-home>.", this._signature.toSignatureString()));
            }
        } else if (methodName.startsWith("ejbSelect")) {
            JMethod method = EjbEntityBean.findMethod(this._signature, this._entity.getEJBClassWrapper(), null);
            if (method == null) {
                throw new ConfigException(L.l("{0}: Query method '{1}' must be defined.", (Object)this._entity.getEJBClass().getName(), this._signature.toSignatureString()));
            }
        } else {
            throw new ConfigException(L.l("'{0}' is an invalid method name for an ejb-ql query.  Only findXXX and ejbSelectXXX methods have queries.", methodName));
        }
    }

    public MethodSignature getSignature() {
        return this._signature;
    }

    public void setEjbQl(String ejbQL) {
        this._ejbQL = ejbQL;
    }

    public String getEjbQl() {
        return this._ejbQL;
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.ejb.cfg.MethodSignature");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

