/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.cfg;

import com.caucho.bytecode.JClass;
import com.caucho.bytecode.JMethod;
import com.caucho.config.ConfigException;
import com.caucho.ejb.cfg.EjbBean;
import com.caucho.ejb.cfg.EjbMethod;
import com.caucho.ejb.cfg.EjbMethodPattern;
import com.caucho.ejb.gen.BeanAssembler;
import com.caucho.ejb.gen.ViewClass;
import com.caucho.java.gen.CallChain;
import com.caucho.log.Log;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbView {
    private static final Logger log = Log.open(EjbView._resin_compat_class_1());
    private static final L10N L = new L10N(EjbView._resin_compat_class_1());
    private EjbBean _bean;
    private JClass _apiClass;
    private String _prefix;
    private HashMap<String, EjbMethod> _methodMap = new HashMap();
    private static Class _resin_compat_class_0;
    private static Class _resin_compat_class_1;

    public EjbView(EjbBean bean, JClass apiClass, String prefix) throws ConfigException {
        this._bean = bean;
        this._apiClass = apiClass;
        this._prefix = prefix;
    }

    protected EjbBean getBean() {
        return this._bean;
    }

    protected JClass getApiClass() {
        return this._apiClass;
    }

    protected JClass getImplClass() {
        return this._bean.getEJBClassWrapper();
    }

    protected String getPrefix() {
        return this._prefix;
    }

    protected boolean isLocal() {
        return "Local".equals(this._prefix);
    }

    public ArrayList<EjbMethod> getMethods() {
        ArrayList<EjbMethod> methods = new ArrayList<EjbMethod>();
        methods.addAll(this._methodMap.values());
        return methods;
    }

    protected void introspect() throws ConfigException {
        JMethod[] implMethods = EjbBean.getMethods(this.getImplClass());
        for (int i = 0; i < implMethods.length; ++i) {
            JMethod method = implMethods[i];
            EjbMethod ejbMethod = null;
            String name = method.getName();
            if (JClass.OBJECT.getMethod(name, method.getParameterTypes()) == null || name.equals("toString")) {
                ejbMethod = name.startsWith("ejb") ? this.introspectEJBMethod(method) : this.introspectBusinessMethod(method);
            }
            if (ejbMethod == null) continue;
            this._methodMap.put(EjbView.getFullMethodName(ejbMethod.getApiMethod()), ejbMethod);
        }
        JMethod[] apiMethods = EjbBean.getMethods(this._apiClass);
        for (int i = 0; i < apiMethods.length; ++i) {
            EjbMethod ejbMethod;
            JMethod method = apiMethods[i];
            if (method.getDeclaringClass().getName().startsWith("javax.ejb") || JClass.OBJECT.getMethod(method.getName(), method.getParameterTypes()) != null || (ejbMethod = this._methodMap.get(EjbView.getFullMethodName(method))) != null || (ejbMethod = this.introspectApiMethod(method)) == null) continue;
            this._methodMap.put(EjbView.getFullMethodName(ejbMethod.getApiMethod()), ejbMethod);
            this.validateApiMethod(ejbMethod.getApiMethod());
        }
    }

    protected EjbMethod introspectEJBMethod(JMethod method) throws ConfigException {
        return null;
    }

    protected EjbMethod introspectBusinessMethod(JMethod implMethod) throws ConfigException {
        JMethod apiMethod = EjbBean.getMethod(this._apiClass, implMethod.getName(), implMethod.getParameterTypes());
        if (apiMethod == null) {
            return null;
        }
        return this.createBusinessMethod(apiMethod, implMethod);
    }

    protected EjbMethod createBusinessMethod(JMethod apiMethod, JMethod implMethod) throws ConfigException {
        this.validateImplMethod(implMethod);
        return new EjbMethod(this, apiMethod, implMethod);
    }

    protected void validateImplMethod(JMethod implMethod) throws ConfigException {
        if (!implMethod.isPublic()) {
            throw this.error(L.l("{0}: `{1}' must be public.  Business method implementations must be public.", (Object)implMethod.getDeclaringClass().getName(), EjbView.getFullMethodName(implMethod)));
        }
        if (implMethod.isStatic()) {
            throw this.error(L.l("{0}: `{1}' must not be static.  Business method implementations must not be static.", (Object)implMethod.getDeclaringClass().getName(), EjbView.getFullMethodName(implMethod)));
        }
        if (implMethod.isAbstract()) {
            throw this.error(L.l("{0}: `{1}' must not be abstract.  Business methods must be implemented.", (Object)implMethod.getDeclaringClass().getName(), EjbView.getFullMethodName(implMethod)));
        }
    }

    protected EjbMethod introspectApiMethod(JMethod apiMethod) throws ConfigException {
        if (apiMethod.getName().startsWith("ejb")) {
            throw this.error(L.l("{0}: '{1}' must not start with 'ejb'. The EJB spec reserves all methods starting with ejb.", (Object)apiMethod.getDeclaringClass().getName(), EjbView.getFullMethodName(apiMethod)));
        }
        throw this.errorMissingMethod(this.getImplClass(), apiMethod.getName(), apiMethod);
    }

    protected void validateApiMethod(JMethod apiMethod) throws ConfigException {
        if ("Remote".equals(this._prefix)) {
            this.validateException(apiMethod, EjbView._resin_compat_class_0());
        }
    }

    protected ConfigException errorMissingMethod(JClass expectedClass, String expectedName, JMethod matchMethod) {
        return this.error(L.l("{0}: missing `{1}' method needed to match {2}.{3}", expectedClass.getName(), EjbView.getFullMethodName(expectedName, matchMethod.getParameterTypes()), EjbView.getShortClassName(matchMethod.getDeclaringClass()), EjbView.getFullMethodName(matchMethod)));
    }

    protected void assembleView(BeanAssembler assembler, String fullClassName) throws ConfigException {
    }

    protected void assembleMethods(BeanAssembler assembler, ViewClass viewClass, String fullClassName) throws ConfigException {
        ArrayList<EjbMethod> methods = this.getMethods();
        for (int i = 0; i < methods.size(); ++i) {
            EjbMethod method = methods.get(i);
            method.assembleBean(assembler, fullClassName);
            viewClass.addMethod(method.assemble(viewClass, fullClassName));
        }
    }

    protected EjbMethodPattern findMethodPattern(JMethod apiMethod, String prefix) {
        return this._bean.getMethodPattern(apiMethod, prefix);
    }

    protected CallChain getTransactionChain(CallChain callChain, JMethod apiMethod, String prefix) {
        return this._bean.getTransactionChain(callChain, apiMethod, prefix);
    }

    protected CallChain getSecurityChain(CallChain callChain, JMethod apiMethod, String prefix) {
        return this._bean.getSecurityChain(callChain, apiMethod, prefix);
    }

    protected void validateException(JMethod method, Class exn) throws ConfigException {
        this._bean.validateException(method, exn);
    }

    protected void validateException(JMethod method, JClass exn) throws ConfigException {
        this._bean.validateException(method, exn);
    }

    protected void validateExceptions(JMethod method, JClass[] exn) throws ConfigException {
        this._bean.validateExceptions(method, exn);
    }

    static String getClassName(Class cl) {
        if (cl != null) {
            return cl.getName();
        }
        return null;
    }

    static String getFullMethodName(JMethod method) {
        return EjbBean.getFullMethodName(method);
    }

    static String getFullMethodName(String methodName, JClass[] paramTypes) {
        return EjbBean.getFullMethodName(methodName, paramTypes);
    }

    static String getShortClassName(JClass cl) {
        return EjbBean.getShortClassName(cl);
    }

    public ConfigException error(String msg) {
        return new ConfigException(msg);
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("java.rmi.RemoteException");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_1() {
        try {
            Class<?> clazz = _resin_compat_class_1;
            if (clazz == null) {
                clazz = _resin_compat_class_1 = Class.forName("com.caucho.ejb.cfg.EjbView");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

