/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.cfg;

import com.caucho.amber.AmberManager;
import com.caucho.amber.field.AmberField;
import com.caucho.amber.field.EntityOneToManyField;
import com.caucho.amber.field.Id;
import com.caucho.amber.table.Column;
import com.caucho.amber.table.ForeignColumn;
import com.caucho.amber.table.LinkColumns;
import com.caucho.amber.type.EntityType;
import com.caucho.bytecode.JClass;
import com.caucho.bytecode.JMethod;
import com.caucho.config.ConfigException;
import com.caucho.ejb.cfg.CmpField;
import com.caucho.ejb.cfg.CmrManyToOne;
import com.caucho.ejb.cfg.CmrRelation;
import com.caucho.ejb.cfg.EjbEntityBean;
import com.caucho.ejb.cfg.EjbMethod;
import com.caucho.ejb.cfg.EjbOneToManyMethod;
import com.caucho.ejb.cfg.EjbView;
import com.caucho.ejb.cfg.SqlRelation;
import com.caucho.ejb.ql.QLParser;
import com.caucho.java.JavaWriter;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

public class CmrOneToMany
extends CmrRelation {
    private static final L10N L = new L10N(CmrOneToMany._resin_compat_class_0());
    private EjbEntityBean _targetBean;
    private String _targetField;
    private ArrayList<String> _orderByFields;
    private ArrayList<Boolean> _orderByAscending;
    private SqlRelation[] _sqlColumns;
    private EntityOneToManyField _amberOneToMany;
    private static Class _resin_compat_class_0;

    public CmrOneToMany(EjbEntityBean entityBean, String fieldName, EjbEntityBean targetBean, String targetField) throws ConfigException {
        super(entityBean, fieldName);
        this._targetBean = targetBean;
        this._targetField = targetField;
    }

    public EjbEntityBean getTargetBean() {
        return this._targetBean;
    }

    public JClass getTargetType() {
        return this._targetBean.getLocal();
    }

    public void setSQLColumns(SqlRelation[] columns) {
        this._sqlColumns = columns;
    }

    public SqlRelation[] getSQLColumns() {
        return this._sqlColumns;
    }

    public void setOrderBy(String orderBySQL) throws ConfigException {
        if (orderBySQL != null) {
            ArrayList<String> fields = new ArrayList<String>();
            ArrayList<Boolean> asc = new ArrayList<Boolean>();
            QLParser.parseOrderBy(this._targetBean, orderBySQL, fields, asc);
            this._orderByFields = fields;
            this._orderByAscending = asc;
        }
    }

    public boolean isCollection() {
        return true;
    }

    public EjbMethod createGetter(EjbView view, JMethod apiMethod, JMethod implMethod) throws ConfigException {
        return new EjbOneToManyMethod(view, apiMethod, implMethod, this);
    }

    public AmberField assembleAmber(EntityType type) throws ConfigException {
        EntityOneToManyField oneToMany = new EntityOneToManyField(type, this.getName());
        AmberManager manager = type.getAmberManager();
        EntityType targetType = this._targetBean.getEntityType();
        oneToMany.setType(targetType);
        oneToMany.setOrderBy(this._orderByFields, this._orderByAscending);
        this._amberOneToMany = oneToMany;
        return oneToMany;
    }

    public void linkAmber() throws ConfigException {
        CmrManyToOne manyToOne = (CmrManyToOne)this.getTargetRelation();
        this._amberOneToMany.setSourceField(manyToOne.getAmberManyToOne());
        this._amberOneToMany.setLinkColumns(manyToOne.getAmberManyToOne().getLinkColumns());
        this._amberOneToMany.init();
    }

    public void generateAfterCommit(JavaWriter out) throws IOException {
        if (this.getHasGetter()) {
            out.println(new CharBuffer().append("__caucho_").append(this.getName()).append(" = null;").toString());
        }
    }

    private LinkColumns calculateColumn(EntityType parentType, EntityType childType, String fieldName, SqlRelation[] sqlColumns) throws ConfigException {
        Id id = parentType.getId();
        ArrayList<Column> keys = new ArrayList<Column>(id.getColumns());
        ArrayList<ForeignColumn> columns = new ArrayList<ForeignColumn>();
        if (this._sqlColumns != null && this._sqlColumns.length == keys.size()) {
            for (int i = 0; i < keys.size(); ++i) {
                Column key = keys.get(i);
                String sqlColumn = this.getColumn(this._sqlColumns, key.getName());
                ForeignColumn column = childType.getTable().createForeignColumn(sqlColumn, key);
                columns.add(column);
            }
        } else if (this._sqlColumns != null && this._sqlColumns.length == 1) {
            String baseSqlColumn = this._sqlColumns[0].getSQLColumn();
            Iterator<Column> i$ = keys.iterator();
            while (i$.hasNext()) {
                Column key = i$.next();
                String sqlColumn = new CharBuffer().append(baseSqlColumn).append("_").append(key.getName()).toString();
                ForeignColumn column = childType.getTable().createForeignColumn(sqlColumn, key);
                columns.add(column);
            }
        } else {
            if (this._sqlColumns != null && this._sqlColumns.length > 0) {
                throw new IllegalStateException("Mismatched SQL columns");
            }
            if (keys.size() == 1) {
                Column key = keys.get(0);
                String sqlColumn = CmpField.toSqlName(fieldName);
                ForeignColumn column = childType.getTable().createForeignColumn(sqlColumn, key);
                columns.add(column);
            } else {
                String baseSqlColumn = CmpField.toSqlName(fieldName);
                Iterator<Column> i$ = keys.iterator();
                while (i$.hasNext()) {
                    Column key = i$.next();
                    String sqlColumn = new CharBuffer().append(baseSqlColumn).append("_").append(key.getName()).toString();
                    ForeignColumn foreignColumn = childType.getTable().createForeignColumn(sqlColumn, key);
                    columns.add(foreignColumn);
                }
            }
        }
        return new LinkColumns(childType.getTable(), parentType.getTable(), columns);
    }

    private String getColumn(SqlRelation[] sqlColumns, String fieldName) throws ConfigException {
        if (sqlColumns.length == 1) {
            return sqlColumns[0].getSQLColumn();
        }
        for (int i = 0; i < sqlColumns.length; ++i) {
            String ref = sqlColumns[i].getReferences();
            if (ref == null) {
                throw new ConfigException(L.l("sql-column '{0}' needs a references attribute.", sqlColumns[i].getSQLColumn()));
            }
            if (!ref.equals(fieldName)) continue;
            return sqlColumns[i].getSQLColumn();
        }
        throw new ConfigException(L.l("key '{0}' has no matching sql-column", fieldName));
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.ejb.cfg.CmrOneToMany");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

