/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.cfg;

import com.caucho.amber.AmberManager;
import com.caucho.amber.field.IdField;
import com.caucho.amber.field.KeyPropertyField;
import com.caucho.amber.table.Column;
import com.caucho.amber.type.EntityType;
import com.caucho.amber.type.Type;
import com.caucho.bytecode.JClass;
import com.caucho.bytecode.JMethod;
import com.caucho.config.ConfigException;
import com.caucho.ejb.cfg.CmpProperty;
import com.caucho.ejb.cfg.EjbEntityBean;
import com.caucho.jdbc.JdbcMetaData;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;

public class CmpField
extends CmpProperty {
    private static final L10N L = new L10N(CmpField._resin_compat_class_2());
    private String _sqlColumn;
    private String _abstractSQLType;
    private String _sqlType;
    private boolean _isAutoGenerate = true;
    private JClass _javaType = JClass.STRING;
    private static Class _resin_compat_class_0;
    private static Class _resin_compat_class_1;
    private static Class _resin_compat_class_2;

    public CmpField(EjbEntityBean entity) {
        super(entity);
    }

    public String getSQLColumn() {
        return this._sqlColumn;
    }

    public void setSQLColumn(String sqlColumn) {
        this._sqlColumn = sqlColumn;
    }

    public String getSQLType() {
        return this._sqlType;
    }

    public void setSQLType(String sqlType) {
        this._sqlType = sqlType;
    }

    public String getAbstractSQLType() {
        return this._abstractSQLType;
    }

    public void setAbstractSQLType(String sqlType) {
        this._abstractSQLType = sqlType;
    }

    public void setJavaType(JClass javaType) {
        this._javaType = javaType;
    }

    public JClass getJavaType() {
        return this._javaType;
    }

    public void setAutoGenerate(boolean isAutoGenerate) {
        this._isAutoGenerate = isAutoGenerate;
    }

    public boolean isAutoGenerate() {
        return this._isAutoGenerate;
    }

    public void init() throws ConfigException {
        if (this.getEntity().isCMP1()) {
            return;
        }
        String name = this.getName();
        String getterName = new CharBuffer().append("get").append(Character.toUpperCase(name.charAt(0))).append(name.substring(1)).toString();
        this.getEntity();
        JMethod getter = EjbEntityBean.getMethod(this.getEntity().getEJBClassWrapper(), getterName, new JClass[0]);
        if (getter == null) {
            throw new ConfigException(L.l("{0}: '{1}' is an unknown cmp-field.  cmp-fields must have matching getter methods.", (Object)this.getEntity().getEJBClass().getName(), name));
        }
        if (!getter.isPublic()) {
            throw new ConfigException(L.l("{0}: '{1}' must be public.  cmp-fields getters must be public.", (Object)this.getEntity().getEJBClass().getName(), getter.getFullName()));
        }
        if (!getter.isAbstract() && !this.getEntity().isAllowPOJO()) {
            throw new ConfigException(L.l("{0}: '{1}' must be abstract.  cmp-fields getters must be abstract.", (Object)this.getEntity().getEJBClass().getName(), getter.getFullName()));
        }
        if (getter.getExceptionTypes().length != 0) {
            throw new ConfigException(L.l("{0}: '{1}' must not throw {2}.  Container managed fields and relations must not throw exceptions.", this.getEntity().getEJBClass().getName(), getter.getFullName(), getter.getExceptionTypes()[0].getName()));
        }
        this._javaType = getter.getReturnType();
        if ("void".equals(this._javaType.getName())) {
            throw new ConfigException(L.l("{0}: '{1}' must not return void.  CMP fields must not return void.", (Object)this.getEntity().getEJBClass().getName(), this.getName()));
        }
        if (this._javaType.isAssignableTo(CmpField._resin_compat_class_0())) {
            throw new ConfigException(L.l("{0}: '{1}' must not return an EJB interface.  CMP fields must return concrete values.", (Object)this.getEntity().getEJBClass().getName(), this.getName()));
        }
        if (this._javaType.isAssignableTo(CmpField._resin_compat_class_1())) {
            throw new ConfigException(L.l("{0}: '{1}' must not return an EJB interface.  CMP fields must return concrete values.", (Object)this.getEntity().getEJBClass().getName(), this.getName()));
        }
        String setterName = new CharBuffer().append("set").append(Character.toUpperCase(name.charAt(0))).append(name.substring(1)).toString();
        this.getEntity();
        JMethod setter = EjbEntityBean.getMethod(this.getEntity().getEJBClassWrapper(), setterName, new JClass[]{getter.getReturnType()});
        if (setter != null) {
            if (!setter.isPublic()) {
                throw new ConfigException(L.l("{0}: '{1}' must be public.  cmp-fields setters must be public.", (Object)this.getEntity().getEJBClass().getName(), setter.getFullName()));
            }
            if (!"void".equals(setter.getReturnType().getName())) {
                throw new ConfigException(L.l("{0}: '{1}' must return void.  cmp-fields setters must return void.", (Object)this.getEntity().getEJBClass().getName(), setter.getFullName()));
            }
            if (!setter.isAbstract() && !this.getEntity().isAllowPOJO()) {
                throw new ConfigException(L.l("{0}: '{1}' must be abstract.  cmp-fields setters must be abstract.", (Object)this.getEntity().getEJBClass().getName(), setter.getFullName()));
            }
            if (setter.getExceptionTypes().length != 0) {
                throw new ConfigException(L.l("{0}: '{1}' must not throw {2}.  Container managed fields and relations must not throw exceptions.", this.getEntity().getEJBClass().getName(), setter.getFullName(), setter.getExceptionTypes()[0].getName()));
            }
        }
        if (this._sqlColumn == null) {
            this._sqlColumn = CmpField.toSqlName(this.getName());
        }
    }

    public IdField createId(AmberManager amberManager, EntityType type) throws ConfigException {
        JClass dataType;
        String fieldName = this.getName();
        String sqlName = this.getSQLColumn();
        if (sqlName == null) {
            sqlName = CmpField.toSqlName(fieldName);
        }
        if ((dataType = this.getJavaType()) == null) {
            throw new NullPointerException(L.l("'{0}' is an unknown field", fieldName));
        }
        Type amberType = amberManager.createType(dataType);
        Column column = type.getTable().createColumn(sqlName, amberType);
        KeyPropertyField idField = new KeyPropertyField(type, fieldName, column);
        if (this.isAutoGenerate() && ("int".equals(dataType.getName()) || "long".equals(dataType.getName()) || "java.lang.Integer".equals(dataType.getName()) || "java.lang.Long".equals(dataType.getName()))) {
            JdbcMetaData metaData = amberManager.getMetaData();
            if (metaData.supportsIdentity()) {
                idField.setGenerator("identity");
                column.setGeneratorType("identity");
            } else if (metaData.supportsSequences()) {
                idField.setGenerator("sequence");
                column.setGeneratorType("sequence");
                String name = new CharBuffer().append(type.getTable().getName()).append("_cseq").toString();
                type.setGenerator(idField.getName(), amberManager.createSequenceGenerator(name, 10));
            }
        }
        return idField;
    }

    static String toSqlName(String name) {
        CharBuffer cb = new CharBuffer();
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (!Character.isUpperCase(ch)) {
                cb.append(ch);
                continue;
            }
            if (i > 0 && !Character.isUpperCase(name.charAt(i - 1))) {
                cb.append("_");
                cb.append(Character.toLowerCase(ch));
                continue;
            }
            if (i + 1 < name.length() && !Character.isUpperCase(name.charAt(i + 1))) {
                cb.append("_");
                cb.append(Character.toLowerCase(ch));
                continue;
            }
            cb.append(Character.toLowerCase(ch));
        }
        return cb.toString();
    }

    public String toString() {
        return new CharBuffer().append("CmpField[").append(this.getName()).append("]").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("javax.ejb.EJBLocalObject");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_1() {
        try {
            Class<?> clazz = _resin_compat_class_1;
            if (clazz == null) {
                clazz = _resin_compat_class_1 = Class.forName("javax.ejb.EJBObject");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_2() {
        try {
            Class<?> clazz = _resin_compat_class_2;
            if (clazz == null) {
                clazz = _resin_compat_class_2 = Class.forName("com.caucho.ejb.cfg.CmpProperty");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

