/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.burlap;

import com.caucho.ejb.burlap.BurlapClientContainer;
import com.caucho.ejb.burlap.BurlapWriter;
import com.caucho.hessian.io.HessianRemoteObject;
import com.caucho.hessian.io.HessianRemoteResolver;
import com.caucho.log.Log;
import com.caucho.util.CharBuffer;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.ReadWritePair;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class BurlapStub
implements HessianRemoteObject {
    private static final Logger log = Log.open(BurlapStub._resin_compat_class_0());
    protected String _url;
    protected transient Path _urlPath;
    protected transient BurlapClientContainer _client;
    protected transient HessianRemoteResolver _resolver;
    private static Class _resin_compat_class_0;

    void _init(String url, BurlapClientContainer client) {
        this._url = url;
        this._urlPath = Vfs.lookup(url);
        this._burlap_setClientContainer(client);
        if (log.isLoggable(Level.FINER)) {
            log.finer(new CharBuffer().append("burlap stub:").append(this._urlPath).append(" ").append(this).toString());
        }
    }

    public String getHessianURL() {
        return this._url;
    }

    void _burlap_setURLPath(Path urlPath) {
        this._urlPath = urlPath;
        if (log.isLoggable(Level.FINER)) {
            log.finer(new CharBuffer().append("burlap setURL:").append(this._urlPath).append(" ").append(this).toString());
        }
        this._url = this._urlPath.getURL();
    }

    void _burlap_setClientContainer(HessianRemoteResolver resolver) {
        this._resolver = resolver;
        if (resolver instanceof BurlapClientContainer) {
            this._client = (BurlapClientContainer)resolver;
        }
    }

    protected BurlapWriter _burlap_openWriter() throws RemoteException {
        try {
            String auth;
            ReadWritePair pair = this._urlPath.openReadWrite();
            ReadStream is = pair.getReadStream();
            WriteStream os = pair.getWriteStream();
            if (this._client != null && (auth = this._client.getBasicAuthentication()) != null) {
                os.setAttribute("Authorization", auth);
            }
            BurlapWriter out = new BurlapWriter(is, os);
            out.setRemoteResolver(this._resolver);
            return out;
        }
        catch (IOException e) {
            throw new RemoteException(String.valueOf(e));
        }
    }

    protected void _burlap_freeWriter(BurlapWriter out) throws IOException {
        out.close();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.ejb.burlap.BurlapStub");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

