/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.burlap;

import com.caucho.burlap.io.BurlapRemoteResolver;
import com.caucho.config.ConfigException;
import com.caucho.ejb.AbstractServer;
import com.caucho.ejb.EJBExceptionWrapper;
import com.caucho.ejb.burlap.BurlapHandle;
import com.caucho.ejb.burlap.BurlapHandleEncoder;
import com.caucho.ejb.burlap.BurlapHomeHandle;
import com.caucho.ejb.burlap.BurlapStub;
import com.caucho.ejb.burlap.HomeStub;
import com.caucho.ejb.burlap.MetaStub;
import com.caucho.ejb.burlap.ObjectStub;
import com.caucho.ejb.burlap.StubGenerator;
import com.caucho.ejb.protocol.EjbProtocolManager;
import com.caucho.ejb.protocol.HandleEncoder;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import java.io.IOException;
import java.util.Hashtable;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;

class BurlapClientContainer
implements BurlapRemoteResolver {
    protected static L10N L = new L10N(BurlapClientContainer._resin_compat_class_0());
    private static EnvironmentLocal burlapClient = new EnvironmentLocal("caucho.burlap.client");
    private String serverId;
    private BurlapHandleEncoder handleEncoder;
    EJBHome ejbHome;
    Class homeClass;
    Class remoteClass;
    Class homeStubClass;
    Class remoteStubClass;
    Class primaryKeyClass;
    private String _basicAuth;
    private static Class _resin_compat_class_0;

    BurlapClientContainer(String serverId) throws ConfigException {
        this.serverId = serverId;
        this.remoteStubClass = this.getRemoteStubClass();
        this.homeStubClass = this.getHomeStubClass();
    }

    static BurlapClientContainer find(String serverId) {
        try {
            Hashtable<String, BurlapClientContainer> map = (Hashtable<String, BurlapClientContainer>)burlapClient.getLevel();
            BurlapClientContainer client = null;
            if (map != null) {
                client = (BurlapClientContainer)map.get(serverId);
            }
            if (client == null) {
                client = new BurlapClientContainer(serverId);
                if (map == null) {
                    map = new Hashtable<String, BurlapClientContainer>();
                }
                map.put(serverId, client);
                burlapClient.set(map);
            }
            return client;
        }
        catch (Exception e) {
            throw EJBExceptionWrapper.createRuntime(e);
        }
    }

    protected EJBHome getHomeStub() throws ConfigException {
        try {
            HomeStub homeStub = (HomeStub)this.homeStubClass.newInstance();
            homeStub._init(this.serverId, this);
            return homeStub;
        }
        catch (IllegalAccessException e) {
            throw new ConfigException(e);
        }
        catch (InstantiationException e) {
            throw new ConfigException(e);
        }
    }

    protected EJBObject createObjectStub(String url) throws ConfigException {
        try {
            ObjectStub objStub = (ObjectStub)this.remoteStubClass.newInstance();
            objStub._init(url, this);
            return objStub;
        }
        catch (IllegalAccessException e) {
            throw new ConfigException(e);
        }
        catch (InstantiationException e) {
            throw new ConfigException(e);
        }
    }

    BurlapHomeHandle getHomeHandle() {
        return new BurlapHomeHandle(this.ejbHome, this.serverId);
    }

    BurlapHandle createHandle(String url) {
        return new BurlapHandle(url);
    }

    public HandleEncoder getHandleEncoder() {
        try {
            if (this.handleEncoder == null) {
                this.handleEncoder = new BurlapHandleEncoder(null, this.serverId, this.getPrimaryKeyClass());
            }
            return this.handleEncoder;
        }
        catch (Exception e) {
            throw EJBExceptionWrapper.createRuntime(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Class getHomeStubClass() throws ConfigException {
        if (this.homeStubClass != null) {
            return this.homeStubClass;
        }
        BurlapClientContainer burlapClientContainer = this;
        synchronized (burlapClientContainer) {
            if (this.homeStubClass != null) {
                return this.homeStubClass;
            }
            StubGenerator gen = new StubGenerator();
            this.homeStubClass = gen.createHomeStub(this.getHomeClass());
        }
        return this.homeStubClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Class getRemoteStubClass() throws ConfigException {
        if (this.remoteStubClass != null) {
            return this.remoteStubClass;
        }
        BurlapClientContainer burlapClientContainer = this;
        synchronized (burlapClientContainer) {
            if (this.remoteStubClass != null) {
                return this.remoteStubClass;
            }
            Class remoteClass = this.getRemoteClass();
            if (remoteClass == null) {
                return null;
            }
            StubGenerator gen = new StubGenerator();
            this.remoteStubClass = gen.createObjectStub(remoteClass);
        }
        return this.remoteStubClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Class getHomeClass() throws ConfigException {
        if (this.homeClass != null) {
            return this.homeClass;
        }
        try {
            BurlapClientContainer burlapClientContainer = this;
            synchronized (burlapClientContainer) {
                if (this.homeClass != null) {
                    return this.homeClass;
                }
                String className = this.getHomeClassName();
                this.homeClass = CauchoSystem.loadClass(className, false, null);
            }
        }
        catch (ClassNotFoundException e) {
            throw new ConfigException(e);
        }
        return this.homeClass;
    }

    String getHomeClassName() throws ConfigException {
        AbstractServer server = EjbProtocolManager.getJVMServer(this.serverId);
        if (server != null) {
            Class cl = server.getRemoteHomeClass();
            if (cl != null) {
                return cl.getName();
            }
            throw new ConfigException(L.l("`{0}' has no remote interface.", this.serverId));
        }
        try {
            Path path = Vfs.lookup(this.serverId);
            return (String)MetaStub.call(path, "_burlap_getAttribute", "java.home.class");
        }
        catch (Throwable e) {
            throw new ConfigException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Class getRemoteClass() throws ConfigException {
        if (this.remoteClass != null) {
            return this.remoteClass;
        }
        try {
            BurlapClientContainer burlapClientContainer = this;
            synchronized (burlapClientContainer) {
                if (this.remoteClass != null) {
                    return this.remoteClass;
                }
                String className = this.getRemoteClassName();
                if (className == null || className.equals("null")) {
                    return null;
                }
                this.remoteClass = CauchoSystem.loadClass(className, false, null);
            }
        }
        catch (ClassNotFoundException e) {
            throw new ConfigException(e);
        }
        return this.remoteClass;
    }

    String getRemoteClassName() throws ConfigException {
        AbstractServer server = EjbProtocolManager.getJVMServer(this.serverId);
        if (server != null) {
            Class cl = server.getRemoteObjectClass();
            if (cl != null) {
                return cl.getName();
            }
            throw new ConfigException(L.l("`{0}' has no remote interface.", this.serverId));
        }
        try {
            Path path = Vfs.lookup(this.serverId);
            return (String)MetaStub.call(path, "_burlap_getAttribute", "java.object.class");
        }
        catch (Throwable e) {
            throw new ConfigException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Class getPrimaryKeyClass() throws ConfigException {
        if (this.primaryKeyClass != null) {
            return this.primaryKeyClass;
        }
        try {
            BurlapClientContainer burlapClientContainer = this;
            synchronized (burlapClientContainer) {
                if (this.primaryKeyClass != null) {
                    return this.primaryKeyClass;
                }
                String className = this.getPrimaryKeyClassName();
                this.primaryKeyClass = CauchoSystem.loadClass(className, false, null);
            }
        }
        catch (ClassNotFoundException e) {
            throw new ConfigException(e);
        }
        return this.primaryKeyClass;
    }

    String getPrimaryKeyClassName() throws ConfigException {
        AbstractServer server = EjbProtocolManager.getJVMServer(this.serverId);
        if (server != null) {
            Class cl = server.getPrimaryKeyClass();
            if (cl != null) {
                return cl.getName();
            }
            throw new ConfigException(L.l("`{0}' has no remote interface.", this.serverId));
        }
        try {
            Path path = Vfs.lookup(this.serverId);
            return (String)MetaStub.call(path, "_burlap_getAttribute", "primary-key-class");
        }
        catch (Throwable e) {
            throw new ConfigException(e);
        }
    }

    public Object lookup(String type, String url) throws IOException {
        try {
            Class api = CauchoSystem.loadClass(type);
            return this.create(api, url);
        }
        catch (Exception e) {
            throw new IOException(String.valueOf(e));
        }
    }

    public Object create(Class api, String url) throws Exception {
        StubGenerator gen = new StubGenerator();
        gen.setClassDir(CauchoSystem.getWorkPath());
        Class cl = gen.createStub(api);
        BurlapStub stub = (BurlapStub)cl.newInstance();
        stub._init(url, this);
        return stub;
    }

    String getBasicAuthentication() {
        return this._basicAuth;
    }

    void setBasicAuthentication(String auth) {
        this._basicAuth = auth != null ? new CharBuffer().append("Basic ").append(auth).toString() : auth;
    }

    public String toString() {
        return new CharBuffer().append("BurlapClientContainer[").append(this.serverId).append("]").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.ejb.burlap.BurlapClientContainer");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

