/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb;

import com.caucho.amber.AmberManager;
import com.caucho.amber.entity.AmberEntityHome;
import com.caucho.bytecode.JClassLoader;
import com.caucho.config.ConfigException;
import com.caucho.config.types.FileSetType;
import com.caucho.ejb.AbstractServer;
import com.caucho.ejb.EJBServerInterface;
import com.caucho.ejb.EnvServerManager;
import com.caucho.ejb.admin.EJBAdmin;
import com.caucho.ejb.cfg.EjbConfig;
import com.caucho.ejb.entity.EntityKey;
import com.caucho.ejb.entity.EntityServer;
import com.caucho.ejb.entity.QEntityContext;
import com.caucho.ejb.protocol.EjbProtocolManager;
import com.caucho.ejb.xa.EjbTransactionManager;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.EnvironmentListener;
import com.caucho.util.L10N;
import com.caucho.util.Log;
import com.caucho.vfs.JarPath;
import com.caucho.vfs.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.ConnectionFactory;
import javax.sql.DataSource;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbServerManager
implements EJBServerInterface,
EnvironmentListener {
    private static final L10N L = new L10N(EjbServerManager._resin_compat_class_0());
    protected static final Logger log = Log.open(EjbServerManager._resin_compat_class_0());
    private EnvironmentClassLoader _classLoader;
    private EnvServerManager _envServerManager;
    private boolean _autoCompile = true;
    private boolean _entityLoadLazyOnTransaction = true;
    protected boolean _allowJVMCall = true;
    protected boolean _allowReferenceCall = true;
    protected boolean _createDatabaseSchema;
    protected boolean _validateDatabaseSchema;
    private boolean _hasInitJdbc;
    private ConfigException _initException;
    private EjbConfig _ejbConfig;
    private AmberManager _amberManager;
    protected ConnectionFactory _jmsConnectionFactory;
    private int _messageConsumerMax = 5;
    private EntityKey _entityKey = new EntityKey();
    private final Lifecycle _lifecycle = new Lifecycle(log, "ejb-manager");
    private static Class _resin_compat_class_0;

    EjbServerManager() {
        try {
            this._amberManager = new AmberManager();
            this._envServerManager = new EnvServerManager(this._amberManager);
            this._ejbConfig = new EjbConfig(this);
            this._envServerManager.addEjbConfig(this._ejbConfig);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public EnvironmentClassLoader getClassLoader() {
        return this._envServerManager.getClassLoader();
    }

    public EnvServerManager getEnvServerManager() {
        return this._envServerManager;
    }

    public EjbProtocolManager getProtocolManager() {
        return this._envServerManager.getProtocolManager();
    }

    public EjbTransactionManager getTransactionManager() {
        return this._envServerManager.getTransactionManager();
    }

    public void setDataSource(DataSource dataSource) {
        this._amberManager.setDataSource(dataSource);
    }

    public DataSource getDataSource() {
        return this._amberManager.getDataSource();
    }

    public void setReadDataSource(DataSource dataSource) {
        this._amberManager.setReadDataSource(dataSource);
    }

    public DataSource getReadDataSource() {
        return this._amberManager.getReadDataSource();
    }

    public void setXADataSource(DataSource dataSource) {
        this._amberManager.setXADataSource(dataSource);
    }

    public DataSource getXADataSource() {
        return this._amberManager.getXADataSource();
    }

    public void setResinIsolation(int resinIsolation) {
        this.getTransactionManager().setResinIsolation(resinIsolation);
    }

    public int getResinIsolation() {
        return this.getTransactionManager().getResinIsolation();
    }

    public void setJDBCIsolation(int jdbcIsolation) {
        this.getTransactionManager().setJDBCIsolation(jdbcIsolation);
    }

    public int getJDBCIsolation() {
        return this.getTransactionManager().getJDBCIsolation();
    }

    public long getTransactionTimeout() {
        return this.getTransactionManager().getTransactionTimeout();
    }

    public void setTransactionTimeout(long transactionTimeout) {
        this.getTransactionManager().setTransactionTimeout(transactionTimeout);
    }

    public boolean isEntityLoadLazyOnTransaction() {
        return this._entityLoadLazyOnTransaction;
    }

    public void setEntityLoadLazyOnTransaction(boolean isLazy) {
        this._entityLoadLazyOnTransaction = isLazy;
    }

    public void setJMSConnectionFactory(ConnectionFactory factory) {
        this._jmsConnectionFactory = factory;
    }

    public void setMessageConsumerMax(int consumerMax) {
        this._messageConsumerMax = consumerMax;
    }

    public int getMessageConsumerMax() {
        return this._messageConsumerMax;
    }

    public ConnectionFactory getConnectionFactory() {
        return this._jmsConnectionFactory;
    }

    public Path getWorkPath() {
        return this._envServerManager.getWorkPath();
    }

    public void setWorkPath(Path workPath) {
        this._envServerManager.setWorkPath(workPath);
    }

    public boolean isAutoCompile() {
        return this._autoCompile;
    }

    public void setAutoCompile(boolean autoCompile) {
        this._autoCompile = autoCompile;
    }

    public boolean isAllowPOJO() {
        return this._ejbConfig.isAllowPOJO();
    }

    public void setAllowPOJO(boolean allowPOJO) {
        this._ejbConfig.setAllowPOJO(allowPOJO);
    }

    public void setAllowJVMCall(boolean allowJVMCall) {
        this._allowJVMCall = allowJVMCall;
    }

    public void setAllowReferenceCall(boolean allowReferenceCall) {
        this._allowReferenceCall = allowReferenceCall;
    }

    public void setCreateDatabaseSchema(boolean create) {
        this._createDatabaseSchema = create;
        this._amberManager.setCreateDatabaseTables(create);
    }

    public boolean getCreateDatabaseSchema() {
        return this._createDatabaseSchema;
    }

    public void setValidateDatabaseSchema(boolean validate) {
        this._validateDatabaseSchema = validate;
        this._amberManager.setValidateDatabaseTables(validate);
    }

    public boolean getValidateDatabaseSchema() {
        return this._validateDatabaseSchema;
    }

    public long getCacheTimeout() {
        return this._envServerManager.getCacheTimeout();
    }

    public void setCacheTimeout(long cacheTimeout) {
        this._envServerManager.setCacheTimeout(cacheTimeout);
    }

    public int getCacheSize() {
        return this._envServerManager.getCacheSize();
    }

    public void setCacheSize(int cacheSize) {
        this._envServerManager.setCacheSize(cacheSize);
    }

    public EJBAdmin getAdmin() {
        return this._envServerManager.getAdmin();
    }

    public EjbConfig getConfig() {
        return this._ejbConfig;
    }

    public void addConfigFiles(FileSetType fileSet) {
        this._ejbConfig.addFileSet(fileSet);
    }

    @Override
    public void addEJBJar(Path path) throws Exception {
        Path metaInf;
        JarPath jar = path instanceof JarPath ? (JarPath)path : JarPath.create(path);
        Path descriptorPath = jar.lookup("META-INF/ejb-jar.xml");
        if (descriptorPath.exists()) {
            this.addEJBPath(descriptorPath);
        }
        if ((descriptorPath = jar.lookup("META-INF/resin-ejb-jar.xml")).exists()) {
            this.addEJBPath(descriptorPath);
        }
        if ((metaInf = jar.lookup("META-INF")).isDirectory()) {
            String[] metaList = metaInf.list();
            for (int j = 0; j < metaList.length; ++j) {
                String metaName = metaList[j];
                if (!metaName.endsWith(".ejb")) continue;
                Path metaPath = metaInf.lookup(metaName);
                this.addEJBPath(metaPath);
            }
        }
    }

    public void addEJBPath(Path path) throws ConfigException {
        this._ejbConfig.addEJBPath(path);
    }

    @Override
    public void initEJBs() throws Exception {
        this.init();
    }

    public void init() throws Exception {
        this._envServerManager.init();
        this.build();
    }

    public void build() throws ConfigException {
        try {
            this._amberManager.init();
            this._ejbConfig.configure();
        }
        catch (ConfigException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigException(e);
        }
    }

    public void start() throws Exception {
        this._envServerManager.start();
    }

    public AmberEntityHome getAmberEntityHome(String name) {
        return this._amberManager.getEntityHome(name);
    }

    public AmberManager getAmberManager() {
        return this._amberManager;
    }

    public JClassLoader getJClassLoader() {
        return this.getAmberManager().getJClassLoader();
    }

    public void invalidateCache() {
    }

    public void addServer(AbstractServer server) {
        this._envServerManager.addServer(server);
    }

    public AbstractServer getServer(String serverId) {
        return this._envServerManager.getServer(serverId);
    }

    public AbstractServer getServerByEJBName(String ejbName) {
        return this._envServerManager.getServerByEJBName(ejbName);
    }

    public QEntityContext getEntity(EntityServer server, Object key) {
        return this._envServerManager.getEntity(server, key);
    }

    public QEntityContext putEntityIfNew(EntityServer server, Object key, QEntityContext context) {
        return this._envServerManager.putEntityIfNew(server, key, context);
    }

    public void removeEntity(EntityServer server, Object key) {
        this._envServerManager.removeEntity(server, key);
    }

    public void removeBeans(ArrayList<QEntityContext> beans, EntityServer server) {
        this._envServerManager.removeBeans(beans, server);
    }

    @Override
    public void environmentStart(EnvironmentClassLoader loader) throws Throwable {
        this.start();
    }

    @Override
    public void environmentStop(EnvironmentClassLoader loader) {
    }

    public void destroy() {
        if (!this._lifecycle.toDestroy()) {
            return;
        }
        this._envServerManager.destroy();
        try {
            this._ejbConfig = null;
            this._envServerManager = null;
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.ejb.EjbServerManager");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ServerCmp
    implements Comparator<AbstractServer> {
        ServerCmp() {
        }

        @Override
        public int compare(AbstractServer a, AbstractServer b) {
            return a.getEJBName().compareTo(b.getEJBName());
        }
    }
}

