/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb;

import com.caucho.ejb.EjbServerManager;
import com.caucho.ejb.protocol.ProtocolContainer;
import com.caucho.ejb.protocol.Skeleton;
import com.caucho.log.Log;
import com.caucho.naming.Jndi;
import com.caucho.server.connection.AbstractHttpRequest;
import com.caucho.server.connection.AbstractHttpResponse;
import com.caucho.server.webapp.Application;
import com.caucho.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.GenericServlet;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class EJBServlet
extends GenericServlet {
    private static final L10N L = new L10N(EJBServlet._resin_compat_class_0());
    private final Logger log = Log.open(EJBServlet._resin_compat_class_0());
    private String _urlPrefix;
    private String _ejbServerJndiName = "java:comp/env/cmp";
    private String _containerId;
    private String _servletId;
    private String _localId;
    private boolean _isDebug;
    private Hashtable<CharSequence, Skeleton> _beanMap = new Hashtable();
    private EjbServerManager _ejbManager;
    private ProtocolContainer _protocolContainer;
    private ServletException _exception;
    private Path _workPath;
    private static Class _resin_compat_class_0;

    protected String getDefaultProtocolContainer() {
        return "com.caucho.hessian.HessianProtocol";
    }

    public void setDebug(boolean debug) {
        this._isDebug = debug;
    }

    public void init() throws ServletException {
        this._ejbManager = (EjbServerManager)Jndi.lookup(new CharBuffer().append(this._ejbServerJndiName).append("/resin-ejb-server").toString());
        if (this._ejbManager == null) {
            throw new ServletException(L.l("No <ejb-server> detected.  '{0}' requires a configured <ejb-server>", ((Object)((Object)this)).getClass().getName()));
        }
        this._workPath = CauchoSystem.getWorkPath();
        this._urlPrefix = this.getInitParameter("url-prefix");
        this._localId = this.getInitParameter("local-prefix");
        String protocol = this.getInitParameter("protocol");
        if (protocol == null) {
            protocol = this.getInitParameter("protocol-container");
        }
        if (protocol == null) {
            protocol = this.getInitParameter("protocol-factory");
        }
        if (protocol == null) {
            protocol = this.getDefaultProtocolContainer();
        }
        try {
            Class cl = CauchoSystem.loadClass(protocol);
            this._protocolContainer = (ProtocolContainer)cl.newInstance();
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        Application app = (Application)this.getServletContext();
        this.initEjb();
        if (this._urlPrefix != null) {
            this.initProtocol();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        AbstractHttpRequest req = (AbstractHttpRequest)request;
        AbstractHttpResponse res = (AbstractHttpResponse)response;
        if (this._urlPrefix == null) {
            EJBServlet eJBServlet = this;
            synchronized (eJBServlet) {
                if (this._urlPrefix == null) {
                    this.serverInit(req);
                }
            }
        }
        if (!req.getMethod().equals("POST")) {
            String protocol = this._protocolContainer.getName();
            res.setStatus(500, new CharBuffer().append(protocol).append(" Protocol Error").toString());
            PrintWriter out = res.getWriter();
            out.println(new CharBuffer().append(protocol).append(" expects a POST containing an RPC call.").toString());
            return;
        }
        try {
            Skeleton skeleton;
            String pathInfo = req.getPathInfo();
            String queryString = req.getQueryString();
            CharBuffer cb = new CharBuffer();
            cb.append(pathInfo);
            cb.append('?');
            cb.append(queryString);
            ServletInputStream is = req.getInputStream();
            if (this._isDebug) {
                // empty if block
            }
            if ((skeleton = this._beanMap.get(cb)) == null) {
                if (req.getParameter("ejb-load") != null) {
                    return;
                }
                if (this._exception != null) {
                    throw this._exception;
                }
                try {
                    skeleton = this._protocolContainer.getSkeleton(pathInfo, queryString);
                }
                catch (Throwable e) {
                    skeleton = this._protocolContainer.getExceptionSkeleton();
                    if (skeleton != null) {
                        skeleton._service((InputStream)req.getInputStream(), (OutputStream)res.getOutputStream(), e);
                        return;
                    }
                    throw e;
                }
                if (skeleton == null) {
                    throw new ServletException(L.l("Can't load skeleton for `{0}?{1}'", (Object)pathInfo, queryString));
                }
                if (skeleton != null) {
                    skeleton.setDebug(this._isDebug);
                    this._beanMap.put(cb, skeleton);
                }
            }
            skeleton._service((InputStream)req.getInputStream(), (OutputStream)res.getOutputStream());
        }
        catch (ServletException e) {
            throw e;
        }
        catch (Throwable e) {
            this.log.log(Level.WARNING, e.toString(), e);
            throw new ServletException(e);
        }
    }

    Skeleton getSkeleton(String pathInfo, String queryString) throws Exception {
        CharBuffer cb = CharBuffer.allocate();
        cb.append(pathInfo);
        cb.append('?');
        cb.append(queryString);
        Skeleton skeleton = this._beanMap.get(cb);
        if (skeleton != null) {
            cb.free();
            return skeleton;
        }
        skeleton = this._protocolContainer.getSkeleton(pathInfo, queryString);
        this._beanMap.put(cb, skeleton);
        return skeleton;
    }

    private void serverInit(AbstractHttpRequest req) throws ServletException {
        if (this._urlPrefix != null) {
            return;
        }
        Application app = (Application)this.getServletContext();
        this._servletId = req.getServletPath();
        CharBuffer cb = CharBuffer.allocate();
        if (req.getServerName().equals("")) {
            cb.append(app.getURL());
        } else {
            cb.append(req.getScheme());
            cb.append("://");
            cb.append(req.getServerName());
            int port = req.getServerPort();
            if (port != 80) {
                cb.append(":");
                cb.append(port);
            }
            cb.append(app.getContextPath());
        }
        cb.append(this._servletId);
        this._urlPrefix = cb.close();
        this.initProtocol();
    }

    private void initProtocol() {
        this.normalizeId();
        this._protocolContainer.setProtocolManager(this._ejbManager.getProtocolManager());
        this._protocolContainer.setURLPrefix(this._urlPrefix);
        this._protocolContainer.setWorkPath(this._workPath);
        this._ejbManager.getProtocolManager().addProtocolContainer(this._protocolContainer);
    }

    private void normalizeId() {
        if (this._urlPrefix == null) {
            return;
        }
        Application application = (Application)this.getServletContext();
        String hostName = "localhost";
        String contextPath = application.getContextPath();
        if (this._urlPrefix.startsWith("/")) {
            this._servletId = this._urlPrefix;
            this._urlPrefix = new CharBuffer().append(application.getURL()).append(this._urlPrefix).toString();
        } else if (this._urlPrefix.startsWith("http://")) {
            int p = this._urlPrefix.indexOf(47, "http://".length());
            String uri = this._urlPrefix;
            uri = p > 0 ? this._urlPrefix.substring(p) : "";
            if (uri.startsWith(contextPath)) {
                this._servletId = uri.substring(contextPath.length());
            } else if (this._servletId == null) {
                this._servletId = uri;
            }
        } else if (this._urlPrefix.startsWith("https://")) {
            int p = this._urlPrefix.indexOf(47, "https://".length());
            String uri = this._urlPrefix;
            uri = p > 0 ? this._urlPrefix.substring(p) : "";
            if (uri.startsWith(contextPath)) {
                this._servletId = uri.substring(contextPath.length());
            } else if (this._servletId == null) {
                this._servletId = uri;
            }
        } else if (this._urlPrefix.startsWith("cron:")) {
            this._urlPrefix = new CharBuffer().append(application.getURL()).append(this._servletId).toString();
        } else {
            this._servletId = this._urlPrefix;
        }
        if (this._servletId.equals("")) {
            this._servletId = "/";
        }
    }

    private void initEjb() throws ServletException {
        if (this._ejbManager != null) {
            return;
        }
        if (this._urlPrefix != null) {
            this.normalizeId();
            this._protocolContainer.setServerManager(this._ejbManager);
            this._protocolContainer.setURLPrefix(this._urlPrefix);
            this._protocolContainer.setWorkPath(this._workPath);
            this._ejbManager.getProtocolManager().addProtocolContainer(this._protocolContainer);
        }
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.ejb.EJBServlet");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

