/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb;

import com.caucho.ejb.AbstractServer;
import com.caucho.ejb.xa.TransactionContext;
import com.caucho.security.SecurityContext;
import com.caucho.security.SecurityContextException;
import com.caucho.util.L10N;
import com.caucho.util.Log;
import java.rmi.RemoteException;
import java.security.Identity;
import java.security.Principal;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJBContext;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBMetaData;
import javax.ejb.EJBObject;
import javax.ejb.Handle;
import javax.ejb.HomeHandle;
import javax.ejb.RemoveException;
import javax.transaction.UserTransaction;

public abstract class AbstractContext
implements EJBContext {
    protected static final L10N L = new L10N(AbstractContext._resin_compat_class_0());
    protected static final Logger log = Log.open(AbstractContext._resin_compat_class_0());
    private boolean _isDead;
    private static Class _resin_compat_class_0;

    public boolean isDead() {
        return this._isDead;
    }

    protected abstract AbstractServer getServer();

    public EJBMetaData getEJBMetaData() {
        return this.getServer().getEJBMetaData();
    }

    public EJBHome getEJBHome() {
        try {
            return this.getServer().getEJBHome();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
            return null;
        }
    }

    public EJBLocalHome getEJBLocalHome() {
        try {
            return this.getServer().getEJBLocalHome();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Handle getHandle() {
        throw new UnsupportedOperationException();
    }

    public HomeHandle getHomeHandle() {
        return this.getServer().getHomeHandle();
    }

    public EJBLocalObject getEJBLocalObject() throws IllegalStateException {
        throw new IllegalStateException(L.l("`{0}' has no local interface.  Local beans need a local-home and a local interface.  Remote beans must be called with a remote context.", this.getServer().getEJBName()));
    }

    public EJBObject getEJBObject() {
        return this.getRemoteView();
    }

    public EJBObject getRemoteView() {
        throw new IllegalStateException(L.l("`{0}' has no remote interface.  Remote beans need a home and a remote interface.  Local beans must be called with a local context.", this.getServer().getEJBName()));
    }

    public EJBHome createRemoteHomeView() {
        return null;
    }

    public EJBLocalHome createLocalHome() {
        return null;
    }

    public Properties getEnvironment() {
        return new Properties();
    }

    public Identity getCallerIdentity() {
        return null;
    }

    public Principal getCallerPrincipal() {
        try {
            return SecurityContext.getUserPrincipal();
        }
        catch (SecurityContextException e) {
            log.log(Level.WARNING, e.toString(), e);
            return null;
        }
    }

    public boolean isCallerInRole(Identity role) {
        return false;
    }

    public boolean isCallerInRole(String roleName) {
        return SecurityContext.isUserInRole(roleName);
    }

    public void remove() throws RemoveException {
        EJBObject obj = null;
        try {
            obj = this.getEJBObject();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (obj != null) {
                obj.remove();
                return;
            }
        }
        catch (RemoteException e) {
            // empty catch block
        }
        EJBLocalObject local = null;
        try {
            local = this.getEJBLocalObject();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (local != null) {
            local.remove();
            return;
        }
    }

    public UserTransaction getUserTransaction() throws IllegalStateException {
        return this.getServer().getUserTransaction();
    }

    public void setRollbackOnly() throws IllegalStateException {
        TransactionContext trans = this.getServer().getTransaction();
        if (trans == null) {
            throw new IllegalStateException("invalid transaction");
        }
        trans.setRollbackOnly();
    }

    public boolean getRollbackOnly() throws IllegalStateException {
        TransactionContext trans = this.getServer().getTransaction();
        if (trans != null) {
            return trans.getRollbackOnly();
        }
        throw new IllegalStateException("invalid transaction");
    }

    public void destroy() throws Exception {
        this._isDead = true;
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.ejb.AbstractContext");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

